/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.util;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;

public class CredentialProviderUtility {
    private static final String[] KEYS = new String[]{"keystore.password", "truststore.password", "password"};
    private static TextDevice DEFAULT_TEXT_DEVICE;
    public static TextDevice textDevice;

    public static void main(String[] args) throws IOException {
        CredentialProvider provider = CredentialProviderUtility.getCredentialProvider(textDevice);
        for (String key : KEYS) {
            char[] cred = CredentialProviderUtility.getPassword(textDevice, key);
            boolean overwrite = true;
            if (provider.getCredentialEntry(key) != null) {
                String choice = textDevice.readLine("Entry for %s already exists.  Overwrite? (y/n) [y]:", key);
                boolean bl = overwrite = StringUtils.isEmpty((String)choice) || choice.equalsIgnoreCase("y");
                if (overwrite) {
                    provider.deleteCredentialEntry(key);
                    provider.flush();
                    provider.createCredentialEntry(key, cred);
                    provider.flush();
                    textDevice.printf("Entry for %s was overwritten with the new value.\n", key);
                    continue;
                }
                textDevice.printf("Entry for %s was not overwritten.\n", key);
                continue;
            }
            provider.createCredentialEntry(key, cred);
            provider.flush();
        }
    }

    private static char[] getPassword(TextDevice textDevice, String key) {
        boolean noMatch;
        char[] cred = new char[]{};
        do {
            char[] passwd1 = textDevice.readPassword("Please enter the password value for %s:", key);
            char[] passwd2 = textDevice.readPassword("Please enter the password value for %s again:", key);
            boolean bl = noMatch = !Arrays.equals(passwd1, passwd2);
            if (noMatch) {
                if (passwd1 != null) {
                    Arrays.fill(passwd1, ' ');
                }
                textDevice.printf("Password entries don't match. Please try again.\n", new Object[0]);
            } else if (passwd1.length == 0) {
                textDevice.printf("An empty password is not valid.  Please try again.\n", new Object[0]);
                noMatch = true;
            } else {
                cred = passwd1;
            }
            if (passwd2 == null) continue;
            Arrays.fill(passwd2, ' ');
        } while (noMatch);
        return cred;
    }

    private static CredentialProvider getCredentialProvider(TextDevice textDevice) throws IOException {
        String providerPath = textDevice.readLine("Please enter the full path to the credential provider:", new Object[0]);
        File file = new File(providerPath);
        if (file.exists()) {
            textDevice.printf("%s already exists.  You will need to specify whether existing entries should be overwritten (default is 'yes')\n", providerPath);
        }
        String providerURI = "jceks://file" + providerPath;
        Configuration conf = new Configuration(false);
        conf.set("hadoop.security.credential.provider.path", providerURI);
        return (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)conf).get(0);
    }

    static {
        textDevice = DEFAULT_TEXT_DEVICE = new TextDevice(){
            Console console = System.console();

            @Override
            public void printf(String fmt, Object ... params) {
                this.console.printf(fmt, params);
            }

            @Override
            public String readLine(String fmt, Object ... args) {
                return this.console.readLine(fmt, args);
            }

            @Override
            public char[] readPassword(String fmt, Object ... args) {
                return this.console.readPassword(fmt, args);
            }
        };
    }

    public static abstract class TextDevice {
        public abstract void printf(String var1, Object ... var2);

        public abstract String readLine(String var1, Object ... var2);

        public abstract char[] readPassword(String var1, Object ... var2);
    }
}

