/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.examples;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.typesystem.IStruct;
import org.apache.atlas.typesystem.Referenceable;
import org.apache.atlas.typesystem.TypesDef;
import org.apache.atlas.typesystem.json.InstanceSerialization;
import org.apache.atlas.typesystem.json.TypesSerialization;
import org.apache.atlas.typesystem.persistence.Id;
import org.apache.atlas.typesystem.types.AttributeDefinition;
import org.apache.atlas.typesystem.types.DataTypes;
import org.apache.atlas.typesystem.types.HierarchicalTypeDefinition;
import org.apache.atlas.typesystem.types.IDataType;
import org.apache.atlas.typesystem.types.Multiplicity;
import org.apache.atlas.typesystem.types.TypeUtils;
import org.apache.atlas.typesystem.types.utils.TypesUtil;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

public class QuickStart {
    private static final String DATABASE_TYPE = "DB";
    private static final String COLUMN_TYPE = "Column";
    private static final String TABLE_TYPE = "Table";
    private static final String VIEW_TYPE = "View";
    private static final String LOAD_PROCESS_TYPE = "LoadProcess";
    private static final String STORAGE_DESC_TYPE = "StorageDesc";
    private static final String[] TYPES = new String[]{"DB", "Table", "StorageDesc", "Column", "LoadProcess", "View", "JdbcAccess", "ETL", "Metric", "PII", "Fact", "Dimension"};
    private final AtlasClient metadataServiceClient;

    public static void main(String[] args) throws Exception {
        String baseUrl = QuickStart.getServerUrl(args);
        QuickStart quickStart = new QuickStart(baseUrl);
        quickStart.createTypes();
        quickStart.createEntities();
        quickStart.search();
    }

    static String getServerUrl(String[] args) {
        String baseUrl = "http://localhost:21000";
        if (args.length > 0) {
            baseUrl = args[0];
        }
        return baseUrl;
    }

    QuickStart(String baseUrl) {
        this.metadataServiceClient = new AtlasClient(baseUrl);
    }

    void createTypes() throws Exception {
        TypesDef typesDef = this.createTypeDefinitions();
        String typesAsJSON = TypesSerialization.toJson((TypesDef)typesDef);
        System.out.println("typesAsJSON = " + typesAsJSON);
        this.metadataServiceClient.createType(typesAsJSON);
        this.verifyTypesCreated();
    }

    TypesDef createTypeDefinitions() throws Exception {
        HierarchicalTypeDefinition dbClsDef = TypesUtil.createClassTypeDef((String)DATABASE_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("name", (IDataType)DataTypes.STRING_TYPE), this.attrDef("description", (IDataType)DataTypes.STRING_TYPE), this.attrDef("locationUri", (IDataType)DataTypes.STRING_TYPE), this.attrDef("owner", (IDataType)DataTypes.STRING_TYPE), this.attrDef("createTime", (IDataType)DataTypes.INT_TYPE)});
        HierarchicalTypeDefinition storageDescClsDef = TypesUtil.createClassTypeDef((String)STORAGE_DESC_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("location", (IDataType)DataTypes.STRING_TYPE), this.attrDef("inputFormat", (IDataType)DataTypes.STRING_TYPE), this.attrDef("outputFormat", (IDataType)DataTypes.STRING_TYPE), this.attrDef("compressed", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED, false, null)});
        HierarchicalTypeDefinition columnClsDef = TypesUtil.createClassTypeDef((String)COLUMN_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("name", (IDataType)DataTypes.STRING_TYPE), this.attrDef("dataType", (IDataType)DataTypes.STRING_TYPE), this.attrDef("comment", (IDataType)DataTypes.STRING_TYPE)});
        HierarchicalTypeDefinition tblClsDef = TypesUtil.createClassTypeDef((String)TABLE_TYPE, (ImmutableList)ImmutableList.of((Object)"DataSet"), (AttributeDefinition[])new AttributeDefinition[]{new AttributeDefinition("db", DATABASE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition("sd", STORAGE_DESC_TYPE, Multiplicity.REQUIRED, true, null), this.attrDef("owner", (IDataType)DataTypes.STRING_TYPE), this.attrDef("createTime", (IDataType)DataTypes.INT_TYPE), this.attrDef("lastAccessTime", (IDataType)DataTypes.INT_TYPE), this.attrDef("retention", (IDataType)DataTypes.INT_TYPE), this.attrDef("viewOriginalText", (IDataType)DataTypes.STRING_TYPE), this.attrDef("viewExpandedText", (IDataType)DataTypes.STRING_TYPE), this.attrDef("tableType", (IDataType)DataTypes.STRING_TYPE), this.attrDef("temporary", (IDataType)DataTypes.BOOLEAN_TYPE), new AttributeDefinition("columns", DataTypes.arrayTypeName((String)COLUMN_TYPE), Multiplicity.COLLECTION, true, null)});
        HierarchicalTypeDefinition loadProcessClsDef = TypesUtil.createClassTypeDef((String)LOAD_PROCESS_TYPE, (ImmutableList)ImmutableList.of((Object)"Process"), (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("userName", (IDataType)DataTypes.STRING_TYPE), this.attrDef("startTime", (IDataType)DataTypes.INT_TYPE), this.attrDef("endTime", (IDataType)DataTypes.INT_TYPE), this.attrDef("queryText", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED), this.attrDef("queryPlan", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED), this.attrDef("queryId", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED), this.attrDef("queryGraph", (IDataType)DataTypes.STRING_TYPE, Multiplicity.REQUIRED)});
        HierarchicalTypeDefinition viewClsDef = TypesUtil.createClassTypeDef((String)VIEW_TYPE, null, (AttributeDefinition[])new AttributeDefinition[]{this.attrDef("name", (IDataType)DataTypes.STRING_TYPE), new AttributeDefinition("db", DATABASE_TYPE, Multiplicity.REQUIRED, false, null), new AttributeDefinition("inputTables", DataTypes.arrayTypeName((String)TABLE_TYPE), Multiplicity.COLLECTION, false, null)});
        HierarchicalTypeDefinition dimTraitDef = TypesUtil.createTraitTypeDef((String)"Dimension", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition factTraitDef = TypesUtil.createTraitTypeDef((String)"Fact", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition piiTraitDef = TypesUtil.createTraitTypeDef((String)"PII", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition metricTraitDef = TypesUtil.createTraitTypeDef((String)"Metric", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition etlTraitDef = TypesUtil.createTraitTypeDef((String)"ETL", null, (AttributeDefinition[])new AttributeDefinition[0]);
        HierarchicalTypeDefinition jdbcTraitDef = TypesUtil.createTraitTypeDef((String)"JdbcAccess", null, (AttributeDefinition[])new AttributeDefinition[0]);
        return TypeUtils.getTypesDef((ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of(), (ImmutableList)ImmutableList.of((Object)dimTraitDef, (Object)factTraitDef, (Object)piiTraitDef, (Object)metricTraitDef, (Object)etlTraitDef, (Object)jdbcTraitDef), (ImmutableList)ImmutableList.of((Object)dbClsDef, (Object)storageDescClsDef, (Object)columnClsDef, (Object)tblClsDef, (Object)loadProcessClsDef, (Object)viewClsDef));
    }

    AttributeDefinition attrDef(String name, IDataType dT) {
        return this.attrDef(name, dT, Multiplicity.OPTIONAL, false, null);
    }

    AttributeDefinition attrDef(String name, IDataType dT, Multiplicity m) {
        return this.attrDef(name, dT, m, false, null);
    }

    AttributeDefinition attrDef(String name, IDataType dT, Multiplicity m, boolean isComposite, String reverseAttributeName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)dT);
        return new AttributeDefinition(name, dT.getName(), m, isComposite, reverseAttributeName);
    }

    void createEntities() throws Exception {
        Id salesDB = this.database("Sales", "Sales Database", "John ETL", "hdfs://host:8000/apps/warehouse/sales", new String[0]);
        Referenceable sd = this.rawStorageDescriptor("hdfs://host:8000/apps/warehouse/sales", "TextInputFormat", "TextOutputFormat", true);
        ImmutableList salesFactColumns = ImmutableList.of((Object)this.rawColumn("time_id", "int", "time id", new String[0]), (Object)this.rawColumn("product_id", "int", "product id", new String[0]), (Object)this.rawColumn("customer_id", "int", "customer id", "PII"), (Object)this.rawColumn("sales", "double", "product id", "Metric"));
        Id salesFact = this.table("sales_fact", "sales fact table", salesDB, sd, "Joe", "Managed", (List<Referenceable>)salesFactColumns, "Fact");
        ImmutableList productDimColumns = ImmutableList.of((Object)this.rawColumn("product_id", "int", "product id", new String[0]), (Object)this.rawColumn("product_name", "string", "product name", new String[0]), (Object)this.rawColumn("brand_name", "int", "brand name", new String[0]));
        Id productDim = this.table("product_dim", "product dimension table", salesDB, sd, "John Doe", "Managed", (List<Referenceable>)productDimColumns, "Dimension");
        ImmutableList timeDimColumns = ImmutableList.of((Object)this.rawColumn("time_id", "int", "time id", new String[0]), (Object)this.rawColumn("dayOfYear", "int", "day Of Year", new String[0]), (Object)this.rawColumn("weekDay", "int", "week Day", new String[0]));
        Id timeDim = this.table("time_dim", "time dimension table", salesDB, sd, "John Doe", "External", (List<Referenceable>)timeDimColumns, "Dimension");
        ImmutableList customerDimColumns = ImmutableList.of((Object)this.rawColumn("customer_id", "int", "customer id", "PII"), (Object)this.rawColumn("name", "string", "customer name", "PII"), (Object)this.rawColumn("address", "string", "customer address", "PII"));
        Id customerDim = this.table("customer_dim", "customer dimension table", salesDB, sd, "fetl", "External", (List<Referenceable>)customerDimColumns, "Dimension");
        Id reportingDB = this.database("Reporting", "reporting database", "Jane BI", "hdfs://host:8000/apps/warehouse/reporting", new String[0]);
        Id salesFactDaily = this.table("sales_fact_daily_mv", "sales fact daily materialized view", reportingDB, sd, "Joe BI", "Managed", (List<Referenceable>)salesFactColumns, "Metric");
        this.loadProcess("loadSalesDaily", "hive query for daily summary", "John ETL", (List<Id>)ImmutableList.of((Object)salesFact, (Object)timeDim), (List<Id>)ImmutableList.of((Object)salesFactDaily), "create table as select ", "plan", "id", "graph", "ETL");
        this.view("product_dim_view", reportingDB, (List<Id>)ImmutableList.of((Object)productDim), "Dimension", "JdbcAccess");
        this.view("customer_dim_view", reportingDB, (List<Id>)ImmutableList.of((Object)customerDim), "Dimension", "JdbcAccess");
        Id salesFactMonthly = this.table("sales_fact_monthly_mv", "sales fact monthly materialized view", reportingDB, sd, "Jane BI", "Managed", (List<Referenceable>)salesFactColumns, "Metric");
        this.loadProcess("loadSalesMonthly", "hive query for monthly summary", "John ETL", (List<Id>)ImmutableList.of((Object)salesFactDaily), (List<Id>)ImmutableList.of((Object)salesFactMonthly), "create table as select ", "plan", "id", "graph", "ETL");
    }

    private Id createInstance(Referenceable referenceable) throws Exception {
        String typeName = referenceable.getTypeName();
        String entityJSON = InstanceSerialization.toJson((IStruct)referenceable, (boolean)true);
        System.out.println("Submitting new entity= " + entityJSON);
        JSONObject jsonObject = this.metadataServiceClient.createEntity(entityJSON);
        String guid = jsonObject.getString("GUID");
        System.out.println("created instance for type " + typeName + ", guid: " + guid);
        return new Id(guid, referenceable.getId().getVersion(), referenceable.getTypeName());
    }

    Id database(String name, String description, String owner, String locationUri, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(DATABASE_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("description", (Object)description);
        referenceable.set("owner", (Object)owner);
        referenceable.set("locationUri", (Object)locationUri);
        referenceable.set("createTime", (Object)System.currentTimeMillis());
        return this.createInstance(referenceable);
    }

    Referenceable rawStorageDescriptor(String location, String inputFormat, String outputFormat, boolean compressed) throws Exception {
        Referenceable referenceable = new Referenceable(STORAGE_DESC_TYPE, new String[0]);
        referenceable.set("location", (Object)location);
        referenceable.set("inputFormat", (Object)inputFormat);
        referenceable.set("outputFormat", (Object)outputFormat);
        referenceable.set("compressed", (Object)compressed);
        return referenceable;
    }

    Referenceable rawColumn(String name, String dataType, String comment, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(COLUMN_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("dataType", (Object)dataType);
        referenceable.set("comment", (Object)comment);
        return referenceable;
    }

    Id table(String name, String description, Id dbId, Referenceable sd, String owner, String tableType, List<Referenceable> columns, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(TABLE_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("description", (Object)description);
        referenceable.set("owner", (Object)owner);
        referenceable.set("tableType", (Object)tableType);
        referenceable.set("createTime", (Object)System.currentTimeMillis());
        referenceable.set("lastAccessTime", (Object)System.currentTimeMillis());
        referenceable.set("retention", (Object)System.currentTimeMillis());
        referenceable.set("db", (Object)dbId);
        referenceable.set("sd", (Object)sd);
        referenceable.set("columns", columns);
        return this.createInstance(referenceable);
    }

    Id loadProcess(String name, String description, String user, List<Id> inputTables, List<Id> outputTables, String queryText, String queryPlan, String queryId, String queryGraph, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(LOAD_PROCESS_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("description", (Object)description);
        referenceable.set("inputs", inputTables);
        referenceable.set("outputs", outputTables);
        referenceable.set("user", (Object)user);
        referenceable.set("startTime", (Object)System.currentTimeMillis());
        referenceable.set("endTime", (Object)(System.currentTimeMillis() + 10000L));
        referenceable.set("queryText", (Object)queryText);
        referenceable.set("queryPlan", (Object)queryPlan);
        referenceable.set("queryId", (Object)queryId);
        referenceable.set("queryGraph", (Object)queryGraph);
        return this.createInstance(referenceable);
    }

    Id view(String name, Id dbId, List<Id> inputTables, String ... traitNames) throws Exception {
        Referenceable referenceable = new Referenceable(VIEW_TYPE, traitNames);
        referenceable.set("name", (Object)name);
        referenceable.set("db", (Object)dbId);
        referenceable.set("inputTables", inputTables);
        return this.createInstance(referenceable);
    }

    private void verifyTypesCreated() throws Exception {
        List types = this.metadataServiceClient.listTypes();
        for (String type : TYPES) {
            assert (types.contains(type));
        }
    }

    private String[] getDSLQueries() {
        return new String[]{"from DB", DATABASE_TYPE, "DB where name=\"Reporting\"", "DB where DB.name=\"Reporting\"", "DB name = \"Reporting\"", "DB DB.name = \"Reporting\"", "DB where name=\"Reporting\" select name, owner", "DB where DB.name=\"Reporting\" select name, owner", "DB has name", "DB where DB has name", "DB, Table", "DB is JdbcAccess", "from Table", TABLE_TYPE, "Table is Dimension", "Column where Column isa PII", "View is Dimension", "Column select Column.name", "Column select name", "Column where Column.name=\"customer_id\"", "from Table select Table.name", "DB where (name = \"Reporting\")", "DB where (name = \"Reporting\") select name as _col_0, owner as _col_1", "DB where DB is JdbcAccess", "DB where DB has name", "DB Table", "DB where DB has name", "DB as db1 Table where (db1.name = \"Reporting\")", "DB where (name = \"Reporting\") select name as _col_0, (createTime + 1) as _col_1 ", "Dimension", "JdbcAccess", "ETL", "Metric", "PII", "Table where name=\"sales_fact\", columns", "Table where name=\"sales_fact\", columns as column select column.name, column.dataType, column.comment", "from DataSet", "from Process"};
    }

    private void search() throws Exception {
        for (String dslQuery : this.getDSLQueries()) {
            JSONObject response = this.metadataServiceClient.searchEntity(dslQuery);
            JSONObject results = response.getJSONObject("results");
            if (!results.isNull("rows")) {
                JSONArray rows = results.getJSONArray("rows");
                System.out.println("query [" + dslQuery + "] returned [" + rows.length() + "] rows");
                continue;
            }
            System.out.println("query [" + dslQuery + "] failed, results:" + results.toString());
        }
    }
}

