/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.Iterator;
import org.apache.atlas.PropertiesUtil;
import org.apache.atlas.web.service.EmbeddedServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String APP_PATH = "app";
    private static final String APP_PORT = "port";
    private static final String ATLAS_HOME = "atlas.home";
    private static final String ATLAS_LOG_DIR = "atlas.log.dir";

    private Main() {
    }

    private static CommandLine parseArgs(String[] args) throws ParseException {
        Options options = new Options();
        Option opt = new Option(APP_PATH, true, "Application Path");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option(APP_PORT, true, "Application Port");
        opt.setRequired(false);
        options.addOption(opt);
        return new GnuParser().parse(options, args);
    }

    public static void main(String[] args) throws Exception {
        CommandLine cmd = Main.parseArgs(args);
        PropertiesConfiguration buildConfiguration = new PropertiesConfiguration("atlas-buildinfo.properties");
        String appPath = "webapp/target/atlas-webapp-" + Main.getProjectVersion(buildConfiguration);
        if (cmd.hasOption(APP_PATH)) {
            appPath = cmd.getOptionValue(APP_PATH);
        }
        Main.setApplicationHome();
        PropertiesConfiguration configuration = PropertiesUtil.getApplicationProperties();
        String enableTLSFlag = configuration.getString("atlas.enableTLS");
        int appPort = Main.getApplicationPort(cmd, enableTLSFlag);
        boolean enableTLS = Main.isTLSEnabled(enableTLSFlag, appPort);
        configuration.setProperty("atlas.enableTLS", (Object)String.valueOf(enableTLS));
        Main.showStartupInfo(buildConfiguration, enableTLS, appPort);
        EmbeddedServer server = EmbeddedServer.newServer(appPort, appPath, enableTLS);
        server.start();
    }

    private static void setApplicationHome() {
        if (System.getProperty(ATLAS_HOME) == null) {
            System.setProperty(ATLAS_HOME, "target");
        }
        if (System.getProperty(ATLAS_LOG_DIR) == null) {
            System.setProperty(ATLAS_LOG_DIR, "target/logs");
        }
    }

    public static String getProjectVersion(PropertiesConfiguration buildConfiguration) {
        return buildConfiguration.getString("project.version");
    }

    private static int getApplicationPort(CommandLine cmd, String enableTLSFlag) {
        int appPort = cmd.hasOption(APP_PORT) ? Integer.valueOf(cmd.getOptionValue(APP_PORT)) : (StringUtils.isEmpty((String)enableTLSFlag) || enableTLSFlag.equals("true") ? 21443 : 21000);
        return appPort;
    }

    private static boolean isTLSEnabled(String enableTLSFlag, int appPort) {
        return Boolean.valueOf(StringUtils.isEmpty((String)enableTLSFlag) ? System.getProperty("atlas.enableTLS", appPort % 1000 == 443 ? "true" : "false") : enableTLSFlag);
    }

    private static void showStartupInfo(PropertiesConfiguration buildConfiguration, boolean enableTLS, int appPort) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n############################################");
        buffer.append("############################################");
        buffer.append("\n                               Atlas Server (STARTUP)");
        buffer.append("\n");
        try {
            Iterator keys = buildConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                buffer.append('\n').append('\t').append(key).append(":\t").append(buildConfiguration.getProperty(key));
            }
        }
        catch (Throwable e) {
            buffer.append("*** Unable to get build info ***");
        }
        buffer.append("\n############################################");
        buffer.append("############################################");
        LOG.info(buffer.toString());
        LOG.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
        LOG.info("Server starting with TLS ? {} on port {}", (Object)enableTLS, (Object)appPort);
        LOG.info("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
    }
}

