/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.hbase;

import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.common.AbstractStoreTransaction;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediator;
import com.thinkaurelius.titan.diskstorage.util.KeyColumn;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseTransaction
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(HBaseTransaction.class);
    LocalLockMediator<StoreTransaction> llm;
    Set<KeyColumn> keyColumnLocks = new LinkedHashSet<KeyColumn>();

    public HBaseTransaction(BaseTransactionConfig config, LocalLockMediator<StoreTransaction> llm) {
        super(config);
        this.llm = llm;
    }

    public synchronized void rollback() throws BackendException {
        super.rollback();
        log.debug("Rolled back transaction");
        this.deleteAllLocks();
    }

    public synchronized void commit() throws BackendException {
        super.commit();
        log.debug("Committed transaction");
        this.deleteAllLocks();
    }

    public void updateLocks(KeyColumn lockID, StaticBuffer expectedValue) {
        this.keyColumnLocks.add(lockID);
    }

    private void deleteAllLocks() {
        for (KeyColumn kc : this.keyColumnLocks) {
            log.debug("Removed lock {} ", (Object)kc);
            this.llm.unlock(kc, (StoreTransaction)this);
        }
    }
}

