/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.hbase;

import com.thinkaurelius.titan.diskstorage.hbase.AdminMask;
import java.io.IOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseAdmin1_0
implements AdminMask {
    private static final Logger log = LoggerFactory.getLogger(HBaseAdmin1_0.class);
    private final Admin adm;

    public HBaseAdmin1_0(HBaseAdmin adm) {
        this.adm = adm;
    }

    @Override
    public void clearTable(String tableString, long timestamp) throws IOException {
        TableName tableName = TableName.valueOf((String)tableString);
        if (!this.adm.tableExists(tableName)) {
            log.debug("Attempted to clear table {} before it exists (noop)", (Object)tableString);
            return;
        }
        if (!this.adm.isTableDisabled(tableName)) {
            this.adm.disableTable(tableName);
        }
        if (!this.adm.isTableDisabled(tableName)) {
            throw new RuntimeException("Unable to disable table " + tableName);
        }
        log.info("Truncating table {}", (Object)tableName);
        this.adm.truncateTable(tableName, true);
        try {
            this.adm.enableTable(tableName);
        }
        catch (TableNotDisabledException e) {
            log.debug("Table automatically reenabled by truncation: {}", (Object)tableName, (Object)e);
        }
    }

    @Override
    public HTableDescriptor getTableDescriptor(String tableString) throws TableNotFoundException, IOException {
        return this.adm.getTableDescriptor(TableName.valueOf((String)tableString));
    }

    @Override
    public boolean tableExists(String tableString) throws IOException {
        return this.adm.tableExists(TableName.valueOf((String)tableString));
    }

    @Override
    public void createTable(HTableDescriptor desc) throws IOException {
        this.adm.createTable(desc);
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.adm.createTable(desc, startKey, endKey, numRegions);
    }

    @Override
    public int getEstimatedRegionServerCount() {
        int serverCount = -1;
        try {
            serverCount = this.adm.getClusterStatus().getServers().size();
            log.debug("Read {} servers from HBase ClusterStatus", (Object)serverCount);
        }
        catch (IOException e) {
            log.debug("Unable to retrieve HBase cluster status", (Throwable)e);
        }
        return serverCount;
    }

    @Override
    public void disableTable(String tableString) throws IOException {
        this.adm.disableTable(TableName.valueOf((String)tableString));
    }

    @Override
    public void enableTable(String tableString) throws IOException {
        this.adm.enableTable(TableName.valueOf((String)tableString));
    }

    @Override
    public boolean isTableDisabled(String tableString) throws IOException {
        return this.adm.isTableDisabled(TableName.valueOf((String)tableString));
    }

    @Override
    public void addColumn(String tableString, HColumnDescriptor columnDescriptor) throws IOException {
        this.adm.addColumn(TableName.valueOf((String)tableString), columnDescriptor);
    }

    @Override
    public void close() throws IOException {
        this.adm.close();
    }
}

