/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.hbase;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.Entry;
import com.thinkaurelius.titan.diskstorage.PermanentBackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.TemporaryBackendException;
import com.thinkaurelius.titan.diskstorage.common.DistributedStoreManager;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.hbase.AdminMask;
import com.thinkaurelius.titan.diskstorage.hbase.ConnectionMask;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseCompat;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseCompatLoader;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseKeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.hbase.HBaseTransaction;
import com.thinkaurelius.titan.diskstorage.hbase.TableMask;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.CustomizeStoreKCVSManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KCVMutation;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyRange;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StandardStoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreFeatures;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediator;
import com.thinkaurelius.titan.diskstorage.locking.LocalLockMediators;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.StaticArrayBuffer;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.PreInitializeConfigOptions;
import com.thinkaurelius.titan.util.system.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class HBaseStoreManager
extends DistributedStoreManager
implements KeyColumnValueStoreManager,
CustomizeStoreKCVSManager {
    private static final Logger logger = LoggerFactory.getLogger(HBaseStoreManager.class);
    public static final ConfigNamespace HBASE_NS = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "hbase", "HBase storage options");
    public static final ConfigOption<Boolean> SHORT_CF_NAMES = new ConfigOption(HBASE_NS, "short-cf-names", "Whether to shorten the names of Titan's column families to one-character mnemonics to conserve storage space", ConfigOption.Type.FIXED, (Object)true);
    public static final String COMPRESSION_DEFAULT = "-DEFAULT-";
    public static final ConfigOption<String> COMPRESSION = new ConfigOption(HBASE_NS, "compression-algorithm", "An HBase Compression.Algorithm enum string which will be applied to newly created column families. The compression algorithm must be installed and available on the HBase cluster.  Titan cannot install and configure new compression algorithms on the HBase cluster by itself.", ConfigOption.Type.MASKABLE, (Object)"GZ");
    public static final ConfigOption<Boolean> SKIP_SCHEMA_CHECK = new ConfigOption(HBASE_NS, "skip-schema-check", "Assume that Titan's HBase table and column families already exist. When this is true, Titan will not check for the existence of its table/CFs, nor will it attempt to create them under any circumstances.  This is useful when running Titan without HBase admin privileges.", ConfigOption.Type.MASKABLE, (Object)false);
    public static final ConfigOption<String> HBASE_TABLE = new ConfigOption(HBASE_NS, "table", "The name of the table Titan will use.  When " + ConfigElement.getPath(SKIP_SCHEMA_CHECK, (String[])new String[0]) + " is false, Titan will automatically create this table if it does not already exist.", ConfigOption.Type.LOCAL, (Object)"titan");
    public static final int MIN_REGION_COUNT = 3;
    public static final ConfigOption<Integer> REGION_COUNT = new ConfigOption(HBASE_NS, "region-count", "The number of initial regions set when creating Titan's HBase table", ConfigOption.Type.MASKABLE, Integer.class, (Predicate)new Predicate<Integer>(){

        public boolean apply(Integer input) {
            return null != input && 3 <= input;
        }
    });
    public static final ConfigOption<Integer> REGIONS_PER_SERVER = new ConfigOption(HBASE_NS, "regions-per-server", "The number of regions per regionserver to set when creating Titan's HBase table", ConfigOption.Type.MASKABLE, Integer.class);
    public static final ConfigOption<String> COMPAT_CLASS = new ConfigOption(HBASE_NS, "compat-class", "The package and class name of the HBaseCompat implementation. HBaseCompat masks version-specific HBase API differences. When this option is unset, Titan calls HBase's VersionInfo.getVersion() and loads the matching compat class at runtime.  Setting this option forces Titan to instead reflectively load and instantiate the specified class.", ConfigOption.Type.MASKABLE, String.class);
    public static final int PORT_DEFAULT = 9160;
    public static final Timestamps PREFERRED_TIMESTAMPS = Timestamps.MILLI;
    public static final ConfigNamespace HBASE_CONFIGURATION_NAMESPACE = new ConfigNamespace(HBASE_NS, "ext", "Overrides for hbase-{site,default}.xml options", true);
    private static final BiMap<String, String> SHORT_CF_NAME_MAP = ImmutableBiMap.builder().put((Object)"graphindex", (Object)"g").put((Object)"graphindex_lock_", (Object)"h").put((Object)"titan_ids", (Object)"i").put((Object)"edgestore", (Object)"e").put((Object)"edgestore_lock_", (Object)"f").put((Object)"system_properties", (Object)"s").put((Object)"system_properties_lock_", (Object)"t").put((Object)"systemlog", (Object)"m").put((Object)"txlog", (Object)"l").build();
    private static final StaticBuffer FOUR_ZERO_BYTES = BufferUtil.zeroBuffer((int)4);
    private final String tableName;
    private final String compression;
    private final int regionCount;
    private final int regionsPerServer;
    private final ConnectionMask cnx;
    private final Configuration hconf;
    private final boolean shortCfNames;
    private final boolean skipSchemaCheck;
    private final String compatClass;
    private final HBaseCompat compat;
    private static final ConcurrentHashMap<HBaseStoreManager, Throwable> openManagers;
    private final ConcurrentMap<String, HBaseKeyColumnValueStore> openStores;
    private LocalLockMediator<StoreTransaction> llm;

    public HBaseStoreManager(com.thinkaurelius.titan.diskstorage.configuration.Configuration config) throws BackendException {
        super(config, 9160);
        this.checkConfigDeprecation(config);
        this.tableName = (String)config.get(HBASE_TABLE, new String[0]);
        this.compression = (String)config.get(COMPRESSION, new String[0]);
        this.regionCount = config.has(REGION_COUNT, new String[0]) ? (Integer)config.get(REGION_COUNT, new String[0]) : -1;
        this.regionsPerServer = config.has(REGIONS_PER_SERVER, new String[0]) ? (Integer)config.get(REGIONS_PER_SERVER, new String[0]) : -1;
        this.skipSchemaCheck = (Boolean)config.get(SKIP_SCHEMA_CHECK, new String[0]);
        this.compatClass = config.has(COMPAT_CLASS, new String[0]) ? (String)config.get(COMPAT_CLASS, new String[0]) : null;
        this.compat = HBaseCompatLoader.getCompat(this.compatClass);
        if (config.has(REGIONS_PER_SERVER, new String[0]) && config.has(REGION_COUNT, new String[0])) {
            logger.warn("Both {} and {} are set in Titan's configuration, but the former takes precedence and the latter will be ignored.", REGION_COUNT, REGIONS_PER_SERVER);
        }
        this.hconf = HBaseConfiguration.create();
        int keysLoaded = 0;
        Map configSub = config.getSubset(HBASE_CONFIGURATION_NAMESPACE, new String[0]);
        for (Map.Entry entry : configSub.entrySet()) {
            logger.info("HBase configuration: setting {}={}", entry.getKey(), entry.getValue());
            if (entry.getValue() == null) continue;
            this.hconf.set((String)entry.getKey(), entry.getValue().toString());
            ++keysLoaded;
        }
        if (config.has(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0])) {
            String zkQuorumKey = "hbase.zookeeper.quorum";
            String string = Joiner.on((String)",").join((Object[])config.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]));
            this.hconf.set(zkQuorumKey, string);
            logger.info("Copied host list from {} to {}: {}", new Object[]{GraphDatabaseConfiguration.STORAGE_HOSTS, zkQuorumKey, string});
        }
        logger.debug("HBase configuration: set a total of {} configuration values", (Object)keysLoaded);
        this.shortCfNames = (Boolean)config.get(SHORT_CF_NAMES, new String[0]);
        try {
            this.cnx = this.compat.createConnection(this.hconf);
        }
        catch (IOException e) {
            throw new PermanentBackendException((Throwable)e);
        }
        if (logger.isTraceEnabled()) {
            openManagers.put(this, new Throwable("Manager Opened"));
            this.dumpOpenManagers();
        }
        logger.debug("Dumping HBase config key=value pairs");
        for (Map.Entry entry : this.hconf) {
            logger.debug("[HBaseConfig] " + (String)entry.getKey() + "=" + (String)entry.getValue());
        }
        logger.debug("End of HBase config key=value pairs");
        this.openStores = new ConcurrentHashMap<String, HBaseKeyColumnValueStore>();
    }

    public DistributedStoreManager.Deployment getDeployment() {
        try {
            List<KeyRange> local = this.getLocalKeyPartition();
            return null != local && !local.isEmpty() ? DistributedStoreManager.Deployment.LOCAL : DistributedStoreManager.Deployment.REMOTE;
        }
        catch (BackendException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return "hbase[" + this.tableName + "@" + super.toString() + "]";
    }

    public void dumpOpenManagers() {
        int estimatedSize = openManagers.size();
        logger.trace("---- Begin open HBase store manager list ({} managers) ----", (Object)estimatedSize);
        for (HBaseStoreManager m : openManagers.keySet()) {
            logger.trace("Manager {} opened at:", (Object)m, (Object)openManagers.get((Object)m));
        }
        logger.trace("----   End open HBase store manager list ({} managers)  ----", (Object)estimatedSize);
    }

    public void close() {
        this.openStores.clear();
        if (logger.isTraceEnabled()) {
            openManagers.remove((Object)this);
        }
        IOUtils.closeQuietly((Closeable)this.cnx);
    }

    public StoreFeatures getFeatures() {
        ModifiableConfiguration c = GraphDatabaseConfiguration.buildConfiguration();
        StandardStoreFeatures.Builder fb = new StandardStoreFeatures.Builder().orderedScan(true).unorderedScan(true).batchMutation(true).multiQuery(true).distributed(true).keyOrdered(true).storeTTL(true).timestamps(true).preferredTimestamps(PREFERRED_TIMESTAMPS).locking(true).keyConsistent((com.thinkaurelius.titan.diskstorage.configuration.Configuration)c);
        try {
            fb.localKeyPartition(this.getDeployment() == DistributedStoreManager.Deployment.LOCAL);
        }
        catch (Exception e) {
            logger.warn("Unexpected exception during getDeployment()", (Throwable)e);
        }
        return fb.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutateMany(Map<String, Map<StaticBuffer, KCVMutation>> mutations, StoreTransaction txh) throws BackendException {
        logger.debug("Enter mutateMany");
        DistributedStoreManager.MaskedTimestamp commitTime = new DistributedStoreManager.MaskedTimestamp((DistributedStoreManager)this, txh);
        Map<StaticBuffer, Pair<Put, Delete>> commandsPerKey = this.convertToCommands(mutations, commitTime.getAdditionTime(this.times.getUnit()), commitTime.getDeletionTime(this.times.getUnit()));
        ArrayList<Row> batch = new ArrayList<Row>(commandsPerKey.size());
        for (Pair<Put, Delete> commands : commandsPerKey.values()) {
            if (commands.getFirst() != null) {
                batch.add((Row)commands.getFirst());
            }
            if (commands.getSecond() == null) continue;
            batch.add((Row)commands.getSecond());
        }
        try {
            TableMask table = null;
            try {
                table = this.cnx.getTable(this.tableName);
                logger.debug("mutateMany : batch mutate started size {} ", (Object)batch.size());
                table.batch(batch, new Object[batch.size()]);
                logger.debug("mutateMany : batch mutate finished {} ", (Object)batch.size());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(table);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)table);
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        this.sleepAfterWrite(txh, commitTime);
    }

    public KeyColumnValueStore openDatabase(String longName) throws BackendException {
        return this.openDatabase(longName, -1);
    }

    public KeyColumnValueStore openDatabase(String longName, int ttlInSeconds) throws BackendException {
        HBaseKeyColumnValueStore store = (HBaseKeyColumnValueStore)this.openStores.get(longName);
        if (store == null) {
            String cfName = this.shortCfNames ? HBaseStoreManager.shortenCfName(longName) : longName;
            String llmPrefix = this.getName();
            this.llm = LocalLockMediators.INSTANCE.get(llmPrefix, this.times);
            HBaseKeyColumnValueStore newStore = new HBaseKeyColumnValueStore(this, this.cnx, this.tableName, cfName, longName, this.llm);
            store = this.openStores.putIfAbsent(longName, newStore);
            if (store == null) {
                if (!this.skipSchemaCheck) {
                    this.ensureColumnFamilyExists(this.tableName, cfName, ttlInSeconds);
                }
                store = newStore;
            }
            logger.info("Loaded 1.x Hbase Client Store Manager");
        }
        return store;
    }

    public StoreTransaction beginTransaction(BaseTransactionConfig config) throws BackendException {
        return new HBaseTransaction(config, this.llm);
    }

    public String getName() {
        return this.tableName;
    }

    public void clearStorage() throws BackendException {
        try (AdminMask adm = this.getAdminInterface();){
            adm.clearTable(this.tableName, this.times.getTime().getNativeTimestamp());
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<KeyRange, ServerName> normalizeKeyBounds(NavigableMap<HRegionInfo, ServerName> raw) {
        Map.Entry nullStart = null;
        Map.Entry nullEnd = null;
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry e : raw.entrySet()) {
            HRegionInfo regionInfo = (HRegionInfo)e.getKey();
            byte[] startKey = regionInfo.getStartKey();
            byte[] endKey = regionInfo.getEndKey();
            if (0 == startKey.length) {
                startKey = null;
                logger.trace("Converted zero-length HBase startKey byte array to null");
            }
            if (0 == endKey.length) {
                endKey = null;
                logger.trace("Converted zero-length HBase endKey byte array to null");
            }
            if (null == startKey && null == endKey) {
                Preconditions.checkState((1 == raw.size() ? 1 : 0) != 0);
                logger.debug("HBase table {} has a single region {}", (Object)this.tableName, (Object)regionInfo);
                return b.put((Object)new KeyRange(FOUR_ZERO_BYTES, FOUR_ZERO_BYTES), e.getValue()).build();
            }
            if (null == startKey) {
                logger.debug("Found HRegionInfo with null startKey on server {}: {}", e.getValue(), (Object)regionInfo);
                Preconditions.checkState((null == nullStart ? 1 : 0) != 0);
                nullStart = e;
                StaticArrayBuffer endBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(endKey));
                b.put((Object)new KeyRange(FOUR_ZERO_BYTES, (StaticBuffer)endBuf), e.getValue());
                continue;
            }
            if (null == endKey) {
                logger.debug("Found HRegionInfo with null endKey on server {}: {}", e.getValue(), (Object)regionInfo);
                Preconditions.checkState((null == nullEnd ? 1 : 0) != 0);
                nullEnd = e;
                b.put((Object)new KeyRange((StaticBuffer)StaticArrayBuffer.of((byte[])this.zeroExtend(startKey)), FOUR_ZERO_BYTES), e.getValue());
                continue;
            }
            Preconditions.checkState((null != startKey ? 1 : 0) != 0);
            Preconditions.checkState((null != endKey ? 1 : 0) != 0);
            StaticArrayBuffer startBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(startKey));
            StaticArrayBuffer endBuf = StaticArrayBuffer.of((byte[])this.zeroExtend(endKey));
            KeyRange kr = new KeyRange((StaticBuffer)startBuf, (StaticBuffer)endBuf);
            b.put((Object)kr, e.getValue());
            logger.debug("Found HRegionInfo with non-null end and start keys on server {}: {}", e.getValue(), (Object)regionInfo);
        }
        Preconditions.checkState((!(null == nullStart ^ null == nullEnd) ? 1 : 0) != 0);
        ImmutableMap result = b.build();
        for (KeyRange kr : result.keySet()) {
            Preconditions.checkState((4 <= kr.getStart().length() ? 1 : 0) != 0);
            Preconditions.checkState((4 <= kr.getEnd().length() ? 1 : 0) != 0);
        }
        return result;
    }

    private final byte[] zeroExtend(byte[] dataToPad) {
        int i;
        assert (null != dataToPad);
        int targetLength = 4;
        if (4 <= dataToPad.length) {
            return dataToPad;
        }
        byte[] padded = new byte[4];
        for (i = 0; i < dataToPad.length; ++i) {
            padded[i] = dataToPad[i];
        }
        for (i = dataToPad.length; i < padded.length; ++i) {
            padded[i] = 0;
        }
        return padded;
    }

    public static String shortenCfName(String longName) throws PermanentBackendException {
        String s;
        if (SHORT_CF_NAME_MAP.containsKey((Object)longName)) {
            s = (String)SHORT_CF_NAME_MAP.get((Object)longName);
            Preconditions.checkNotNull((Object)s);
            logger.debug("Substituted default CF name \"{}\" with short form \"{}\" to reduce HBase KeyValue size", (Object)longName, (Object)s);
        } else {
            if (SHORT_CF_NAME_MAP.containsValue((Object)longName)) {
                String fmt = "Must use CF long-form name \"%s\" instead of the short-form name \"%s\" when configured with %s=true";
                String msg = String.format(fmt, SHORT_CF_NAME_MAP.inverse().get((Object)longName), longName, SHORT_CF_NAMES.getName());
                throw new PermanentBackendException(msg);
            }
            s = longName;
            logger.debug("Kept default CF name \"{}\" because it has no associated short form", (Object)s);
        }
        return s;
    }

    private HTableDescriptor ensureTableExists(String tableName, String initialCFName, int ttlInSeconds) throws BackendException {
        HTableDescriptor desc;
        AdminMask adm = null;
        try {
            adm = this.getAdminInterface();
            desc = adm.tableExists(tableName) ? adm.getTableDescriptor(tableName) : this.createTable(tableName, initialCFName, ttlInSeconds, adm);
        }
        catch (IOException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)adm);
        }
        return desc;
    }

    private HTableDescriptor createTable(String tableName, String cfName, int ttlInSeconds, AdminMask adm) throws IOException {
        String src;
        HTableDescriptor desc = this.compat.newTableDescriptor(tableName);
        HColumnDescriptor cdesc = new HColumnDescriptor(cfName);
        this.setCFOptions(cdesc, ttlInSeconds);
        this.compat.addColumnFamilyToTableDescriptor(desc, cdesc);
        int count = this.regionCount;
        if (3 <= count) {
            src = "region count configuration";
        } else if (0 < this.regionsPerServer && 3 <= (count = this.regionsPerServer * adm.getEstimatedRegionServerCount())) {
            src = "ClusterStatus server count";
        } else {
            count = -1;
            src = "default";
        }
        if (3 < count) {
            adm.createTable(desc, this.getStartKey(count), this.getEndKey(count), count);
            logger.debug("Created table {} with region count {} from {}", new Object[]{tableName, count, src});
        } else {
            adm.createTable(desc);
            logger.debug("Created table {} with default start key, end key, and region count", (Object)tableName);
        }
        return desc;
    }

    private byte[] getStartKey(int regionCount) {
        ByteBuffer regionWidth = ByteBuffer.allocate(4);
        regionWidth.putInt((int)(0xFFFFFFFFL / (long)regionCount)).flip();
        return StaticArrayBuffer.of((ByteBuffer)regionWidth).getBytes(0, 4);
    }

    private byte[] getEndKey(int regionCount) {
        ByteBuffer regionWidth = ByteBuffer.allocate(4);
        regionWidth.putInt((int)(0xFFFFFFFFL / (long)regionCount * (long)(regionCount - 1))).flip();
        return StaticArrayBuffer.of((ByteBuffer)regionWidth).getBytes(0, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureColumnFamilyExists(String tableName, String columnFamily, int ttlInSeconds) throws BackendException {
        block11: {
            AdminMask adm = null;
            try {
                adm = this.getAdminInterface();
                HTableDescriptor desc = this.ensureTableExists(tableName, columnFamily, ttlInSeconds);
                Preconditions.checkNotNull((Object)desc);
                HColumnDescriptor cf = desc.getFamily(columnFamily.getBytes());
                if (cf != null) break block11;
                try {
                    if (!adm.isTableDisabled(tableName)) {
                        adm.disableTable(tableName);
                    }
                }
                catch (TableNotEnabledException e) {
                    logger.debug("Table {} already disabled", (Object)tableName);
                }
                catch (IOException e) {
                    throw new TemporaryBackendException((Throwable)e);
                }
                try {
                    HColumnDescriptor cdesc = new HColumnDescriptor(columnFamily);
                    this.setCFOptions(cdesc, ttlInSeconds);
                    adm.addColumn(tableName, cdesc);
                    logger.debug("Added HBase ColumnFamily {}, waiting for 1 sec. to propogate.", (Object)columnFamily);
                    adm.enableTable(tableName);
                }
                catch (TableNotFoundException ee) {
                    logger.error("TableNotFoundException", (Throwable)ee);
                    throw new PermanentBackendException((Throwable)ee);
                }
                catch (TableExistsException ee) {
                    logger.debug("Swallowing exception {}", (Throwable)ee);
                }
                catch (IOException ee) {
                    throw new TemporaryBackendException((Throwable)ee);
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)adm);
            }
        }
    }

    private void setCFOptions(HColumnDescriptor cdesc, int ttlInSeconds) {
        if (null != this.compression && !this.compression.equals(COMPRESSION_DEFAULT)) {
            this.compat.setCompression(cdesc, this.compression);
        }
        if (ttlInSeconds > 0) {
            cdesc.setTimeToLive(ttlInSeconds);
        }
        cdesc.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
    }

    private Map<StaticBuffer, Pair<Put, Delete>> convertToCommands(Map<String, Map<StaticBuffer, KCVMutation>> mutations, long putTimestamp, long delTimestamp) throws PermanentBackendException {
        HashMap<StaticBuffer, Pair<Put, Delete>> commandsPerKey = new HashMap<StaticBuffer, Pair<Put, Delete>>();
        for (Map.Entry<String, Map<StaticBuffer, KCVMutation>> entry : mutations.entrySet()) {
            String cfString = this.getCfNameForStoreName(entry.getKey());
            byte[] cfName = cfString.getBytes();
            for (Map.Entry<StaticBuffer, KCVMutation> m : entry.getValue().entrySet()) {
                byte[] key = (byte[])m.getKey().as(StaticBuffer.ARRAY_FACTORY);
                KCVMutation mutation = m.getValue();
                Pair commands = (Pair)commandsPerKey.get(m.getKey());
                if (commands == null) {
                    commands = new Pair();
                    commandsPerKey.put(m.getKey(), (Pair<Put, Delete>)commands);
                }
                if (mutation.hasDeletions()) {
                    if (commands.getSecond() == null) {
                        Delete d = new Delete(key);
                        this.compat.setTimestamp(d, delTimestamp);
                        commands.setSecond((Object)d);
                    }
                    for (StaticBuffer b : mutation.getDeletions()) {
                        ((Delete)commands.getSecond()).deleteColumns(cfName, (byte[])b.as(StaticBuffer.ARRAY_FACTORY), delTimestamp);
                    }
                }
                if (!mutation.hasAdditions()) continue;
                if (commands.getFirst() == null) {
                    Put p = new Put(key, putTimestamp);
                    commands.setFirst((Object)p);
                }
                for (Entry e : mutation.getAdditions()) {
                    ((Put)commands.getFirst()).add(cfName, (byte[])e.getColumnAs(StaticBuffer.ARRAY_FACTORY), putTimestamp, (byte[])e.getValueAs(StaticBuffer.ARRAY_FACTORY));
                }
            }
        }
        return commandsPerKey;
    }

    private String getCfNameForStoreName(String storeName) throws PermanentBackendException {
        return this.shortCfNames ? HBaseStoreManager.shortenCfName(storeName) : storeName;
    }

    private void checkConfigDeprecation(com.thinkaurelius.titan.diskstorage.configuration.Configuration config) {
        if (config.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            logger.warn("The configuration property {} is ignored for HBase. Set hbase.zookeeper.property.clientPort in hbase-site.xml or {}.hbase.zookeeper.property.clientPort in Titan's configuration file.", (Object)ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_PORT, (String[])new String[0]), (Object)ConfigElement.getPath((ConfigElement)HBASE_CONFIGURATION_NAMESPACE, (String[])new String[0]));
        }
    }

    private AdminMask getAdminInterface() {
        try {
            return this.cnx.getAdmin();
        }
        catch (IOException e) {
            throw new TitanException((Throwable)e);
        }
    }

    static {
        Preconditions.checkArgument((null != SHORT_CF_NAME_MAP ? 1 : 0) != 0);
        Set shorts = SHORT_CF_NAME_MAP.values();
        Preconditions.checkArgument((Sets.newHashSet((Iterable)shorts).size() == shorts.size() ? 1 : 0) != 0);
        openManagers = new ConcurrentHashMap();
    }

    private static interface BackendFunction<F, T> {
        public T apply(F var1) throws BackendException;
    }
}

