/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.runner;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalSolrRunner {
    private static final String TARGET_DIRECTORY = System.getProperty("embedded.solr.directory");
    private static final String COLLECTIONS_FILE = "collections.txt";
    private static final String SOLR_XML = "solr.xml";
    private static final String TEMPLATE_DIRECTORY = "core-template";
    protected static final String[] COLLECTIONS = LocalSolrRunner.readCollections();
    private static final Logger LOG = LoggerFactory.getLogger(LocalSolrRunner.class);
    private static MiniSolrCloudCluster miniSolrCloudCluster;

    public static void start() throws Exception {
        if (LocalSolrRunner.isLocalSolrRunning()) {
            return;
        }
        LOG.info("==> LocalSolrRunner.start()");
        File templateDirectory = new File(TARGET_DIRECTORY + File.separator + "solr" + File.separator + TEMPLATE_DIRECTORY);
        File temp = new File(TARGET_DIRECTORY + File.separator + "data" + File.separator + "index" + File.separator + LocalSolrRunner.getRandomString());
        temp.mkdirs();
        temp.deleteOnExit();
        miniSolrCloudCluster = new MiniSolrCloudCluster(1, null, temp.toPath(), LocalSolrRunner.readSolrXml(), null, null);
        LOG.info("Started local solr server at: " + LocalSolrRunner.getZookeeperUrls());
        for (String coreName : COLLECTIONS) {
            File coreDirectory = new File(temp.getAbsolutePath() + File.separator + coreName);
            coreDirectory.mkdirs();
            FileUtils.copyDirectory((File)templateDirectory, (File)coreDirectory);
            Path coreConfigPath = Paths.get(coreDirectory.getAbsolutePath(), new String[0]);
            miniSolrCloudCluster.uploadConfigSet(coreConfigPath, coreName);
            LOG.info("Uploading solr configurations for core: '{}', configPath: '{}'", (Object)coreName, (Object)coreConfigPath);
        }
        LOG.info("<== LocalSolrRunner.start()");
    }

    public static void stop() throws Exception {
        if (!LocalSolrRunner.isLocalSolrRunning()) {
            return;
        }
        System.clearProperty("solr.solrxml.location");
        System.clearProperty("zkHost");
        miniSolrCloudCluster.shutdown();
    }

    public static String getZookeeperUrls() {
        return miniSolrCloudCluster.getZkServer().getZkAddress();
    }

    public static boolean isLocalSolrRunning() {
        boolean ret = false;
        if (miniSolrCloudCluster != null) {
            ret = CollectionUtils.isNotEmpty((Collection)miniSolrCloudCluster.getJettySolrRunners());
        }
        return ret;
    }

    private static String[] readCollections() {
        String resName = "/solr/collections.txt";
        try {
            InputStream inputStream = LocalSolrRunner.class.getResourceAsStream(resName);
            InputStreamReader isr = new InputStreamReader(inputStream);
            BufferedReader buffer = new BufferedReader(isr);
            return Pattern.compile("\\s+").split(buffer.lines().collect(Collectors.joining("\n")));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to read collections file", e);
        }
    }

    private static String readSolrXml() throws IOException {
        String resName = "/solr/solr.xml";
        InputStream inputStream = LocalSolrRunner.class.getResourceAsStream(resName);
        if (inputStream == null) {
            throw new RuntimeException("Unable to read solr xml");
        }
        return IOUtils.toString((InputStream)inputStream, (Charset)Charset.forName("UTF-8"));
    }

    private static String getRandomString() {
        return UUID.randomUUID().toString();
    }

    public static void main(String[] args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            System.out.println("No argument!");
        } else if (args[0].equals("start")) {
            try {
                LocalSolrRunner.start();
                System.out.println("Started Local Solr Server: " + LocalSolrRunner.getZookeeperUrls());
            }
            catch (Exception e) {
                System.out.println("Error starting Local Solr Server: " + e);
            }
        } else if (args[0].equals("stop")) {
            try {
                System.out.println("Stopping Local Solr Server.");
                LocalSolrRunner.stop();
            }
            catch (Exception e) {
                System.out.println("Error stopping Local Solr Server: " + e);
            }
        } else {
            System.out.println("Bad first argument: " + Arrays.toString(args));
        }
    }
}

