/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.aspect;

import java.util.Arrays;
import java.util.List;
import org.apache.atlas.RequestContext;
import org.apache.atlas.metrics.Metrics;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class AtlasAspect {
    public static final Logger LOG = LoggerFactory.getLogger(AtlasAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(org.apache.atlas.aspect.Monitored) && execution(* *(..))")
    public Object collectMetricsForMonitored(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature methodSign = joinPoint.getSignature();
        Metrics metrics = RequestContext.getMetrics();
        String metricName = methodSign.getDeclaringType().getSimpleName() + "." + methodSign.getName();
        long start = System.currentTimeMillis();
        try {
            Object response;
            Object object = response = joinPoint.proceed();
            return object;
        }
        finally {
            metrics.record(metricName, System.currentTimeMillis() - start);
        }
    }

    @Around(value="@annotation(org.apache.atlas.aspect.Loggable) && execution(* *(..))")
    public Object logAroundLoggable(ProceedingJoinPoint joinPoint) throws Throwable {
        Signature methodSign = joinPoint.getSignature();
        String methodName = methodSign.getDeclaringType().getSimpleName() + "." + methodSign.getName();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("==> %s(%s)", methodName, Arrays.toString(joinPoint.getArgs())));
        }
        Object response = joinPoint.proceed();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("<== %s(%s): %s", methodName, Arrays.toString(joinPoint.getArgs()), response instanceof List ? Integer.valueOf(((List)response).size()) : response));
        }
        return response;
    }
}

