/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.plugin.classloader;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AtlasPluginClassLoaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasPluginClassLoaderUtil.class);
    private static final String ATLAS_PLUGIN_LIBDIR = "atlas-%-plugin-impl";

    private AtlasPluginClassLoaderUtil() {
    }

    public static URL[] getFilesInDirectories(String[] libDirs) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasPluginClassLoaderUtil.getFilesInDirectories()");
        }
        ArrayList<URL> ret = new ArrayList<URL>();
        for (String libDir : libDirs) {
            AtlasPluginClassLoaderUtil.getFilesInDirectory(libDir, ret);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasPluginClassLoaderUtil.getFilesInDirectories(): {} files", (Object)ret.size());
        }
        return ret.toArray(new URL[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static void getFilesInDirectory(String dirPath, List<URL> files) {
        if (AtlasPluginClassLoaderUtil.LOG.isDebugEnabled()) {
            AtlasPluginClassLoaderUtil.LOG.debug("==> AtlasPluginClassLoaderUtil.getPluginFiles()");
        }
        if (dirPath != null) {
            try {
                dirFiles = new File(dirPath).listFiles();
                if (dirFiles == null) ** GOTO lbl23
                for (File dirFile : dirFiles) {
                    try {
                        jarPath = dirFile.toURI().toURL();
                        if (AtlasPluginClassLoaderUtil.LOG.isDebugEnabled()) {
                            AtlasPluginClassLoaderUtil.LOG.debug("getFilesInDirectory('{}'): adding {}", (Object)dirPath, (Object)dirFile.getAbsolutePath());
                        }
                        files.add(jarPath);
                    }
                    catch (Exception excp) {
                        AtlasPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('{}'): failed to get URI for file {}", new Object[]{dirPath, dirFile.getAbsolutePath(), excp});
                    }
                }
            }
            catch (Exception excp) {
                AtlasPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('{}'): error", (Object)dirPath, (Object)excp);
            }
        } else {
            AtlasPluginClassLoaderUtil.LOG.warn("getFilesInDirectory('{}'): could not find directory in path {}", (Object)dirPath, (Object)dirPath);
        }
lbl23:
        // 4 sources

        if (AtlasPluginClassLoaderUtil.LOG.isDebugEnabled()) {
            AtlasPluginClassLoaderUtil.LOG.debug("<== AtlasPluginClassLoaderUtil.getFilesInDirectory({})", (Object)dirPath);
        }
    }

    public static String getPluginImplLibPath(String pluginType, Class<?> pluginClass) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> AtlasPluginClassLoaderUtil.getPluginImplLibPath for Class ({})", (Object)pluginClass.getName());
        }
        URI uri = pluginClass.getProtectionDomain().getCodeSource().getLocation().toURI();
        Path path = Paths.get(URI.create(uri.toString()));
        String ret = path.getParent().toString() + File.separatorChar + ATLAS_PLUGIN_LIBDIR.replaceAll("%", pluginType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== AtlasPluginClassLoaderUtil.getPluginImplLibPath for Class {}): {})", (Object)pluginClass.getName(), (Object)ret);
        }
        return ret;
    }
}

