/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasStructType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasStructType {
    private static final String MULTI_VAL_ATTR_NAME_MIN_MAX = "multiValMinMax";
    private static final String MULTI_VAL_ATTR_NAME_MIN = "multiValMin";
    private static final String MULTI_VAL_ATTR_NAME_MAX = "multiValMax";
    private static final int MULTI_VAL_ATTR_MIN_COUNT = 2;
    private static final int MULTI_VAL_ATTR_MAX_COUNT = 5;
    private final AtlasStructType structType;
    private final List<Object> validValues;
    private final List<Object> invalidValues;

    public TestAtlasStructType() {
        AtlasStructDef.AtlasAttributeDef multiValuedAttribMinMax = new AtlasStructDef.AtlasAttributeDef();
        AtlasStructDef.AtlasAttributeDef multiValuedAttribMin = new AtlasStructDef.AtlasAttributeDef();
        AtlasStructDef.AtlasAttributeDef multiValuedAttribMax = new AtlasStructDef.AtlasAttributeDef();
        multiValuedAttribMinMax.setName(MULTI_VAL_ATTR_NAME_MIN_MAX);
        multiValuedAttribMinMax.setTypeName(AtlasBaseTypeDef.getArrayTypeName((String)"int"));
        multiValuedAttribMinMax.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
        multiValuedAttribMinMax.setValuesMinCount(2);
        multiValuedAttribMinMax.setValuesMaxCount(5);
        multiValuedAttribMin.setName(MULTI_VAL_ATTR_NAME_MIN);
        multiValuedAttribMin.setTypeName(AtlasBaseTypeDef.getArrayTypeName((String)"int"));
        multiValuedAttribMin.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.SET);
        multiValuedAttribMin.setValuesMinCount(2);
        multiValuedAttribMax.setName(MULTI_VAL_ATTR_NAME_MAX);
        multiValuedAttribMax.setTypeName(AtlasBaseTypeDef.getArrayTypeName((String)"int"));
        multiValuedAttribMax.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
        multiValuedAttribMax.setValuesMaxCount(5);
        AtlasStructDef structDef = ModelTestUtil.newStructDef();
        structDef.addAttribute(multiValuedAttribMinMax);
        structDef.addAttribute(multiValuedAttribMin);
        structDef.addAttribute(multiValuedAttribMax);
        this.structType = TestAtlasStructType.getStructType(structDef);
        this.validValues = new ArrayList<Object>();
        this.invalidValues = new ArrayList<Object>();
        AtlasStruct invalidValue1 = this.structType.createDefaultValue();
        AtlasStruct invalidValue2 = this.structType.createDefaultValue();
        AtlasStruct invalidValue3 = this.structType.createDefaultValue();
        AtlasStruct invalidValue4 = this.structType.createDefaultValue();
        AtlasStruct invalidValue5 = this.structType.createDefaultValue();
        AtlasStruct invalidValue6 = this.structType.createDefaultValue();
        AtlasStruct invalidValue7 = this.structType.createDefaultValue();
        invalidValue1.setAttribute(ModelTestUtil.getDefaultAttributeName("int"), (Object)"xyz");
        invalidValue2.setAttribute(ModelTestUtil.getDefaultAttributeName("date"), (Object)"xyz");
        invalidValue3.setAttribute(ModelTestUtil.getDefaultAttributeName("biginteger"), (Object)"xyz");
        invalidValue4.setAttribute(MULTI_VAL_ATTR_NAME_MIN_MAX, (Object)new Integer[]{1});
        invalidValue5.setAttribute(MULTI_VAL_ATTR_NAME_MIN_MAX, (Object)new Integer[]{1, 2, 3, 4, 5, 6});
        invalidValue6.setAttribute(MULTI_VAL_ATTR_NAME_MIN, (Object)new Integer[0]);
        invalidValue7.setAttribute(MULTI_VAL_ATTR_NAME_MAX, (Object)new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        this.validValues.add(null);
        this.validValues.add(this.structType.createDefaultValue());
        this.validValues.add(this.structType.createDefaultValue().getAttributes());
        this.invalidValues.add(invalidValue1);
        this.invalidValues.add(invalidValue2);
        this.invalidValues.add(invalidValue3);
        this.invalidValues.add(invalidValue4);
        this.invalidValues.add(invalidValue5);
        this.invalidValues.add(invalidValue6);
        this.invalidValues.add(invalidValue7);
        this.invalidValues.add(new AtlasStruct());
        this.invalidValues.add(new HashMap());
        this.invalidValues.add(1);
        this.invalidValues.add(new HashSet());
        this.invalidValues.add(new ArrayList());
        this.invalidValues.add(new String[0]);
    }

    @Test
    public void testStructTypeDefaultValue() {
        AtlasStruct defValue = this.structType.createDefaultValue();
        Assert.assertNotNull((Object)defValue);
        Assert.assertEquals((String)defValue.getTypeName(), (String)this.structType.getTypeName());
    }

    @Test
    public void testStructTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.structType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.structType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testStructTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.structType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            Object normalizedValue = this.structType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.structType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testStructTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.structType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.structType.validateValue(value, "testObj", messages));
            Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0, (String)("value=" + value));
            messages.clear();
        }
    }

    @Test
    public void testInvalidStructDef_MultiValuedAttributeNotArray() {
        AtlasStructDef.AtlasAttributeDef invalidMultiValuedAttrib = new AtlasStructDef.AtlasAttributeDef("invalidAttributeDef", "int");
        invalidMultiValuedAttrib.setCardinality(AtlasStructDef.AtlasAttributeDef.Cardinality.LIST);
        AtlasStructDef invalidStructDef = ModelTestUtil.newStructDef();
        invalidStructDef.addAttribute(invalidMultiValuedAttrib);
        try {
            AtlasStructType invalidStructType = new AtlasStructType(invalidStructDef, ModelTestUtil.getTypesRegistry());
            Assert.fail((String)("invalidStructDef not detected: structDef=" + invalidStructDef + "; structType=" + invalidStructType));
        }
        catch (AtlasBaseException excp) {
            Assert.assertTrue((excp.getAtlasErrorCode() == AtlasErrorCode.INVALID_ATTRIBUTE_TYPE_FOR_CARDINALITY ? 1 : 0) != 0);
            invalidStructDef.removeAttribute("invalidAttributeDef");
        }
    }

    private static AtlasStructType getStructType(AtlasStructDef structDef) {
        try {
            return new AtlasStructType(structDef, ModelTestUtil.getTypesRegistry());
        }
        catch (AtlasBaseException excp) {
            return null;
        }
    }
}

