/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasClassificationType {
    private final AtlasClassificationType classificationType;
    private final List<Object> validValues = new ArrayList<Object>();
    private final List<Object> invalidValues = new ArrayList<Object>();

    public TestAtlasClassificationType() {
        this.classificationType = TestAtlasClassificationType.getClassificationType(ModelTestUtil.getClassificationDefWithSuperTypes());
        AtlasClassification invalidValue1 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValue2 = this.classificationType.createDefaultValue();
        Map invalidValue3 = this.classificationType.createDefaultValue().getAttributes();
        invalidValue1.setAttribute(ModelTestUtil.getDefaultAttributeName("int"), (Object)"xyz");
        invalidValue2.setAttribute(ModelTestUtil.getDefaultAttributeName("date"), (Object)"xyz");
        invalidValue3.put(ModelTestUtil.getDefaultAttributeName("biginteger"), "xyz");
        this.validValues.add(null);
        this.validValues.add(this.classificationType.createDefaultValue());
        this.validValues.add(this.classificationType.createDefaultValue().getAttributes());
        this.invalidValues.add(invalidValue1);
        this.invalidValues.add(invalidValue2);
        this.invalidValues.add(invalidValue3);
        this.invalidValues.add(new AtlasClassification());
        this.invalidValues.add(new HashMap());
        this.invalidValues.add(1);
        this.invalidValues.add(new HashSet());
        this.invalidValues.add(new ArrayList());
        this.invalidValues.add(new String[0]);
    }

    @Test
    public void testClassificationTypeDefaultValue() {
        AtlasClassification defValue = this.classificationType.createDefaultValue();
        Assert.assertNotNull((Object)defValue);
        Assert.assertEquals((String)defValue.getTypeName(), (String)this.classificationType.getTypeName());
    }

    @Test
    public void testcanApplyToEntityType() throws AtlasBaseException {
        AtlasEntityDef entityDefA = new AtlasEntityDef("EntityA");
        AtlasEntityDef entityDefB = new AtlasEntityDef("EntityB");
        AtlasEntityDef entityDefC = new AtlasEntityDef("EntityC", null, null, null, new HashSet<String>(Arrays.asList(entityDefA.getName())));
        AtlasEntityDef entityDefD = new AtlasEntityDef("EntityD", null, null, null, new HashSet<String>(Arrays.asList(entityDefC.getName())));
        AtlasEntityDef entityDefE = new AtlasEntityDef("EntityE");
        AtlasEntityDef entityDefF = new AtlasEntityDef("EntityF", null, null, null, new HashSet<String>(Arrays.asList(entityDefB.getName(), entityDefE.getName())));
        AtlasClassificationDef classifyDef1 = new AtlasClassificationDef("Classify1", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefA.getName())), null);
        AtlasClassificationDef classifyDef2 = new AtlasClassificationDef("Classify2");
        AtlasClassificationDef classifyDef3 = new AtlasClassificationDef("Classify3", null, null, null, new HashSet<String>(Arrays.asList(classifyDef1.getName())), null, null);
        AtlasClassificationDef classifyDef4 = new AtlasClassificationDef("Classify4", null, null, null, new HashSet<String>(Arrays.asList(classifyDef1.getName())), new HashSet<String>(Arrays.asList(entityDefD.getName())), null);
        AtlasClassificationDef classifyDef5 = new AtlasClassificationDef("Classify5", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefA.getName(), entityDefC.getName())), null);
        AtlasClassificationDef classifyDef6 = new AtlasClassificationDef("Classify6", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefB.getName())), null);
        AtlasClassificationDef classifyDef7 = new AtlasClassificationDef("Classify7", null, null, null, new HashSet<String>(Arrays.asList(classifyDef1.getName(), classifyDef6.getName())), null, null);
        AtlasClassificationDef classifyDef8 = new AtlasClassificationDef("Classify8", null, null, null, new HashSet<String>(Arrays.asList(classifyDef6.getName())), new HashSet<String>(Arrays.asList(entityDefA.getName())), null);
        AtlasClassificationDef classifyDef9 = new AtlasClassificationDef("Classify9", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefE.getName())), null);
        AtlasClassificationDef classifyDef10 = new AtlasClassificationDef("Classify10", null, null, null, null, new HashSet<String>(Arrays.asList(entityDefC.getName(), entityDefA.getName())), null);
        AtlasTypeRegistry registry = ModelTestUtil.getTypesRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = registry.lockTypeRegistryForUpdate();
        ttr.addType((AtlasBaseTypeDef)entityDefA);
        ttr.addType((AtlasBaseTypeDef)entityDefB);
        ttr.addType((AtlasBaseTypeDef)entityDefC);
        ttr.addType((AtlasBaseTypeDef)entityDefD);
        ttr.addType((AtlasBaseTypeDef)entityDefE);
        ttr.addType((AtlasBaseTypeDef)entityDefF);
        ttr.addType((AtlasBaseTypeDef)classifyDef1);
        ttr.addType((AtlasBaseTypeDef)classifyDef2);
        ttr.addType((AtlasBaseTypeDef)classifyDef3);
        ttr.addType((AtlasBaseTypeDef)classifyDef4);
        ttr.addType((AtlasBaseTypeDef)classifyDef5);
        ttr.addType((AtlasBaseTypeDef)classifyDef6);
        ttr.addType((AtlasBaseTypeDef)classifyDef9);
        ttr.addType((AtlasBaseTypeDef)classifyDef10);
        registry.releaseTypeRegistryForUpdate(ttr, true);
        ttr = registry.lockTypeRegistryForUpdate();
        try {
            ttr.addType((AtlasBaseTypeDef)classifyDef7);
            Assert.fail((String)"Fail disjoined parent case");
        }
        catch (AtlasBaseException ae) {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
        ttr = registry.lockTypeRegistryForUpdate();
        try {
            ttr.addType((AtlasBaseTypeDef)classifyDef8);
            Assert.fail((String)"Fail trying to add an entity type that is not in the parent");
        }
        catch (AtlasBaseException ae) {
            registry.releaseTypeRegistryForUpdate(ttr, false);
        }
        AtlasEntityType entityTypeA = registry.getEntityTypeByName(entityDefA.getName());
        AtlasEntityType entityTypeB = registry.getEntityTypeByName(entityDefB.getName());
        AtlasEntityType entityTypeC = registry.getEntityTypeByName(entityDefC.getName());
        AtlasEntityType entityTypeD = registry.getEntityTypeByName(entityDefD.getName());
        AtlasEntityType entityTypeE = registry.getEntityTypeByName(entityDefE.getName());
        AtlasEntityType entityTypeF = registry.getEntityTypeByName(entityDefF.getName());
        AtlasClassificationType classifyType1 = registry.getClassificationTypeByName(classifyDef1.getName());
        AtlasClassificationType classifyType2 = registry.getClassificationTypeByName(classifyDef2.getName());
        AtlasClassificationType classifyType3 = registry.getClassificationTypeByName(classifyDef3.getName());
        AtlasClassificationType classifyType4 = registry.getClassificationTypeByName(classifyDef4.getName());
        AtlasClassificationType classifyType5 = registry.getClassificationTypeByName(classifyDef5.getName());
        AtlasClassificationType classifyType6 = registry.getClassificationTypeByName(classifyDef6.getName());
        AtlasClassificationType classifyType9 = registry.getClassificationTypeByName(classifyDef9.getName());
        AtlasClassificationType classifyType10 = registry.getClassificationTypeByName(classifyDef10.getName());
        Assert.assertTrue((boolean)classifyType1.canApplyToEntityType(entityTypeA));
        Assert.assertFalse((boolean)classifyType1.canApplyToEntityType(entityTypeB));
        Assert.assertTrue((boolean)classifyType1.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType1.canApplyToEntityType(entityTypeD));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeA));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeB));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType2.canApplyToEntityType(entityTypeD));
        Assert.assertTrue((boolean)classifyType3.canApplyToEntityType(entityTypeA));
        Assert.assertFalse((boolean)classifyType3.canApplyToEntityType(entityTypeB));
        Assert.assertTrue((boolean)classifyType3.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType3.canApplyToEntityType(entityTypeD));
        Assert.assertFalse((boolean)classifyType4.canApplyToEntityType(entityTypeA));
        Assert.assertFalse((boolean)classifyType4.canApplyToEntityType(entityTypeB));
        Assert.assertFalse((boolean)classifyType4.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType4.canApplyToEntityType(entityTypeD));
        Assert.assertTrue((boolean)classifyType6.canApplyToEntityType(entityTypeF));
        Assert.assertTrue((boolean)classifyType9.canApplyToEntityType(entityTypeF));
        Assert.assertTrue((boolean)classifyType5.canApplyToEntityType(entityTypeA));
        Assert.assertTrue((boolean)classifyType5.canApplyToEntityType(entityTypeC));
        Assert.assertTrue((boolean)classifyType10.canApplyToEntityType(entityTypeA));
        Assert.assertTrue((boolean)classifyType10.canApplyToEntityType(entityTypeC));
    }

    @Test
    public void testClassificationTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.classificationType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.classificationType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testClassificationTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.classificationType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            Object normalizedValue = this.classificationType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.classificationType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testClassificationTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.classificationType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.classificationType.validateValue(value, "testObj", messages));
            Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0, (String)("value=" + value));
            messages.clear();
        }
    }

    private static AtlasClassificationType getClassificationType(AtlasClassificationDef classificationDef) {
        try {
            return new AtlasClassificationType(classificationDef, ModelTestUtil.getTypesRegistry());
        }
        catch (AtlasBaseException excp) {
            return null;
        }
    }
}

