/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasArrayType {
    private final AtlasArrayType intArrayType = new AtlasArrayType((AtlasType)new AtlasBuiltInTypes.AtlasIntType());
    private final Object[] validValues;
    private final Object[] invalidValues;

    public TestAtlasArrayType() {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        HashSet<Integer> intSet = new HashSet<Integer>();
        Integer[] intArray = new Integer[]{1, 2, 3};
        ArrayList<Integer> objList = new ArrayList<Integer>();
        HashSet<Integer> objSet = new HashSet<Integer>();
        Object[] objArray = new Object[]{1, 2, 3};
        ArrayList<String> strList = new ArrayList<String>();
        HashSet<String> strSet = new HashSet<String>();
        String[] strArray = new String[]{"1", "2", "3"};
        for (int i = 0; i < 10; ++i) {
            intList.add(i);
            intSet.add(i);
            objList.add(i);
            objSet.add(i);
            strList.add(Integer.toString(i));
            strSet.add(Integer.toString(i));
        }
        this.validValues = new Object[]{null, new Integer[0], intList, intSet, intArray, objList, objSet, objArray, strList, strSet, strArray, new byte[]{1}, new short[]{1}, new int[]{1}, new long[]{1L}, new float[]{1.0f}, new double[]{1.0}, new BigInteger[]{BigInteger.valueOf(1L)}, new BigDecimal[]{BigDecimal.valueOf(1L)}};
        this.invalidValues = new Object[]{(byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L)};
    }

    @Test
    public void testArrayTypeDefaultValue() {
        Collection defValue = this.intArrayType.createDefaultValue();
        Assert.assertEquals((int)defValue.size(), (int)1);
    }

    @Test
    public void testArrayTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.intArrayType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.intArrayType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testArrayTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.intArrayType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            Collection normalizedValue = this.intArrayType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.intArrayType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testArrayTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.intArrayType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.intArrayType.validateValue(value, "testObj", messages));
            Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0, (String)("value=" + value));
            messages.clear();
        }
    }
}

