/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.util.List;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasStructDef {
    @Test
    public void testStructDefSerDeEmpty() {
        AtlasStructDef structDef = new AtlasStructDef("emptyStructDef");
        String jsonString = AtlasType.toJson((Object)structDef);
        AtlasStructDef structDef2 = (AtlasStructDef)AtlasType.fromJson((String)jsonString, AtlasStructDef.class);
        Assert.assertEquals((Object)structDef2, (Object)structDef, (String)"Incorrect serialization/deserialization of AtlasStructDef");
    }

    @Test
    public void testStructDefSerDe() {
        AtlasStructDef structDef = ModelTestUtil.getStructDef();
        String jsonString = AtlasType.toJson((Object)structDef);
        AtlasStructDef structDef2 = (AtlasStructDef)AtlasType.fromJson((String)jsonString, AtlasStructDef.class);
        Assert.assertEquals((Object)structDef2, (Object)structDef, (String)"Incorrect serialization/deserialization of AtlasStructDef");
    }

    @Test
    public void testStructDefHasAttribute() {
        AtlasStructDef structDef = ModelTestUtil.getStructDef();
        for (AtlasStructDef.AtlasAttributeDef attributeDef : structDef.getAttributeDefs()) {
            Assert.assertTrue((boolean)structDef.hasAttribute(attributeDef.getName()));
        }
        Assert.assertFalse((boolean)structDef.hasAttribute("01234-xyzabc-;''-)("));
    }

    @Test
    public void testStructDefAddAttribute() {
        AtlasStructDef structDef = ModelTestUtil.newStructDef();
        structDef.addAttribute(new AtlasStructDef.AtlasAttributeDef("newAttribute", "int"));
        Assert.assertTrue((boolean)structDef.hasAttribute("newAttribute"));
    }

    @Test
    public void testStructDefRemoveAttribute() {
        AtlasStructDef structDef = ModelTestUtil.newStructDef();
        String attrName = ((AtlasStructDef.AtlasAttributeDef)structDef.getAttributeDefs().get(0)).getName();
        Assert.assertTrue((boolean)structDef.hasAttribute(attrName));
        structDef.removeAttribute(attrName);
        Assert.assertFalse((boolean)structDef.hasAttribute(attrName));
    }

    @Test
    public void testStructDefSetAttributeDefs() {
        AtlasStructDef structDef = ModelTestUtil.newStructDef();
        List oldAttributes = structDef.getAttributeDefs();
        List<AtlasStructDef.AtlasAttributeDef> newttributes = ModelTestUtil.newAttributeDefsWithAllBuiltInTypes("newAttributes");
        structDef.setAttributeDefs(newttributes);
        for (AtlasStructDef.AtlasAttributeDef attributeDef : oldAttributes) {
            Assert.assertFalse((boolean)structDef.hasAttribute(attributeDef.getName()));
        }
        for (AtlasStructDef.AtlasAttributeDef attributeDef : newttributes) {
            Assert.assertTrue((boolean)structDef.hasAttribute(attributeDef.getName()));
        }
    }
}

