/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.util.List;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasRelationshipDef {
    private static final String PREFIX_ATTRIBUTE_NAME = "reltests-";
    private List<AtlasStructDef.AtlasAttributeDef> attributeDefs;

    @Test
    public void testRelationshipDefSerDeEmpty() throws AtlasBaseException {
        AtlasRelationshipEndDef ep1 = new AtlasRelationshipEndDef("typeA", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        AtlasRelationshipEndDef ep2 = new AtlasRelationshipEndDef("typeB", "attr2", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        AtlasRelationshipDef relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep1, ep2);
        String jsonString = AtlasType.toJson((Object)relationshipDef);
        System.out.println(jsonString);
        Assert.assertNotNull((Object)jsonString);
        AtlasRelationshipDef relationshipDef2 = (AtlasRelationshipDef)AtlasType.fromJson((String)jsonString, AtlasRelationshipDef.class);
        String jsonString2 = AtlasType.toJson((Object)relationshipDef2);
        Assert.assertEquals((String)jsonString, (String)jsonString2);
        Assert.assertEquals((Object)relationshipDef2, (Object)relationshipDef, (String)"Incorrect serialization/deserialization of AtlasRelationshipDef");
    }

    @Test
    public void testRelationshipDefSerDeAttributes() throws AtlasBaseException {
        AtlasRelationshipEndDef ep1 = new AtlasRelationshipEndDef("typeA", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        AtlasRelationshipEndDef ep2 = new AtlasRelationshipEndDef("typeB", "attr2", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        AtlasRelationshipDef relationshipDef = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep1, ep2);
        relationshipDef.setAttributeDefs(ModelTestUtil.newAttributeDefsWithAllBuiltInTypesForRelationship(PREFIX_ATTRIBUTE_NAME));
        String jsonString = AtlasType.toJson((Object)relationshipDef);
        Assert.assertNotNull((Object)jsonString);
        AtlasRelationshipDef relationshipDef2 = (AtlasRelationshipDef)AtlasType.fromJson((String)jsonString, AtlasRelationshipDef.class);
        String jsonString2 = AtlasType.toJson((Object)relationshipDef2);
        Assert.assertEquals((String)jsonString, (String)jsonString2);
        Assert.assertEquals((Object)relationshipDef2, (Object)relationshipDef, (String)"Incorrect serialization/deserialization of AtlasRelationshipDef");
    }

    @Test
    public void testRelationshipEquals() throws AtlasBaseException {
        AtlasRelationshipEndDef ep1 = new AtlasRelationshipEndDef("typeA", "attr1", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        AtlasRelationshipEndDef ep2 = new AtlasRelationshipEndDef("typeB", "attr2", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE);
        AtlasRelationshipDef relationshipDef1 = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep1, ep2);
        List<AtlasStructDef.AtlasAttributeDef> attributeDefs = ModelTestUtil.newAttributeDefsWithAllBuiltInTypesForRelationship(PREFIX_ATTRIBUTE_NAME);
        relationshipDef1.setAttributeDefs(attributeDefs);
        AtlasRelationshipDef relationshipDef2 = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep1, ep2);
        relationshipDef2.setAttributeDefs(attributeDefs);
        Assert.assertEquals((Object)relationshipDef1, (Object)relationshipDef2);
        AtlasRelationshipDef relationshipDef3 = new AtlasRelationshipDef("emptyRelationshipDef", "desc 1", "version1", AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, ep1, ep2);
        Assert.assertNotEquals((Object)relationshipDef1, (Object)relationshipDef3);
    }
}

