/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.type.AtlasType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasEnumDef {
    @Test
    public void testEnumDefSerDeEmpty() {
        AtlasEnumDef enumDef1 = new AtlasEnumDef();
        String jsonString = AtlasType.toJson((Object)enumDef1);
        AtlasEnumDef enumDef2 = (AtlasEnumDef)AtlasType.fromJson((String)jsonString, AtlasEnumDef.class);
        Assert.assertEquals((Object)enumDef1, (Object)enumDef2, (String)"Incorrect serialization/deserialization of AtlasEnumDef");
    }

    @Test
    public void testEnumDefSerDe() {
        AtlasEnumDef enumDef = ModelTestUtil.getEnumDef();
        String jsonString = AtlasType.toJson((Object)enumDef);
        AtlasEnumDef enumDef2 = (AtlasEnumDef)AtlasType.fromJson((String)jsonString, AtlasEnumDef.class);
        Assert.assertEquals((Object)enumDef, (Object)enumDef2, (String)"Incorrect serialization/deserialization of AtlasEnumDef");
    }

    @Test
    public void testEnumDefHasElement() {
        AtlasEnumDef enumDef = ModelTestUtil.getEnumDef();
        for (AtlasEnumDef.AtlasEnumElementDef elementDef : enumDef.getElementDefs()) {
            Assert.assertTrue((boolean)enumDef.hasElement(elementDef.getValue()));
        }
        Assert.assertFalse((boolean)enumDef.hasElement("01234-xyzabc-;''-)("));
    }

    @Test
    public void testEnumDefAddElement() {
        AtlasEnumDef enumDef = ModelTestUtil.newEnumDef();
        String newElement = "newElement-abcd-1234";
        enumDef.addElement(new AtlasEnumDef.AtlasEnumElementDef(newElement, "A new element", Integer.valueOf(enumDef.getElementDefs().size())));
        Assert.assertTrue((boolean)enumDef.hasElement(newElement));
    }

    @Test
    public void testEnumDefRemoveElement() {
        AtlasEnumDef enumDef = ModelTestUtil.newEnumDef();
        if (enumDef.getElementDefs().size() > 0) {
            String elementValue = ((AtlasEnumDef.AtlasEnumElementDef)enumDef.getElementDefs().get(0)).getValue();
            Assert.assertTrue((boolean)enumDef.hasElement(elementValue));
            enumDef.removeElement(elementValue);
            Assert.assertFalse((boolean)enumDef.hasElement(elementValue));
        }
    }

    @Test
    public void testEnumDefSetElementDefs() {
        AtlasEnumDef enumDef = ModelTestUtil.newEnumDef();
        List oldElements = enumDef.getElementDefs();
        ArrayList<AtlasEnumDef.AtlasEnumElementDef> newElements = new ArrayList<AtlasEnumDef.AtlasEnumElementDef>();
        newElements.add(new AtlasEnumDef.AtlasEnumElementDef("newElement", "new Element", Integer.valueOf(100)));
        enumDef.setElementDefs(newElements);
        for (AtlasEnumDef.AtlasEnumElementDef elementDef : oldElements) {
            Assert.assertFalse((boolean)enumDef.hasElement(elementDef.getValue()));
        }
        for (AtlasEnumDef.AtlasEnumElementDef elementDef : newElements) {
            Assert.assertTrue((boolean)enumDef.hasElement(elementDef.getValue()));
        }
    }
}

