/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.RandomStringUtils;

public final class TestUtilsV2 {
    public static final long TEST_DATE_IN_LONG = 1418265358440L;
    public static final String TEST_USER = "testUser";
    private static AtomicInteger seq = new AtomicInteger();
    public static final String DEPARTMENT_TYPE = "Department";
    public static final String EMPLOYEE_TYPE = "Employee";
    public static final String MANAGER_TYPE = "Manager";
    public static final String ADDRESS_TYPE = "Address";
    public static final String DATABASE_TYPE = "hive_database";
    public static final String DATABASE_NAME = "foo";
    public static final String TABLE_TYPE = "hive_table";
    public static final String PROCESS_TYPE = "hive_process";
    public static final String COLUMN_TYPE = "column_type";
    public static final String TABLE_NAME = "bar";
    public static final String CLASSIFICATION = "classification";
    public static final String PII = "PII";
    public static final String PHI = "PHI";
    public static final String SUPER_TYPE_NAME = "Base";
    public static final String STORAGE_DESC_TYPE = "hive_storagedesc";
    public static final String PARTITION_STRUCT_TYPE = "partition_struct_type";
    public static final String PARTITION_CLASS_TYPE = "partition_class_type";
    public static final String SERDE_TYPE = "serdeType";
    public static final String COLUMNS_MAP = "columnsMap";
    public static final String COLUMNS_ATTR_NAME = "columns";
    public static final String ENTITY_TYPE_WITH_NESTED_COLLECTION_ATTR = "entity_with_nested_collection_attr";
    public static final String NAME = "name";

    private TestUtilsV2() {
    }

    public static AtlasTypesDef defineDeptEmployeeTypes() {
        String _description = "_description";
        AtlasEnumDef orgLevelEnum = new AtlasEnumDef("OrgLevel", "OrgLevel" + _description, "1.0", Arrays.asList(new AtlasEnumDef.AtlasEnumElementDef("L1", "Element" + _description, Integer.valueOf(1)), new AtlasEnumDef.AtlasEnumElementDef("L2", "Element" + _description, Integer.valueOf(2))));
        AtlasStructDef addressDetails = AtlasTypeUtil.createStructTypeDef((String)ADDRESS_TYPE, (String)(ADDRESS_TYPE + _description), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"street", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"city", (String)"string")});
        AtlasEntityDef deptTypeDef = AtlasTypeUtil.createClassTypeDef((String)DEPARTMENT_TYPE, (String)(DEPARTMENT_TYPE + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), new AtlasStructDef.AtlasAttributeDef("employees", String.format("array<%s>", EMPLOYEE_TYPE), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
            }
        })});
        AtlasEntityDef personTypeDef = AtlasTypeUtil.createClassTypeDef((String)"Person", (String)("Person" + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"address", (String)ADDRESS_TYPE), AtlasTypeUtil.createOptionalAttrDef((String)"birthday", (String)"date"), AtlasTypeUtil.createOptionalAttrDef((String)"hasPets", (String)"boolean"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfCars", (String)"byte"), AtlasTypeUtil.createOptionalAttrDef((String)"houseNumber", (String)"short"), AtlasTypeUtil.createOptionalAttrDef((String)"carMileage", (String)"int"), AtlasTypeUtil.createOptionalAttrDef((String)"age", (String)"float"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfStarsEstimate", (String)"biginteger"), AtlasTypeUtil.createOptionalAttrDef((String)"approximationOfPi", (String)"bigdecimal")});
        AtlasEntityDef employeeTypeDef = AtlasTypeUtil.createClassTypeDef((String)EMPLOYEE_TYPE, (String)(EMPLOYEE_TYPE + _description), Collections.singleton("Person"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"orgLevel", (String)"OrgLevel"), new AtlasStructDef.AtlasAttributeDef("department", DEPARTMENT_TYPE, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, new ArrayList()), new AtlasStructDef.AtlasAttributeDef("manager", MANAGER_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("inverseRef", (Map)new HashMap<String, Object>(){
                    {
                        this.put("attribute", "subordinates");
                    }
                }));
            }
        }), new AtlasStructDef.AtlasAttributeDef("mentor", EMPLOYEE_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), AtlasTypeUtil.createOptionalAttrDef((String)"shares", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"salary", (String)"double")});
        employeeTypeDef.getAttribute("department").addConstraint(new AtlasStructDef.AtlasConstraintDef("inverseRef", (Map)new HashMap<String, Object>(){
            {
                this.put("attribute", "employees");
            }
        }));
        AtlasEntityDef managerTypeDef = AtlasTypeUtil.createClassTypeDef((String)MANAGER_TYPE, (String)(MANAGER_TYPE + _description), Collections.singleton(EMPLOYEE_TYPE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{new AtlasStructDef.AtlasAttributeDef("subordinates", String.format("array<%s>", EMPLOYEE_TYPE), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SET, 1, 10, false, false, Collections.emptyList())});
        AtlasClassificationDef securityClearanceTypeDef = AtlasTypeUtil.createTraitTypeDef((String)"SecurityClearance", (String)("SecurityClearance" + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"level", (String)"int")});
        AtlasTypesDef ret = new AtlasTypesDef(Collections.singletonList(orgLevelEnum), Collections.singletonList(addressDetails), Collections.singletonList(securityClearanceTypeDef), Arrays.asList(deptTypeDef, personTypeDef, employeeTypeDef, managerTypeDef));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasTypesDef defineInverseReferenceTestTypes() {
        AtlasEntityDef aDef = AtlasTypeUtil.createClassTypeDef((String)"A", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), new AtlasStructDef.AtlasAttributeDef("b", "B", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("oneB", "B", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("manyB", AtlasBaseTypeDef.getArrayTypeName((String)"B"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapToB", AtlasBaseTypeDef.getMapTypeName((String)"string", (String)"B"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.singletonList(new AtlasStructDef.AtlasConstraintDef("inverseRef", Collections.singletonMap("attribute", "mappedFromA"))))});
        AtlasEntityDef bDef = AtlasTypeUtil.createClassTypeDef((String)"B", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), new AtlasStructDef.AtlasAttributeDef("a", "A", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.singletonList(new AtlasStructDef.AtlasConstraintDef("inverseRef", Collections.singletonMap("attribute", "b")))), new AtlasStructDef.AtlasAttributeDef("manyA", AtlasBaseTypeDef.getArrayTypeName((String)"A"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.singletonList(new AtlasStructDef.AtlasConstraintDef("inverseRef", Collections.singletonMap("attribute", "oneB")))), new AtlasStructDef.AtlasAttributeDef("manyToManyA", AtlasBaseTypeDef.getArrayTypeName((String)"A"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.singletonList(new AtlasStructDef.AtlasConstraintDef("inverseRef", Collections.singletonMap("attribute", "manyB")))), new AtlasStructDef.AtlasAttributeDef("mappedFromA", "A", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList())});
        AtlasTypesDef ret = new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(aDef, bDef));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasTypesDef defineValidUpdatedDeptEmployeeTypes() {
        String _description = "_description_updated";
        AtlasEnumDef orgLevelEnum = new AtlasEnumDef("OrgLevel", "OrgLevel" + _description, "1.0", Arrays.asList(new AtlasEnumDef.AtlasEnumElementDef("L1", "Element" + _description, Integer.valueOf(1)), new AtlasEnumDef.AtlasEnumElementDef("L2", "Element" + _description, Integer.valueOf(2))));
        AtlasStructDef addressDetails = AtlasTypeUtil.createStructTypeDef((String)ADDRESS_TYPE, (String)(ADDRESS_TYPE + _description), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"street", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"city", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"zip", (String)"int")});
        AtlasEntityDef deptTypeDef = AtlasTypeUtil.createClassTypeDef((String)DEPARTMENT_TYPE, (String)(DEPARTMENT_TYPE + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"dep-code", (String)"string"), new AtlasStructDef.AtlasAttributeDef("employees", String.format("array<%s>", EMPLOYEE_TYPE), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
            }
        })});
        AtlasEntityDef personTypeDef = AtlasTypeUtil.createClassTypeDef((String)"Person", (String)("Person" + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"email", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"address", (String)ADDRESS_TYPE), AtlasTypeUtil.createOptionalAttrDef((String)"birthday", (String)"date"), AtlasTypeUtil.createOptionalAttrDef((String)"hasPets", (String)"boolean"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfCars", (String)"byte"), AtlasTypeUtil.createOptionalAttrDef((String)"houseNumber", (String)"short"), AtlasTypeUtil.createOptionalAttrDef((String)"carMileage", (String)"int"), AtlasTypeUtil.createOptionalAttrDef((String)"age", (String)"float"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfStarsEstimate", (String)"biginteger"), AtlasTypeUtil.createOptionalAttrDef((String)"approximationOfPi", (String)"bigdecimal")});
        AtlasEntityDef employeeTypeDef = AtlasTypeUtil.createClassTypeDef((String)EMPLOYEE_TYPE, (String)(EMPLOYEE_TYPE + _description), Collections.singleton("Person"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"orgLevel", (String)"OrgLevel"), AtlasTypeUtil.createOptionalAttrDef((String)"empCode", (String)"string"), new AtlasStructDef.AtlasAttributeDef("department", DEPARTMENT_TYPE, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("manager", MANAGER_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("inverseRef", (Map)new HashMap<String, Object>(){
                    {
                        this.put("attribute", "subordinates");
                    }
                }));
            }
        }), new AtlasStructDef.AtlasAttributeDef("mentor", EMPLOYEE_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), AtlasTypeUtil.createOptionalAttrDef((String)"shares", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"salary", (String)"double")});
        AtlasEntityDef managerTypeDef = AtlasTypeUtil.createClassTypeDef((String)MANAGER_TYPE, (String)(MANAGER_TYPE + _description), Collections.singleton(EMPLOYEE_TYPE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{new AtlasStructDef.AtlasAttributeDef("subordinates", String.format("array<%s>", EMPLOYEE_TYPE), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SET, 1, 10, false, false, Collections.emptyList())});
        AtlasClassificationDef securityClearanceTypeDef = AtlasTypeUtil.createTraitTypeDef((String)"SecurityClearance", (String)("SecurityClearance" + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"level", (String)"int")});
        AtlasTypesDef ret = new AtlasTypesDef(Collections.singletonList(orgLevelEnum), Collections.singletonList(addressDetails), Collections.singletonList(securityClearanceTypeDef), Arrays.asList(deptTypeDef, personTypeDef, employeeTypeDef, managerTypeDef));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasTypesDef defineInvalidUpdatedDeptEmployeeTypes() {
        String _description = "_description_updated";
        AtlasEnumDef orgLevelEnum = new AtlasEnumDef("OrgLevel", "OrgLevel" + _description, "1.0", Arrays.asList(new AtlasEnumDef.AtlasEnumElementDef("L2", "Element" + _description, Integer.valueOf(1)), new AtlasEnumDef.AtlasEnumElementDef("L1", "Element" + _description, Integer.valueOf(2)), new AtlasEnumDef.AtlasEnumElementDef("L3", "Element" + _description, Integer.valueOf(3))));
        AtlasStructDef addressDetails = AtlasTypeUtil.createStructTypeDef((String)ADDRESS_TYPE, (String)(ADDRESS_TYPE + _description), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"street", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"city", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"zip", (String)"int")});
        AtlasEntityDef deptTypeDef = AtlasTypeUtil.createClassTypeDef((String)DEPARTMENT_TYPE, (String)(DEPARTMENT_TYPE + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"dep-code", (String)"string"), new AtlasStructDef.AtlasAttributeDef("employees", String.format("array<%s>", "Person"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
            }
        })});
        AtlasEntityDef personTypeDef = AtlasTypeUtil.createClassTypeDef((String)"Person", (String)("Person" + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"emp-code", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"orgLevel", (String)"OrgLevel"), AtlasTypeUtil.createOptionalAttrDef((String)"address", (String)ADDRESS_TYPE), new AtlasStructDef.AtlasAttributeDef("department", DEPARTMENT_TYPE, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("manager", MANAGER_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("inverseRef", (Map)new HashMap<String, Object>(){
                    {
                        this.put("attribute", "subordinates");
                    }
                }));
            }
        }), new AtlasStructDef.AtlasAttributeDef("mentor", "Person", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), AtlasTypeUtil.createOptionalAttrDef((String)"birthday", (String)"date"), AtlasTypeUtil.createOptionalAttrDef((String)"hasPets", (String)"boolean"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfCars", (String)"byte"), AtlasTypeUtil.createOptionalAttrDef((String)"houseNumber", (String)"short"), AtlasTypeUtil.createOptionalAttrDef((String)"carMileage", (String)"int"), AtlasTypeUtil.createOptionalAttrDef((String)"shares", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"salary", (String)"double"), AtlasTypeUtil.createRequiredAttrDef((String)"age", (String)"float"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfStarsEstimate", (String)"biginteger"), AtlasTypeUtil.createOptionalAttrDef((String)"approximationOfPi", (String)"bigdecimal")});
        AtlasTypesDef ret = new AtlasTypesDef(Collections.singletonList(orgLevelEnum), Collections.singletonList(addressDetails), Collections.emptyList(), Arrays.asList(deptTypeDef, personTypeDef));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasEntity.AtlasEntitiesWithExtInfo createDeptEg2() {
        AtlasEntity.AtlasEntitiesWithExtInfo entitiesWithExtInfo = new AtlasEntity.AtlasEntitiesWithExtInfo();
        AtlasEntity hrDept = new AtlasEntity(DEPARTMENT_TYPE, NAME, (Object)"hr");
        AtlasObjectId hrDeptId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)hrDept);
        AtlasStruct janeAddr = new AtlasStruct(ADDRESS_TYPE);
        janeAddr.setAttribute("street", (Object)"Great America Parkway");
        janeAddr.setAttribute("city", (Object)"Santa Clara");
        AtlasStruct juliusAddr = new AtlasStruct(ADDRESS_TYPE);
        juliusAddr.setAttribute("street", (Object)"Madison Ave");
        juliusAddr.setAttribute("city", (Object)"Newtonville");
        AtlasStruct maxAddr = new AtlasStruct(ADDRESS_TYPE);
        maxAddr.setAttribute("street", (Object)"Ripley St");
        maxAddr.setAttribute("city", (Object)"Newton");
        AtlasStruct johnAddr = new AtlasStruct(ADDRESS_TYPE);
        johnAddr.setAttribute("street", (Object)"Stewart Drive");
        johnAddr.setAttribute("city", (Object)"Sunnyvale");
        AtlasEntity jane = new AtlasEntity(MANAGER_TYPE);
        AtlasObjectId janeId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)jane);
        jane.setAttribute(NAME, (Object)"Jane");
        jane.setAttribute("department", (Object)hrDeptId);
        jane.setAttribute("address", (Object)janeAddr);
        AtlasEntity julius = new AtlasEntity(MANAGER_TYPE);
        AtlasObjectId juliusId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)julius);
        julius.setAttribute(NAME, (Object)"Julius");
        julius.setAttribute("department", (Object)hrDeptId);
        julius.setAttribute("address", (Object)juliusAddr);
        julius.setAttribute("subordinates", Collections.emptyList());
        AtlasEntity max = new AtlasEntity(EMPLOYEE_TYPE);
        AtlasObjectId maxId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)max);
        max.setAttribute(NAME, (Object)"Max");
        max.setAttribute("department", (Object)hrDeptId);
        max.setAttribute("address", (Object)maxAddr);
        max.setAttribute("manager", (Object)janeId);
        max.setAttribute("mentor", (Object)juliusId);
        max.setAttribute("birthday", (Object)new Date(1979, 3, 15));
        max.setAttribute("hasPets", (Object)true);
        max.setAttribute("age", (Object)36);
        max.setAttribute("numberOfCars", (Object)2);
        max.setAttribute("houseNumber", (Object)17);
        max.setAttribute("carMileage", (Object)13);
        max.setAttribute("shares", (Object)Long.MAX_VALUE);
        max.setAttribute("salary", (Object)Double.MAX_VALUE);
        max.setAttribute("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000000000000"));
        max.setAttribute("approximationOfPi", (Object)new BigDecimal("3.1415926535897932"));
        AtlasEntity john = new AtlasEntity(EMPLOYEE_TYPE);
        AtlasObjectId johnId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)john);
        john.setAttribute(NAME, (Object)"John");
        john.setAttribute("department", (Object)hrDeptId);
        john.setAttribute("address", (Object)johnAddr);
        john.setAttribute("manager", (Object)janeId);
        john.setAttribute("mentor", (Object)maxId);
        john.setAttribute("birthday", (Object)new Date(1950, 5, 15));
        john.setAttribute("hasPets", (Object)true);
        john.setAttribute("numberOfCars", (Object)1);
        john.setAttribute("houseNumber", (Object)153);
        john.setAttribute("carMileage", (Object)13364);
        john.setAttribute("shares", (Object)15000);
        john.setAttribute("salary", (Object)123345.678);
        john.setAttribute("age", (Object)50);
        john.setAttribute("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000"));
        john.setAttribute("approximationOfPi", (Object)new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286"));
        jane.setAttribute("subordinates", Arrays.asList(johnId, maxId));
        hrDept.setAttribute("employees", Arrays.asList(janeId, juliusId, maxId, johnId));
        entitiesWithExtInfo.addEntity(hrDept);
        entitiesWithExtInfo.addEntity(jane);
        entitiesWithExtInfo.addEntity(julius);
        entitiesWithExtInfo.addEntity(max);
        entitiesWithExtInfo.addEntity(john);
        return entitiesWithExtInfo;
    }

    public static Map<String, AtlasEntity> createDeptEg1() {
        HashMap<String, AtlasEntity> deptEmpEntities = new HashMap<String, AtlasEntity>();
        AtlasEntity hrDept = new AtlasEntity(DEPARTMENT_TYPE);
        AtlasEntity john = new AtlasEntity(EMPLOYEE_TYPE);
        AtlasEntity jane = new AtlasEntity(MANAGER_TYPE);
        AtlasEntity johnAddr = new AtlasEntity(ADDRESS_TYPE);
        AtlasEntity janeAddr = new AtlasEntity(ADDRESS_TYPE);
        AtlasEntity julius = new AtlasEntity(MANAGER_TYPE);
        AtlasEntity juliusAddr = new AtlasEntity(ADDRESS_TYPE);
        AtlasEntity max = new AtlasEntity(EMPLOYEE_TYPE);
        AtlasEntity maxAddr = new AtlasEntity(ADDRESS_TYPE);
        AtlasObjectId deptId = new AtlasObjectId(hrDept.getGuid(), hrDept.getTypeName());
        hrDept.setAttribute(NAME, (Object)"hr");
        john.setAttribute(NAME, (Object)"John");
        john.setAttribute("department", (Object)deptId);
        johnAddr.setAttribute("street", (Object)"Stewart Drive");
        johnAddr.setAttribute("city", (Object)"Sunnyvale");
        john.setAttribute("address", (Object)johnAddr);
        john.setAttribute("birthday", (Object)new Date(1950, 5, 15));
        john.setAttribute("hasPets", (Object)true);
        john.setAttribute("numberOfCars", (Object)1);
        john.setAttribute("houseNumber", (Object)153);
        john.setAttribute("carMileage", (Object)13364);
        john.setAttribute("shares", (Object)15000);
        john.setAttribute("salary", (Object)123345.678);
        john.setAttribute("age", (Object)50);
        john.setAttribute("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000"));
        john.setAttribute("approximationOfPi", (Object)new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286"));
        jane.setAttribute(NAME, (Object)"Jane");
        jane.setAttribute("department", (Object)deptId);
        janeAddr.setAttribute("street", (Object)"Great America Parkway");
        janeAddr.setAttribute("city", (Object)"Santa Clara");
        jane.setAttribute("address", (Object)janeAddr);
        janeAddr.setAttribute("street", (Object)"Great America Parkway");
        julius.setAttribute(NAME, (Object)"Julius");
        julius.setAttribute("department", (Object)deptId);
        juliusAddr.setAttribute("street", (Object)"Madison Ave");
        juliusAddr.setAttribute("city", (Object)"Newtonville");
        julius.setAttribute("address", (Object)juliusAddr);
        julius.setAttribute("subordinates", Collections.emptyList());
        AtlasObjectId janeId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)jane);
        AtlasObjectId johnId = AtlasTypeUtil.getAtlasObjectId((AtlasEntity)john);
        AtlasObjectId maxId = new AtlasObjectId(max.getGuid(), EMPLOYEE_TYPE);
        AtlasObjectId juliusId = new AtlasObjectId(julius.getGuid(), EMPLOYEE_TYPE);
        max.setAttribute(NAME, (Object)"Max");
        max.setAttribute("department", (Object)deptId);
        maxAddr.setAttribute("street", (Object)"Ripley St");
        maxAddr.setAttribute("city", (Object)"Newton");
        max.setAttribute("address", (Object)maxAddr);
        max.setAttribute("manager", (Object)janeId);
        max.setAttribute("mentor", (Object)juliusId);
        max.setAttribute("birthday", (Object)new Date(1979, 3, 15));
        max.setAttribute("hasPets", (Object)true);
        max.setAttribute("age", (Object)36);
        max.setAttribute("numberOfCars", (Object)2);
        max.setAttribute("houseNumber", (Object)17);
        max.setAttribute("carMileage", (Object)13);
        max.setAttribute("shares", (Object)Long.MAX_VALUE);
        max.setAttribute("salary", (Object)Double.MAX_VALUE);
        max.setAttribute("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000000000000"));
        max.setAttribute("approximationOfPi", (Object)new BigDecimal("3.1415926535897932"));
        john.setAttribute("manager", (Object)janeId);
        john.setAttribute("mentor", (Object)maxId);
        hrDept.setAttribute("employees", Arrays.asList(johnId, janeId, juliusId, maxId));
        jane.setAttribute("subordinates", Arrays.asList(johnId, maxId));
        deptEmpEntities.put(jane.getGuid(), jane);
        deptEmpEntities.put(john.getGuid(), john);
        deptEmpEntities.put(julius.getGuid(), julius);
        deptEmpEntities.put(max.getGuid(), max);
        deptEmpEntities.put(deptId.getGuid(), hrDept);
        return deptEmpEntities;
    }

    public static AtlasTypesDef simpleType() {
        AtlasEntityDef superTypeDefinition = AtlasTypeUtil.createClassTypeDef((String)"h_type", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"attr", (String)"string")});
        AtlasStructDef structTypeDefinition = new AtlasStructDef("s_type", "structType", "1.0", Arrays.asList(AtlasTypeUtil.createRequiredAttrDef((String)NAME, (String)"string")));
        AtlasClassificationDef traitTypeDefinition = AtlasTypeUtil.createTraitTypeDef((String)"t_type", (String)"traitType", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasEnumDef enumTypeDefinition = new AtlasEnumDef("e_type", "enumType", "1.0", Arrays.asList(new AtlasEnumDef.AtlasEnumElementDef("ONE", "Element Description", Integer.valueOf(1))));
        AtlasTypesDef ret = AtlasTypeUtil.getTypesDef(Collections.singletonList(enumTypeDefinition), Collections.singletonList(structTypeDefinition), Collections.singletonList(traitTypeDefinition), Collections.singletonList(superTypeDefinition));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasTypesDef simpleTypeUpdated() {
        AtlasEntityDef superTypeDefinition = AtlasTypeUtil.createClassTypeDef((String)"h_type", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"attr", (String)"string")});
        AtlasEntityDef newSuperTypeDefinition = AtlasTypeUtil.createClassTypeDef((String)"new_h_type", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"attr", (String)"string")});
        AtlasStructDef structTypeDefinition = new AtlasStructDef("s_type", "structType", "1.0", Arrays.asList(AtlasTypeUtil.createRequiredAttrDef((String)NAME, (String)"string")));
        AtlasClassificationDef traitTypeDefinition = AtlasTypeUtil.createTraitTypeDef((String)"t_type", (String)"traitType", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasEnumDef enumTypeDefinition = new AtlasEnumDef("e_type", "enumType", Arrays.asList(new AtlasEnumDef.AtlasEnumElementDef("ONE", "Element Description", Integer.valueOf(1))));
        AtlasTypesDef ret = AtlasTypeUtil.getTypesDef(Collections.singletonList(enumTypeDefinition), Collections.singletonList(structTypeDefinition), Collections.singletonList(traitTypeDefinition), Arrays.asList(superTypeDefinition, newSuperTypeDefinition));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasTypesDef simpleTypeUpdatedDiff() {
        AtlasEntityDef newSuperTypeDefinition = AtlasTypeUtil.createClassTypeDef((String)"new_h_type", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"attr", (String)"string")});
        AtlasTypesDef ret = AtlasTypeUtil.getTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(newSuperTypeDefinition));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasTypesDef defineHiveTypes() {
        String _description = "_description";
        AtlasEntityDef superTypeDefinition = AtlasTypeUtil.createClassTypeDef((String)SUPER_TYPE_NAME, (String)"SuperType_description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"namespace", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"cluster", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"colo", (String)"string")});
        AtlasEntityDef databaseTypeDefinition = AtlasTypeUtil.createClassTypeDef((String)DATABASE_TYPE, (String)(DATABASE_TYPE + _description), Collections.singleton(SUPER_TYPE_NAME), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"isReplicated", (String)"boolean"), AtlasTypeUtil.createOptionalAttrDef((String)"created", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"parameters", (String)"map<string,string>"), AtlasTypeUtil.createRequiredAttrDef((String)"description", (String)"string")});
        AtlasStructDef structTypeDefinition = new AtlasStructDef(SERDE_TYPE, SERDE_TYPE + _description, "1.0", Arrays.asList(AtlasTypeUtil.createRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"serde", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"description", (String)"string")));
        AtlasEnumDef.AtlasEnumElementDef[] values = new AtlasEnumDef.AtlasEnumElementDef[]{new AtlasEnumDef.AtlasEnumElementDef("MANAGED", "Element Description", Integer.valueOf(1)), new AtlasEnumDef.AtlasEnumElementDef("EXTERNAL", "Element Description", Integer.valueOf(2))};
        AtlasEnumDef enumTypeDefinition = new AtlasEnumDef("tableType", "tableType" + _description, "1.0", Arrays.asList(values));
        AtlasEntityDef columnsDefinition = AtlasTypeUtil.createClassTypeDef((String)COLUMN_TYPE, (String)"column_type_description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"type", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"description", (String)"string"), new AtlasStructDef.AtlasAttributeDef("table", TABLE_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("inverseRef", (Map)new HashMap<String, Object>(){
                    {
                        this.put("attribute", TestUtilsV2.COLUMNS_ATTR_NAME);
                    }
                }));
            }
        })});
        AtlasStructDef partitionDefinition = new AtlasStructDef(PARTITION_STRUCT_TYPE, PARTITION_STRUCT_TYPE + _description, "1.0", Arrays.asList(AtlasTypeUtil.createRequiredAttrDef((String)NAME, (String)"string")));
        AtlasStructDef.AtlasAttributeDef[] attributeDefinitions = new AtlasStructDef.AtlasAttributeDef[]{new AtlasStructDef.AtlasAttributeDef("location", "string", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("inputFormat", "string", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("outputFormat", "string", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("compressed", "boolean", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("numBuckets", "int", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList())};
        AtlasEntityDef storageDescClsDef = new AtlasEntityDef(STORAGE_DESC_TYPE, STORAGE_DESC_TYPE + _description, "1.0", Arrays.asList(attributeDefinitions), Collections.singleton(SUPER_TYPE_NAME));
        AtlasStructDef.AtlasAttributeDef[] partClsAttributes = new AtlasStructDef.AtlasAttributeDef[]{new AtlasStructDef.AtlasAttributeDef("values", "array<string>", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("table", TABLE_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("createTime", "long", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("lastAccessTime", "long", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("sd", STORAGE_DESC_TYPE, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef(COLUMNS_ATTR_NAME, String.format("array<%s>", COLUMN_TYPE), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("parameters", String.format("map<%s,%s>", "string", "string"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList())};
        AtlasEntityDef partClsDef = new AtlasEntityDef(PARTITION_CLASS_TYPE, PARTITION_CLASS_TYPE + _description, "1.0", Arrays.asList(partClsAttributes), Collections.singleton(SUPER_TYPE_NAME));
        AtlasEntityDef processClsType = new AtlasEntityDef(PROCESS_TYPE, PROCESS_TYPE + _description, "1.0", Arrays.asList(new AtlasStructDef.AtlasAttributeDef("outputs", "array<hive_table>", true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList())), Collections.emptySet());
        AtlasEntityDef tableTypeDefinition = AtlasTypeUtil.createClassTypeDef((String)TABLE_TYPE, (String)(TABLE_TYPE + _description), Collections.singleton(SUPER_TYPE_NAME), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"description", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"type", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"created", (String)"date"), new AtlasStructDef.AtlasAttributeDef("tableType", "tableType", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("columnNames", String.format("array<%s>", "string"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef(COLUMNS_ATTR_NAME, String.format("array<%s>", COLUMN_TYPE), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
            }
        }), new AtlasStructDef.AtlasAttributeDef("partitions", String.format("array<%s>", PARTITION_STRUCT_TYPE), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("parametersMap", String.format("map<%s,%s>", "string", "string"), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef(COLUMNS_MAP, String.format("map<%s,%s>", "string", COLUMN_TYPE), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
            }
        }), new AtlasStructDef.AtlasAttributeDef("partitionsMap", String.format("map<%s,%s>", "string", PARTITION_STRUCT_TYPE), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("serde1", SERDE_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("serde2", SERDE_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("database", DATABASE_TYPE, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("databaseComposite", DATABASE_TYPE, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, (List)new ArrayList<AtlasStructDef.AtlasConstraintDef>(){
            {
                this.add(new AtlasStructDef.AtlasConstraintDef("ownedRef"));
            }
        })});
        AtlasClassificationDef piiTypeDefinition = AtlasTypeUtil.createTraitTypeDef((String)PII, (String)(PII + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasClassificationDef classificationTypeDefinition = AtlasTypeUtil.createTraitTypeDef((String)CLASSIFICATION, (String)(CLASSIFICATION + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"tag", (String)"string")});
        AtlasClassificationDef fetlClassificationTypeDefinition = AtlasTypeUtil.createTraitTypeDef((String)"fetlclassification", (String)("fetlclassification" + _description), Collections.singleton(CLASSIFICATION), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"tag", (String)"string")});
        AtlasClassificationDef phiTypeDefinition = AtlasTypeUtil.createTraitTypeDef((String)PHI, (String)(PHI + _description), Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"stringAttr", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"booleanAttr", (String)"boolean"), AtlasTypeUtil.createRequiredAttrDef((String)"integerAttr", (String)"int")});
        AtlasTypesDef ret = AtlasTypeUtil.getTypesDef(Collections.singletonList(enumTypeDefinition), Arrays.asList(structTypeDefinition, partitionDefinition), Arrays.asList(classificationTypeDefinition, fetlClassificationTypeDefinition, piiTypeDefinition, phiTypeDefinition), Arrays.asList(superTypeDefinition, databaseTypeDefinition, columnsDefinition, tableTypeDefinition, storageDescClsDef, partClsDef, processClsType));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasTypesDef defineTypeWithNestedCollectionAttributes() {
        AtlasEntityDef nestedCollectionAttributesEntityType = AtlasTypeUtil.createClassTypeDef((String)ENTITY_TYPE_WITH_NESTED_COLLECTION_ATTR, (String)"entity_with_nested_collection_attr_description", null, (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)NAME, (String)"string"), new AtlasStructDef.AtlasAttributeDef("mapOfArrayOfStrings", "map<string,array<string>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfArrayOfBooleans", "map<string,array<boolean>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfArrayOfInts", "map<string,array<int>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfArrayOfFloats", "map<string,array<float>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfArrayOfDates", "map<string,array<date>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfMapOfStrings", "map<string,map<string,string>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfMapOfBooleans", "map<string,map<string,boolean>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfMapOfInts", "map<string,map<string,int>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfMapOfFloats", "map<string,map<string,float>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("mapOfMapOfDates", "map<string,map<string,date>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfArrayOfStrings", "array<array<string>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfArrayOfBooleans", "array<array<boolean>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfArrayOfInts", "array<array<int>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfArrayOfFloats", "array<array<float>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfArrayOfDates", "array<array<date>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfMapOfStrings", "array<map<string,string>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfMapOfBooleans", "array<map<string,boolean>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfMapOfInts", "array<map<string,int>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfMapOfFloats", "array<map<string,float>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList()), new AtlasStructDef.AtlasAttributeDef("arrayOfMapOfDates", "array<map<string,date>>", false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, false, Collections.emptyList())});
        AtlasTypesDef ret = AtlasTypeUtil.getTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(nestedCollectionAttributesEntityType));
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasEntity.AtlasEntityWithExtInfo createNestedCollectionAttrEntity() {
        AtlasEntity entity = new AtlasEntity(ENTITY_TYPE_WITH_NESTED_COLLECTION_ATTR);
        String[] arrayOfStrings = new String[]{"one", "two", "three"};
        boolean[] arrayOfBooleans = new boolean[]{false, true};
        int[] arrayOfInts = new int[]{1, 2, 3};
        float[] arrayOfFloats = new float[]{1.1f, 2.2f, 3.3f};
        Date[] arrayOfDates = new Date[]{new Date()};
        Map<String, String> mapOfStrings = Collections.singletonMap("one", "one");
        Map<String, Boolean> mapOfBooleans = Collections.singletonMap("one", true);
        Map<String, Integer> mapOfInts = Collections.singletonMap("one", 1);
        Map<String, Float> mapOfFloats = Collections.singletonMap("one", Float.valueOf(1.1f));
        Map<String, Date> mapOfDates = Collections.singletonMap("now", new Date());
        entity.setAttribute(NAME, (Object)(TestUtilsV2.randomString() + "_" + System.currentTimeMillis()));
        entity.setAttribute("mapOfArrayOfStrings", Collections.singletonMap("one", arrayOfStrings));
        entity.setAttribute("mapOfArrayOfBooleans", Collections.singletonMap("one", arrayOfBooleans));
        entity.setAttribute("mapOfArrayOfInts", Collections.singletonMap("one", arrayOfInts));
        entity.setAttribute("mapOfArrayOfFloats", Collections.singletonMap("one", arrayOfFloats));
        entity.setAttribute("mapOfArrayOfDates", Collections.singletonMap("one", arrayOfDates));
        entity.setAttribute("mapOfMapOfStrings", Collections.singletonMap("one", mapOfStrings));
        entity.setAttribute("mapOfMapOfBooleans", Collections.singletonMap("one", mapOfBooleans));
        entity.setAttribute("mapOfMapOfInts", Collections.singletonMap("one", mapOfInts));
        entity.setAttribute("mapOfMapOfFloats", Collections.singletonMap("one", mapOfFloats));
        entity.setAttribute("mapOfMapOfDates", Collections.singletonMap("one", mapOfDates));
        entity.setAttribute("arrayOfArrayOfStrings", Collections.singletonList(arrayOfStrings));
        entity.setAttribute("arrayOfArrayOfBooleans", Collections.singletonList(arrayOfBooleans));
        entity.setAttribute("arrayOfArrayOfInts", Collections.singletonList(arrayOfInts));
        entity.setAttribute("arrayOfArrayOfFloats", Collections.singletonList(arrayOfFloats));
        entity.setAttribute("arrayOfArrayOfDates", Collections.singletonList(arrayOfDates));
        entity.setAttribute("arrayOfMapOfStrings", Collections.singletonList(mapOfStrings));
        entity.setAttribute("arrayOfMapOfBooleans", Collections.singletonList(mapOfBooleans));
        entity.setAttribute("arrayOfMapOfInts", Collections.singletonList(mapOfInts));
        entity.setAttribute("arrayOfMapOfFloats", Collections.singletonList(mapOfFloats));
        entity.setAttribute("arrayOfMapOfDates", Collections.singletonList(mapOfDates));
        return new AtlasEntity.AtlasEntityWithExtInfo(entity);
    }

    public static final String randomString() {
        return RandomStringUtils.randomAlphanumeric((int)10);
    }

    public static final String randomString(int count) {
        return RandomStringUtils.randomAlphanumeric((int)count);
    }

    public static AtlasEntity createDBEntity() {
        String dbName = RandomStringUtils.randomAlphanumeric((int)10);
        return TestUtilsV2.createDBEntity(dbName);
    }

    public static AtlasEntity createDBEntity(String dbName) {
        AtlasEntity entity = new AtlasEntity(DATABASE_TYPE);
        entity.setAttribute(NAME, (Object)dbName);
        entity.setAttribute("description", (Object)"us db");
        return entity;
    }

    public static AtlasEntity.AtlasEntityWithExtInfo createDBEntityV2() {
        AtlasEntity dbEntity = new AtlasEntity(DATABASE_TYPE);
        dbEntity.setAttribute(NAME, (Object)RandomStringUtils.randomAlphanumeric((int)10));
        dbEntity.setAttribute("description", (Object)"us db");
        return new AtlasEntity.AtlasEntityWithExtInfo(dbEntity);
    }

    public static AtlasEntity createTableEntity(AtlasEntity dbEntity) {
        String tableName = RandomStringUtils.randomAlphanumeric((int)10);
        return TestUtilsV2.createTableEntity(dbEntity, tableName);
    }

    public static AtlasEntity createTableEntity(AtlasEntity dbEntity, String name) {
        AtlasEntity entity = new AtlasEntity(TABLE_TYPE);
        entity.setAttribute(NAME, (Object)name);
        entity.setAttribute("description", (Object)"random table");
        entity.setAttribute("type", (Object)"type");
        entity.setAttribute("tableType", (Object)"MANAGED");
        entity.setAttribute("database", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)dbEntity));
        entity.setAttribute("created", (Object)new Date());
        HashMap<String, Object> partAttributes = new HashMap<String, Object>(){
            {
                this.put(TestUtilsV2.NAME, "part0");
            }
        };
        final AtlasStruct partitionStruct = new AtlasStruct(PARTITION_STRUCT_TYPE, (Map)partAttributes);
        entity.setAttribute("partitions", (Object)new ArrayList<AtlasStruct>(){
            {
                this.add(partitionStruct);
            }
        });
        entity.setAttribute("parametersMap", (Object)new HashMap<String, String>(){
            {
                this.put("key1", "value1");
            }
        });
        return entity;
    }

    public static AtlasEntity.AtlasEntityWithExtInfo createTableEntityV2(AtlasEntity dbEntity) {
        AtlasEntity tblEntity = new AtlasEntity(TABLE_TYPE);
        tblEntity.setAttribute(NAME, (Object)RandomStringUtils.randomAlphanumeric((int)10));
        tblEntity.setAttribute("description", (Object)"random table");
        tblEntity.setAttribute("type", (Object)"type");
        tblEntity.setAttribute("tableType", (Object)"MANAGED");
        tblEntity.setAttribute("database", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)dbEntity));
        tblEntity.setAttribute("created", (Object)new Date());
        final AtlasStruct partitionStruct = new AtlasStruct(PARTITION_STRUCT_TYPE, NAME, (Object)"part0");
        tblEntity.setAttribute("partitions", (Object)new ArrayList<AtlasStruct>(){
            {
                this.add(partitionStruct);
            }
        });
        tblEntity.setAttribute("parametersMap", (Object)new HashMap<String, String>(){
            {
                this.put("key1", "value1");
            }
        });
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(tblEntity);
        ret.addReferredEntity(dbEntity);
        return ret;
    }

    public static AtlasEntity.AtlasEntityWithExtInfo createprimitiveEntityV2() {
        AtlasEntity defaultprimitive = new AtlasEntity(TestUtilsV2.createPrimitiveEntityDef());
        defaultprimitive.setAttribute(NAME, (Object)"testname");
        defaultprimitive.setAttribute("description", (Object)"test");
        defaultprimitive.setAttribute("check", (Object)"check");
        AtlasEntity.AtlasEntityWithExtInfo ret = new AtlasEntity.AtlasEntityWithExtInfo(defaultprimitive);
        return ret;
    }

    public static AtlasEntityDef createPrimitiveEntityDef() {
        AtlasEntityDef newtestEntityDef = new AtlasEntityDef("newtest");
        AtlasStructDef.AtlasAttributeDef attrName = new AtlasStructDef.AtlasAttributeDef(NAME, "string");
        AtlasStructDef.AtlasAttributeDef attrDescription = new AtlasStructDef.AtlasAttributeDef("description", "string");
        attrDescription.setIsOptional(false);
        AtlasStructDef.AtlasAttributeDef attrcheck = new AtlasStructDef.AtlasAttributeDef("check", "string");
        attrcheck.setIsOptional(true);
        AtlasStructDef.AtlasAttributeDef attrSourceCode = new AtlasStructDef.AtlasAttributeDef("sourcecode", "string");
        attrSourceCode.setDefaultValue("Hello World");
        attrSourceCode.setIsOptional(true);
        AtlasStructDef.AtlasAttributeDef attrCost = new AtlasStructDef.AtlasAttributeDef("Cost", "int");
        attrCost.setIsOptional(true);
        attrCost.setDefaultValue("30");
        AtlasStructDef.AtlasAttributeDef attrDiskUsage = new AtlasStructDef.AtlasAttributeDef("diskUsage", "float");
        attrDiskUsage.setIsOptional(true);
        attrDiskUsage.setDefaultValue("70.50");
        AtlasStructDef.AtlasAttributeDef attrisStoreUse = new AtlasStructDef.AtlasAttributeDef("isstoreUse", "boolean");
        attrisStoreUse.setIsOptional(true);
        attrisStoreUse.setDefaultValue("true");
        newtestEntityDef.addAttribute(attrName);
        newtestEntityDef.addAttribute(attrDescription);
        newtestEntityDef.addAttribute(attrcheck);
        newtestEntityDef.addAttribute(attrSourceCode);
        newtestEntityDef.addAttribute(attrCost);
        newtestEntityDef.addAttribute(attrDiskUsage);
        newtestEntityDef.addAttribute(attrisStoreUse);
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)newtestEntityDef);
        return newtestEntityDef;
    }

    public static AtlasEntity createColumnEntity(AtlasEntity tableEntity) {
        return TestUtilsV2.createColumnEntity(tableEntity, "col" + seq.addAndGet(1));
    }

    public static AtlasEntity createColumnEntity(AtlasEntity tableEntity, String colName) {
        AtlasEntity entity = new AtlasEntity(COLUMN_TYPE);
        entity.setAttribute(NAME, (Object)colName);
        entity.setAttribute("type", (Object)"VARCHAR(32)");
        entity.setAttribute("table", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)tableEntity));
        return entity;
    }

    public static AtlasEntity createProcessEntity(List<AtlasObjectId> inputs, List<AtlasObjectId> outputs) {
        AtlasEntity entity = new AtlasEntity(PROCESS_TYPE);
        entity.setAttribute(NAME, (Object)RandomStringUtils.randomAlphanumeric((int)10));
        entity.setAttribute("inputs", inputs);
        entity.setAttribute("outputs", outputs);
        return entity;
    }

    public static List<AtlasClassificationDef> getClassificationWithValidSuperType() {
        AtlasClassificationDef securityClearanceTypeDef = AtlasTypeUtil.createTraitTypeDef((String)"SecurityClearance1", (String)"SecurityClearance_description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"level", (String)"int")});
        AtlasClassificationDef janitorSecurityClearanceTypeDef = AtlasTypeUtil.createTraitTypeDef((String)"JanitorClearance", (String)"JanitorClearance_description", Collections.singleton("SecurityClearance1"), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"level", (String)"int")});
        List<AtlasClassificationDef> ret = Arrays.asList(securityClearanceTypeDef, janitorSecurityClearanceTypeDef);
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static List<AtlasClassificationDef> getClassificationWithName(String name) {
        AtlasClassificationDef classificationTypeDef = AtlasTypeUtil.createTraitTypeDef((String)name, (String)"s_description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"level", (String)"int")});
        List<AtlasClassificationDef> ret = Arrays.asList(classificationTypeDef);
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasClassificationDef getSingleClassificationWithName(String name) {
        AtlasClassificationDef classificaitonTypeDef = AtlasTypeUtil.createTraitTypeDef((String)name, (String)"s_description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"level", (String)"int")});
        TestUtilsV2.populateSystemAttributes((AtlasBaseTypeDef)classificaitonTypeDef);
        return classificaitonTypeDef;
    }

    public static List<AtlasClassificationDef> getClassificationWithValidAttribute() {
        return TestUtilsV2.getClassificationWithValidSuperType();
    }

    public static List<AtlasEntityDef> getEntityWithValidSuperType() {
        AtlasEntityDef developerTypeDef = AtlasTypeUtil.createClassTypeDef((String)"Developer", (String)"Developer_description", Collections.singleton(EMPLOYEE_TYPE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{new AtlasStructDef.AtlasAttributeDef("language", String.format("array<%s>", "string"), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SET, 1, 10, false, false, Collections.emptyList())});
        List<AtlasEntityDef> ret = Arrays.asList(developerTypeDef);
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static List<AtlasEntityDef> getEntityWithName(String name) {
        AtlasEntityDef developerTypeDef = AtlasTypeUtil.createClassTypeDef((String)name, (String)"Developer_description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{new AtlasStructDef.AtlasAttributeDef("language", String.format("array<%s>", "string"), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SET, 1, 10, false, false, Collections.emptyList())});
        List<AtlasEntityDef> ret = Arrays.asList(developerTypeDef);
        TestUtilsV2.populateSystemAttributes(ret);
        return ret;
    }

    public static AtlasEntityDef getSingleEntityWithName(String name) {
        AtlasEntityDef developerTypeDef = AtlasTypeUtil.createClassTypeDef((String)name, (String)"Developer_description", Collections.emptySet(), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{new AtlasStructDef.AtlasAttributeDef("language", String.format("array<%s>", "string"), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SET, 1, 10, false, false, Collections.emptyList())});
        return developerTypeDef;
    }

    public static List<AtlasEntityDef> getEntityWithValidAttribute() {
        List<AtlasEntityDef> entityDefs = TestUtilsV2.getEntityWithValidSuperType();
        entityDefs.get(1).getSuperTypes().clear();
        return entityDefs;
    }

    public static AtlasClassificationDef getClassificationWithInvalidSuperType() {
        AtlasClassificationDef classificationDef = (AtlasClassificationDef)TestUtilsV2.simpleType().getClassificationDefs().get(0);
        classificationDef.getSuperTypes().add("!@#$%");
        return classificationDef;
    }

    public static AtlasEntityDef getEntityWithInvalidSuperType() {
        AtlasEntityDef entityDef = (AtlasEntityDef)TestUtilsV2.simpleType().getEntityDefs().get(0);
        entityDef.addSuperType("!@#$%");
        return entityDef;
    }

    public static void populateSystemAttributes(AtlasTypesDef typesDef) {
        TestUtilsV2.populateSystemAttributes(typesDef.getEnumDefs());
        TestUtilsV2.populateSystemAttributes(typesDef.getStructDefs());
        TestUtilsV2.populateSystemAttributes(typesDef.getClassificationDefs());
        TestUtilsV2.populateSystemAttributes(typesDef.getEntityDefs());
        TestUtilsV2.populateSystemAttributes(typesDef.getRelationshipDefs());
    }

    public static void populateSystemAttributes(List<? extends AtlasBaseTypeDef> typeDefs) {
        if (CollectionUtils.isNotEmpty(typeDefs)) {
            for (AtlasBaseTypeDef atlasBaseTypeDef : typeDefs) {
                TestUtilsV2.populateSystemAttributes(atlasBaseTypeDef);
            }
        }
    }

    public static void populateSystemAttributes(AtlasBaseTypeDef typeDef) {
        typeDef.setCreatedBy(TEST_USER);
        typeDef.setUpdatedBy(TEST_USER);
    }
}

