/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasRelationshipDef;
import org.apache.atlas.model.typedef.AtlasRelationshipEndDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public final class TestRelationshipUtilsV2 {
    public static final String ORG_LEVEL_TYPE = "OrgLevel";
    public static final String SECURITY_CLEARANCE_TYPE = "SecurityClearance";
    public static final String ADDRESS_TYPE = "Address";
    public static final String PERSON_TYPE = "Person";
    public static final String MANAGER_TYPE = "Manager";
    public static final String DEPARTMENT_TYPE = "Department";
    public static final String EMPLOYEE_TYPE = "Employee";
    public static final String EMPLOYEE_DEPARTMENT_TYPE = "EmployeeDepartment";
    public static final String EMPLOYEE_MANAGER_TYPE = "EmployeeManager";
    public static final String EMPLOYEE_MENTORS_TYPE = "EmployeeMentors";
    public static final String EMPLOYEE_FRIENDS_TYPE = "EmployeeFriends";
    public static final String PERSON_SIBLING_TYPE = "PersonSibling";
    public static final String TYPE_A = "A";
    public static final String TYPE_B = "B";
    public static final String DEFAULT_VERSION = "1.0";

    private TestRelationshipUtilsV2() {
    }

    public static AtlasTypesDef getDepartmentEmployeeTypes() throws AtlasBaseException {
        AtlasEntityDef personType = AtlasTypeUtil.createClassTypeDef((String)PERSON_TYPE, (String)TestRelationshipUtilsV2.description(PERSON_TYPE), TestRelationshipUtilsV2.superType(null), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)"name", (String)"string"), AtlasTypeUtil.createOptionalAttrDef((String)"address", (String)ADDRESS_TYPE), AtlasTypeUtil.createOptionalAttrDef((String)"birthday", (String)"date"), AtlasTypeUtil.createOptionalAttrDef((String)"hasPets", (String)"boolean"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfCars", (String)"byte"), AtlasTypeUtil.createOptionalAttrDef((String)"houseNumber", (String)"short"), AtlasTypeUtil.createOptionalAttrDef((String)"carMileage", (String)"int"), AtlasTypeUtil.createOptionalAttrDef((String)"age", (String)"float"), AtlasTypeUtil.createOptionalAttrDef((String)"numberOfStarsEstimate", (String)"biginteger"), AtlasTypeUtil.createOptionalAttrDef((String)"approximationOfPi", (String)"bigdecimal")});
        AtlasEntityDef employeeType = AtlasTypeUtil.createClassTypeDef((String)EMPLOYEE_TYPE, (String)TestRelationshipUtilsV2.description(EMPLOYEE_TYPE), TestRelationshipUtilsV2.superType(PERSON_TYPE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createOptionalAttrDef((String)"orgLevel", (String)ORG_LEVEL_TYPE), AtlasTypeUtil.createOptionalAttrDef((String)"shares", (String)"long"), AtlasTypeUtil.createOptionalAttrDef((String)"salary", (String)"double")});
        AtlasEntityDef departmentType = AtlasTypeUtil.createClassTypeDef((String)DEPARTMENT_TYPE, (String)TestRelationshipUtilsV2.description(DEPARTMENT_TYPE), TestRelationshipUtilsV2.superType(null), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)"name", (String)"string")});
        AtlasEntityDef managerType = AtlasTypeUtil.createClassTypeDef((String)MANAGER_TYPE, (String)TestRelationshipUtilsV2.description(MANAGER_TYPE), TestRelationshipUtilsV2.superType(EMPLOYEE_TYPE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[0]);
        AtlasStructDef addressType = AtlasTypeUtil.createStructTypeDef((String)ADDRESS_TYPE, (String)TestRelationshipUtilsV2.description(ADDRESS_TYPE), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"street", (String)"string"), AtlasTypeUtil.createRequiredAttrDef((String)"city", (String)"string")});
        AtlasEnumDef orgLevelType = new AtlasEnumDef(ORG_LEVEL_TYPE, TestRelationshipUtilsV2.description(ORG_LEVEL_TYPE), DEFAULT_VERSION, TestRelationshipUtilsV2.getOrgLevelElements());
        AtlasClassificationDef securityClearanceType = AtlasTypeUtil.createTraitTypeDef((String)SECURITY_CLEARANCE_TYPE, (String)TestRelationshipUtilsV2.description(SECURITY_CLEARANCE_TYPE), TestRelationshipUtilsV2.superType(null), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createRequiredAttrDef((String)"level", (String)"int")});
        AtlasRelationshipDef employeeDepartmentType = new AtlasRelationshipDef(EMPLOYEE_DEPARTMENT_TYPE, TestRelationshipUtilsV2.description(EMPLOYEE_DEPARTMENT_TYPE), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.AGGREGATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(EMPLOYEE_TYPE, "department", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(DEPARTMENT_TYPE, "employees", AtlasStructDef.AtlasAttributeDef.Cardinality.SET, true));
        AtlasRelationshipDef employeeManagerType = new AtlasRelationshipDef(EMPLOYEE_MANAGER_TYPE, TestRelationshipUtilsV2.description(EMPLOYEE_MANAGER_TYPE), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.AGGREGATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(EMPLOYEE_TYPE, "manager", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(MANAGER_TYPE, "subordinates", AtlasStructDef.AtlasAttributeDef.Cardinality.SET, true));
        AtlasRelationshipDef employeeMentorsType = new AtlasRelationshipDef(EMPLOYEE_MENTORS_TYPE, TestRelationshipUtilsV2.description(EMPLOYEE_MENTORS_TYPE), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.AGGREGATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(EMPLOYEE_TYPE, "mentors", AtlasStructDef.AtlasAttributeDef.Cardinality.SET), new AtlasRelationshipEndDef(EMPLOYEE_TYPE, "mentees", AtlasStructDef.AtlasAttributeDef.Cardinality.SET, true));
        AtlasRelationshipDef employeeFriendsType = new AtlasRelationshipDef(EMPLOYEE_FRIENDS_TYPE, TestRelationshipUtilsV2.description(EMPLOYEE_FRIENDS_TYPE), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(EMPLOYEE_TYPE, "friends", AtlasStructDef.AtlasAttributeDef.Cardinality.SET), new AtlasRelationshipEndDef(EMPLOYEE_TYPE, "friends", AtlasStructDef.AtlasAttributeDef.Cardinality.SET));
        AtlasRelationshipDef personSiblingType = new AtlasRelationshipDef(PERSON_SIBLING_TYPE, TestRelationshipUtilsV2.description(PERSON_SIBLING_TYPE), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.BOTH, new AtlasRelationshipEndDef(PERSON_TYPE, "sibling", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(PERSON_TYPE, "sibling", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE));
        return new AtlasTypesDef(Collections.singletonList(orgLevelType), Collections.singletonList(addressType), Collections.singletonList(securityClearanceType), Arrays.asList(personType, employeeType, departmentType, managerType), Arrays.asList(employeeDepartmentType, employeeManagerType, employeeMentorsType, employeeFriendsType, personSiblingType));
    }

    public static AtlasEntity.AtlasEntitiesWithExtInfo getDepartmentEmployeeInstances() {
        AtlasEntity.AtlasEntitiesWithExtInfo ret = new AtlasEntity.AtlasEntitiesWithExtInfo();
        AtlasEntity hrDept = new AtlasEntity(DEPARTMENT_TYPE, "name", (Object)"hr");
        AtlasStruct janeAddr = new AtlasStruct(ADDRESS_TYPE);
        janeAddr.setAttribute("street", (Object)"Great America Parkway");
        janeAddr.setAttribute("city", (Object)"Santa Clara");
        AtlasStruct juliusAddr = new AtlasStruct(ADDRESS_TYPE);
        juliusAddr.setAttribute("street", (Object)"Madison Ave");
        juliusAddr.setAttribute("city", (Object)"Newtonville");
        AtlasStruct maxAddr = new AtlasStruct(ADDRESS_TYPE);
        maxAddr.setAttribute("street", (Object)"Ripley St");
        maxAddr.setAttribute("city", (Object)"Newton");
        AtlasStruct johnAddr = new AtlasStruct(ADDRESS_TYPE);
        johnAddr.setAttribute("street", (Object)"Stewart Drive");
        johnAddr.setAttribute("city", (Object)"Sunnyvale");
        AtlasStruct mikeAddr = new AtlasStruct(ADDRESS_TYPE);
        mikeAddr.setAttribute("street", (Object)"Casa Verde St");
        mikeAddr.setAttribute("city", (Object)"San Jose");
        AtlasEntity jane = new AtlasEntity(MANAGER_TYPE);
        jane.setAttribute("name", (Object)"Jane");
        jane.setRelationshipAttribute("department", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)hrDept));
        jane.setAttribute("address", (Object)janeAddr);
        AtlasEntity julius = new AtlasEntity(MANAGER_TYPE);
        julius.setAttribute("name", (Object)"Julius");
        julius.setRelationshipAttribute("department", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)hrDept));
        julius.setRelationshipAttribute("sibling", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)jane));
        julius.setAttribute("address", (Object)juliusAddr);
        AtlasEntity max = new AtlasEntity(EMPLOYEE_TYPE);
        max.setAttribute("name", (Object)"Max");
        max.setRelationshipAttribute("department", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)hrDept));
        max.setAttribute("address", (Object)maxAddr);
        max.setRelationshipAttribute("manager", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)jane));
        max.setRelationshipAttribute("mentors", TestRelationshipUtilsV2.getAtlasObjectIds(julius));
        max.setAttribute("birthday", (Object)new Date(1979, 3, 15));
        max.setAttribute("hasPets", (Object)true);
        max.setAttribute("age", (Object)36);
        max.setAttribute("numberOfCars", (Object)2);
        max.setAttribute("houseNumber", (Object)17);
        max.setAttribute("carMileage", (Object)13);
        max.setAttribute("shares", (Object)Long.MAX_VALUE);
        max.setAttribute("salary", (Object)Double.MAX_VALUE);
        max.setAttribute("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000000000000"));
        max.setAttribute("approximationOfPi", (Object)new BigDecimal("3.1415926535897932"));
        AtlasEntity john = new AtlasEntity(EMPLOYEE_TYPE);
        john.setAttribute("name", (Object)"John");
        john.setRelationshipAttribute("department", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)hrDept));
        john.setAttribute("address", (Object)johnAddr);
        john.setRelationshipAttribute("manager", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)jane));
        john.setRelationshipAttribute("mentors", TestRelationshipUtilsV2.getAtlasObjectIds(max, julius));
        john.setRelationshipAttribute("friends", TestRelationshipUtilsV2.getAtlasObjectIds(max));
        john.setAttribute("birthday", (Object)new Date(1950, 5, 15));
        john.setAttribute("hasPets", (Object)true);
        john.setAttribute("numberOfCars", (Object)1);
        john.setAttribute("houseNumber", (Object)153);
        john.setAttribute("carMileage", (Object)13364);
        john.setAttribute("shares", (Object)15000);
        john.setAttribute("salary", (Object)123345.678);
        john.setAttribute("age", (Object)50);
        john.setAttribute("numberOfStarsEstimate", (Object)new BigInteger("1000000000000000000000"));
        john.setAttribute("approximationOfPi", (Object)new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286"));
        AtlasEntity mike = new AtlasEntity(EMPLOYEE_TYPE);
        mike.setAttribute("name", (Object)"Mike");
        mike.setRelationshipAttribute("department", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)hrDept));
        mike.setAttribute("address", (Object)mikeAddr);
        mike.setRelationshipAttribute("manager", (Object)AtlasTypeUtil.getAtlasObjectId((AtlasEntity)julius));
        mike.setRelationshipAttribute("friends", TestRelationshipUtilsV2.getAtlasObjectIds(max, john));
        mike.setAttribute("birthday", (Object)new Date(1947, 8, 15));
        mike.setAttribute("hasPets", (Object)false);
        mike.setAttribute("numberOfCars", (Object)2);
        mike.setAttribute("houseNumber", (Object)3737);
        mike.setAttribute("carMileage", (Object)25000);
        mike.setAttribute("shares", (Object)Long.MIN_VALUE);
        mike.setAttribute("salary", (Object)Double.MIN_VALUE);
        mike.setAttribute("age", (Object)37);
        mike.setAttribute("numberOfStarsEstimate", (Object)new BigInteger("5000050000050000050005"));
        mike.setAttribute("approximationOfPi", (Object)new BigDecimal("3.14159"));
        ret.addEntity(hrDept);
        ret.addEntity(jane);
        ret.addEntity(julius);
        ret.addEntity(max);
        ret.addEntity(john);
        ret.addEntity(mike);
        return ret;
    }

    public static AtlasTypesDef getInverseReferenceTestTypes() throws AtlasBaseException {
        AtlasEntityDef aType = AtlasTypeUtil.createClassTypeDef((String)TYPE_A, TestRelationshipUtilsV2.superType(null), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)"name", (String)"string")});
        AtlasEntityDef bType = AtlasTypeUtil.createClassTypeDef((String)TYPE_B, TestRelationshipUtilsV2.superType(null), (AtlasStructDef.AtlasAttributeDef[])new AtlasStructDef.AtlasAttributeDef[]{AtlasTypeUtil.createUniqueRequiredAttrDef((String)"name", (String)"string")});
        AtlasRelationshipDef relationshipType1 = new AtlasRelationshipDef("TypeA_to_TypeB_on_b", TestRelationshipUtilsV2.description("TypeA_to_TypeB_on_b"), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(TYPE_A, "b", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(TYPE_B, "a", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE));
        AtlasRelationshipDef relationshipType2 = new AtlasRelationshipDef("TypeA_to_TypeB_on_oneB", TestRelationshipUtilsV2.description("TypeA_to_TypeB_on_oneB"), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(TYPE_A, "oneB", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(TYPE_B, "manyA", AtlasStructDef.AtlasAttributeDef.Cardinality.SET));
        AtlasRelationshipDef relationshipType3 = new AtlasRelationshipDef("TypeA_to_TypeB_on_manyB", TestRelationshipUtilsV2.description("TypeA_to_TypeB_on_manyB"), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(TYPE_A, "manyB", AtlasStructDef.AtlasAttributeDef.Cardinality.SET), new AtlasRelationshipEndDef(TYPE_B, "manyToManyA", AtlasStructDef.AtlasAttributeDef.Cardinality.SET));
        AtlasRelationshipDef relationshipType4 = new AtlasRelationshipDef("TypeB_to_TypeA_on_mappedFromA", TestRelationshipUtilsV2.description("TypeB_to_TypeA_on_mappedFromA"), DEFAULT_VERSION, AtlasRelationshipDef.RelationshipCategory.ASSOCIATION, AtlasRelationshipDef.PropagateTags.ONE_TO_TWO, new AtlasRelationshipEndDef(TYPE_B, "mappedFromA", AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE), new AtlasRelationshipEndDef(TYPE_A, "mapToB", AtlasStructDef.AtlasAttributeDef.Cardinality.SET));
        return new AtlasTypesDef(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Arrays.asList(aType, bType), Arrays.asList(relationshipType1, relationshipType2, relationshipType3, relationshipType4));
    }

    private static List<AtlasEnumDef.AtlasEnumElementDef> getOrgLevelElements() {
        return Arrays.asList(new AtlasEnumDef.AtlasEnumElementDef("L1", TestRelationshipUtilsV2.description("L1"), Integer.valueOf(1)), new AtlasEnumDef.AtlasEnumElementDef("L2", TestRelationshipUtilsV2.description("L2"), Integer.valueOf(2)), new AtlasEnumDef.AtlasEnumElementDef("L3", TestRelationshipUtilsV2.description("L3"), Integer.valueOf(3)));
    }

    private static String description(String typeName) {
        return typeName + " description";
    }

    private static Set<String> superType(String superTypeName) {
        return StringUtils.isNotEmpty((String)superTypeName) ? Collections.singleton(superTypeName) : Collections.emptySet();
    }

    private static List<AtlasObjectId> getAtlasObjectIds(AtlasEntity ... entities) {
        ArrayList<AtlasObjectId> ret = new ArrayList<AtlasObjectId>();
        if (ArrayUtils.isNotEmpty((Object[])entities)) {
            for (AtlasEntity entity : entities) {
                ret.add(AtlasTypeUtil.getAtlasObjectId((AtlasEntity)entity));
            }
        }
        return ret;
    }
}

