/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.io.InputStream;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ApplicationPropertiesTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetFileAsInputStream() throws Exception {
        Configuration props = ApplicationProperties.get((String)"test.properties");
        try (InputStream inStr = null;){
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)props, (String)"jaas.properties.file", null);
            Assert.assertNotNull((Object)inStr);
        }
        props.setProperty("jaas.properties.file", (Object)"src/test/resources/atlas-jaas.properties");
        try {
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)props, (String)"jaas.properties.file", null);
            Assert.assertNotNull((Object)inStr);
        }
        finally {
            if (inStr != null) {
                inStr.close();
            }
        }
        try {
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)props, (String)"property.not.specified.in.config", (String)"atlas-jaas.properties");
            Assert.assertNotNull((Object)inStr);
        }
        finally {
            if (inStr != null) {
                inStr.close();
            }
        }
        try {
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)props, (String)"property.not.specified.in.config", (String)"src/test/resources/atlas-jaas.properties");
            Assert.assertNotNull((Object)inStr);
        }
        finally {
            if (inStr != null) {
                inStr.close();
            }
        }
        String originalConfDirSetting = System.setProperty("atlas.conf", "src/test/resources");
        try {
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)props, (String)"property.not.specified.in.config", (String)"atlas-jaas.properties");
            Assert.assertNotNull((Object)inStr);
        }
        finally {
            if (inStr != null) {
                inStr.close();
            }
            if (originalConfDirSetting != null) {
                System.setProperty("atlas.conf", originalConfDirSetting);
            } else {
                System.clearProperty("atlas.conf");
            }
        }
        try {
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)props, (String)"property.not.specified.in.config", null);
            Assert.fail((String)("Expected " + AtlasException.class.getSimpleName() + " but none thrown"));
        }
        catch (AtlasException atlasException) {
        }
        finally {
            if (inStr != null) {
                inStr.close();
            }
        }
        props.setProperty("jaas.properties.file", (Object)"does_not_exist.txt");
        try {
            inStr = ApplicationProperties.getFileAsInputStream((Configuration)props, (String)"jaas.properties.file", null);
            Assert.fail((String)("Expected " + AtlasException.class.getSimpleName() + " but none thrown"));
        }
        catch (AtlasException atlasException) {
        }
        finally {
            if (inStr != null) {
                inStr.close();
            }
        }
    }
}

