/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.lang.StringUtils;

class TypeCache {
    private final Map<String, AtlasType> typeGuidMap;
    private final Map<String, AtlasType> typeNameMap;

    public TypeCache() {
        this.typeGuidMap = new ConcurrentHashMap<String, AtlasType>();
        this.typeNameMap = new ConcurrentHashMap<String, AtlasType>();
    }

    public TypeCache(TypeCache other) {
        this.typeGuidMap = new ConcurrentHashMap<String, AtlasType>(other.typeGuidMap);
        this.typeNameMap = new ConcurrentHashMap<String, AtlasType>(other.typeNameMap);
    }

    public void addType(AtlasType type) {
        if (type != null && StringUtils.isNotEmpty((String)type.getTypeName())) {
            this.typeNameMap.put(type.getTypeName(), type);
        }
    }

    public void addType(AtlasBaseTypeDef typeDef, AtlasType type) {
        if (typeDef != null && type != null) {
            if (StringUtils.isNotEmpty((String)typeDef.getGuid())) {
                this.typeGuidMap.put(typeDef.getGuid(), type);
            }
            if (StringUtils.isNotEmpty((String)typeDef.getName())) {
                this.typeNameMap.put(typeDef.getName(), type);
            }
        }
    }

    public boolean isKnownType(String typeName) {
        return this.typeNameMap.containsKey(typeName);
    }

    public Collection<String> getAllTypeNames() {
        return Collections.unmodifiableCollection(this.typeNameMap.keySet());
    }

    public Collection<AtlasType> getAllTypes() {
        return Collections.unmodifiableCollection(this.typeNameMap.values());
    }

    public AtlasType getTypeByGuid(String guid) {
        return guid != null ? this.typeGuidMap.get(guid) : null;
    }

    public AtlasType getTypeByName(String name) {
        return name != null ? this.typeNameMap.get(name) : null;
    }

    public void updateGuid(String typeName, String currGuid, String newGuid) {
        AtlasType type;
        if (currGuid != null) {
            this.typeGuidMap.remove(currGuid);
        }
        if (typeName != null && newGuid != null && (type = this.typeNameMap.get(typeName)) != null) {
            this.typeGuidMap.put(newGuid, type);
        }
    }

    public void removeTypeByGuid(String guid) {
        if (guid != null) {
            this.typeGuidMap.remove(guid);
        }
    }

    public void removeTypeByName(String name) {
        if (name != null) {
            this.typeNameMap.get(name);
        }
    }
}

