/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasEntityHeader;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypeDefHeader;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class AtlasTypeUtil {
    private static final Set<String> ATLAS_BUILTIN_TYPENAMES = new HashSet<String>();
    private static final String NAME_REGEX = "[a-zA-Z][a-zA-Z0-9_ ]*";
    private static final String TRAIT_NAME_REGEX = "[a-zA-Z][a-zA-Z0-9_ .]*";
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_ ]*");
    private static final Pattern TRAIT_NAME_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_ .]*");
    private static final String InvalidTypeNameErrorMessage = "Name must consist of a letter followed by a sequence of [ letter, number, '_' ] characters.";
    private static final String InvalidTraitTypeNameErrorMessage = "Name must consist of a letter followed by a sequence of [ letter,  number, '_', '.' ] characters.";

    public static Set<String> getReferencedTypeNames(String typeName) {
        HashSet<String> ret = new HashSet<String>();
        AtlasTypeUtil.getReferencedTypeNames(typeName, ret);
        return ret;
    }

    public static boolean isBuiltInType(String typeName) {
        return ATLAS_BUILTIN_TYPENAMES.contains(typeName);
    }

    public static boolean isArrayType(String typeName) {
        return StringUtils.startsWith((String)typeName, (String)"array<") && StringUtils.endsWith((String)typeName, (String)">");
    }

    public static boolean isMapType(String typeName) {
        return StringUtils.startsWith((String)typeName, (String)"map<") && StringUtils.endsWith((String)typeName, (String)">");
    }

    public static boolean isValidTypeName(String typeName) {
        Matcher m = NAME_PATTERN.matcher(typeName);
        return m.matches();
    }

    public static String getInvalidTypeNameErrorMessage() {
        return InvalidTypeNameErrorMessage;
    }

    public static boolean isValidTraitTypeName(String typeName) {
        Matcher m = TRAIT_NAME_PATTERN.matcher(typeName);
        return m.matches();
    }

    public static String getInvalidTraitTypeNameErrorMessage() {
        return InvalidTraitTypeNameErrorMessage;
    }

    public static void validateType(AtlasBaseTypeDef typeDef) throws AtlasBaseException {
        boolean isValidName;
        boolean bl = isValidName = typeDef instanceof AtlasClassificationDef ? AtlasTypeUtil.isValidTraitTypeName(typeDef.getName()) : AtlasTypeUtil.isValidTypeName(typeDef.getName());
        if (!isValidName) {
            throw new AtlasBaseException(AtlasErrorCode.TYPE_NAME_INVALID_FORMAT, typeDef.getName(), typeDef.getCategory().name());
        }
    }

    public static String getStringValue(Map map, Object key) {
        Object ret = map != null ? (Object)map.get(key) : null;
        return ret != null ? ret.toString() : null;
    }

    private static void getReferencedTypeNames(String typeName, Set<String> referencedTypeNames) {
        if (StringUtils.isNotBlank((String)typeName) && !referencedTypeNames.contains(typeName)) {
            if (typeName.startsWith("array<") && typeName.endsWith(">")) {
                int startIdx = "array<".length();
                int endIdx = typeName.length() - ">".length();
                String elementTypeName = typeName.substring(startIdx, endIdx);
                AtlasTypeUtil.getReferencedTypeNames(elementTypeName, referencedTypeNames);
            } else if (typeName.startsWith("map<") && typeName.endsWith(">")) {
                int endIdx;
                int startIdx = "map<".length();
                String[] keyValueTypes = typeName.substring(startIdx, endIdx = typeName.length() - ">".length()).split(",", 2);
                String keyTypeName = keyValueTypes.length > 0 ? keyValueTypes[0] : null;
                String valueTypeName = keyValueTypes.length > 1 ? keyValueTypes[1] : null;
                AtlasTypeUtil.getReferencedTypeNames(keyTypeName, referencedTypeNames);
                AtlasTypeUtil.getReferencedTypeNames(valueTypeName, referencedTypeNames);
            } else {
                referencedTypeNames.add(typeName);
            }
        }
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalAttrDef(String name, AtlasType dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType.getTypeName(), true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, true, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 0, 1, false, false, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, true, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createListRequiredAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, false, AtlasStructDef.AtlasAttributeDef.Cardinality.LIST, 1, Integer.MAX_VALUE, false, true, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalListAttrDef(String name, String dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType, true, AtlasStructDef.AtlasAttributeDef.Cardinality.LIST, 1, Integer.MAX_VALUE, false, true, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredListAttrDefWithConstraint(String name, String dataType, String type, Map param) {
        AtlasStructDef.AtlasAttributeDef ret = AtlasTypeUtil.createListRequiredAttrDef(name, dataType);
        ret.addConstraint(new AtlasStructDef.AtlasConstraintDef(type, param));
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredAttrDefWithConstraint(String name, String typeName, String type, Map param) {
        AtlasStructDef.AtlasAttributeDef ret = AtlasTypeUtil.createRequiredAttrDef(name, typeName);
        ret.addConstraint(new AtlasStructDef.AtlasConstraintDef(type, param));
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef createOptionalAttrDefWithConstraint(String name, String typeName, String type, Map param) {
        AtlasStructDef.AtlasAttributeDef ret = AtlasTypeUtil.createOptionalAttrDef(name, typeName);
        ret.addConstraint(new AtlasStructDef.AtlasConstraintDef(type, param));
        return ret;
    }

    public static AtlasStructDef.AtlasAttributeDef createUniqueRequiredAttrDef(String name, AtlasType dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType.getTypeName(), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, true, true, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createUniqueRequiredAttrDef(String name, String typeName) {
        return new AtlasStructDef.AtlasAttributeDef(name, typeName, false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, true, true, Collections.emptyList());
    }

    public static AtlasStructDef.AtlasAttributeDef createRequiredAttrDef(String name, AtlasType dataType) {
        return new AtlasStructDef.AtlasAttributeDef(name, dataType.getTypeName(), false, AtlasStructDef.AtlasAttributeDef.Cardinality.SINGLE, 1, 1, false, true, Collections.emptyList());
    }

    public static AtlasEnumDef createEnumTypeDef(String name, String description, AtlasEnumDef.AtlasEnumElementDef ... enumValues) {
        return new AtlasEnumDef(name, description, "1.0", Arrays.asList(enumValues));
    }

    public static AtlasClassificationDef createTraitTypeDef(String name, ImmutableSet<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createTraitTypeDef(name, null, superTypes, attrDefs);
    }

    public static AtlasClassificationDef createTraitTypeDef(String name, String description, ImmutableSet<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createTraitTypeDef(name, description, "1.0", superTypes, attrDefs);
    }

    public static AtlasClassificationDef createTraitTypeDef(String name, String description, String version, ImmutableSet<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasClassificationDef(name, description, version, Arrays.asList(attrDefs), (Set<String>)superTypes);
    }

    public static AtlasStructDef createStructTypeDef(String name, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createStructTypeDef(name, null, attrDefs);
    }

    public static AtlasStructDef createStructTypeDef(String name, String description, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasStructDef(name, description, "1.0", Arrays.asList(attrDefs));
    }

    public static AtlasEntityDef createClassTypeDef(String name, ImmutableSet<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createClassTypeDef(name, null, "1.0", superTypes, attrDefs);
    }

    public static AtlasEntityDef createClassTypeDef(String name, String description, ImmutableSet<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return AtlasTypeUtil.createClassTypeDef(name, description, "1.0", superTypes, attrDefs);
    }

    public static AtlasEntityDef createClassTypeDef(String name, String description, String version, ImmutableSet<String> superTypes, AtlasStructDef.AtlasAttributeDef ... attrDefs) {
        return new AtlasEntityDef(name, description, version, Arrays.asList(attrDefs), (Set<String>)superTypes);
    }

    public static AtlasTypesDef getTypesDef(List<AtlasEnumDef> enums, List<AtlasStructDef> structs, List<AtlasClassificationDef> traits, List<AtlasEntityDef> classes) {
        return new AtlasTypesDef(enums, structs, traits, classes);
    }

    public static List<AtlasTypeDefHeader> toTypeDefHeader(AtlasTypesDef typesDef) {
        LinkedList<AtlasTypeDefHeader> headerList = new LinkedList<AtlasTypeDefHeader>();
        if (CollectionUtils.isNotEmpty(typesDef.getEnumDefs())) {
            for (AtlasEnumDef enumDef : typesDef.getEnumDefs()) {
                headerList.add(new AtlasTypeDefHeader(enumDef));
            }
        }
        if (CollectionUtils.isNotEmpty(typesDef.getStructDefs())) {
            for (AtlasStructDef structDef : typesDef.getStructDefs()) {
                headerList.add(new AtlasTypeDefHeader(structDef));
            }
        }
        if (CollectionUtils.isNotEmpty(typesDef.getClassificationDefs())) {
            for (AtlasClassificationDef classificationDef : typesDef.getClassificationDefs()) {
                headerList.add(new AtlasTypeDefHeader(classificationDef));
            }
        }
        if (CollectionUtils.isNotEmpty(typesDef.getEntityDefs())) {
            for (AtlasEntityDef entityDef : typesDef.getEntityDefs()) {
                headerList.add(new AtlasTypeDefHeader(entityDef));
            }
        }
        return headerList;
    }

    public static Collection<AtlasObjectId> toObjectIds(Collection<AtlasEntity> entities) {
        ArrayList<AtlasObjectId> ret = new ArrayList<AtlasObjectId>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (AtlasEntity entity : entities) {
                if (entity == null) continue;
                ret.add(AtlasTypeUtil.getAtlasObjectId(entity));
            }
        }
        return ret;
    }

    public static Map toStructAttributes(Map map) {
        if (map != null && map.containsKey("typeName") && map.containsKey("attributes") && map.get("attributes") instanceof Map) {
            return (Map)map.get("attributes");
        }
        return map;
    }

    public static AtlasObjectId getAtlasObjectId(AtlasEntity entity) {
        return new AtlasObjectId(entity.getGuid(), entity.getTypeName());
    }

    public static AtlasObjectId getAtlasObjectId(AtlasEntityHeader header) {
        return new AtlasObjectId(header.getGuid(), header.getTypeName());
    }

    public static boolean isValidGuid(AtlasObjectId objId) {
        return AtlasTypeUtil.isValidGuid(objId.getGuid());
    }

    public static boolean isAssignedGuid(AtlasObjectId objId) {
        return AtlasTypeUtil.isAssignedGuid(objId.getGuid());
    }

    public static boolean isUnAssignedGuid(AtlasObjectId objId) {
        return AtlasTypeUtil.isUnAssignedGuid(objId.getGuid());
    }

    public static boolean isValidGuid(String guid) {
        return AtlasTypeUtil.isAssignedGuid(guid) || AtlasTypeUtil.isUnAssignedGuid(guid);
    }

    public static boolean isAssignedGuid(String guid) {
        if (guid != null) {
            try {
                UUID.fromString(guid);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isUnAssignedGuid(String guid) {
        return guid != null && guid.length() > 0 && guid.charAt(0) == '-';
    }

    public static boolean isValid(AtlasObjectId objId) {
        if (AtlasTypeUtil.isAssignedGuid(objId) || AtlasTypeUtil.isUnAssignedGuid(objId)) {
            return true;
        }
        return StringUtils.isNotEmpty((String)objId.getTypeName()) && MapUtils.isNotEmpty(objId.getUniqueAttributes());
    }

    public static String toDebugString(AtlasTypesDef typesDef) {
        StringBuilder sb = new StringBuilder();
        sb.append("typesDef={");
        if (typesDef != null) {
            sb.append("enumDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getEnumDefs(), sb);
            sb.append("],");
            sb.append("structDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getStructDefs(), sb);
            sb.append("],");
            sb.append("classificationDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getClassificationDefs(), sb);
            sb.append("],");
            sb.append("entityDefs=[");
            AtlasTypeUtil.dumpTypeNames(typesDef.getEntityDefs(), sb);
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }

    private static void dumpTypeNames(List<? extends AtlasBaseTypeDef> typeDefs, StringBuilder sb) {
        if (CollectionUtils.isNotEmpty(typeDefs)) {
            for (int i = 0; i < typeDefs.size(); ++i) {
                AtlasBaseTypeDef typeDef = typeDefs.get(i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(typeDef.getName());
            }
        }
    }

    static {
        Collections.addAll(ATLAS_BUILTIN_TYPENAMES, AtlasBaseTypeDef.ATLAS_BUILTIN_TYPES);
    }
}

