/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.io.IOException;
import java.util.List;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.codehaus.jackson.map.ObjectMapper;

public abstract class AtlasType {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final String typeName;
    private final TypeCategory typeCategory;

    protected AtlasType(AtlasBaseTypeDef typeDef) {
        this(typeDef.getName(), typeDef.getCategory());
    }

    protected AtlasType(String typeName, TypeCategory typeCategory) {
        this.typeName = typeName;
        this.typeCategory = typeCategory;
    }

    public void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
    }

    public void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
    }

    public String getTypeName() {
        return this.typeName;
    }

    public TypeCategory getTypeCategory() {
        return this.typeCategory;
    }

    public abstract Object createDefaultValue();

    public Object createOptionalDefaultValue() {
        return this.createDefaultValue();
    }

    public abstract boolean isValidValue(Object var1);

    public abstract Object getNormalizedValue(Object var1);

    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = this.isValidValue(obj);
        if (!ret) {
            messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
        }
        return ret;
    }

    public boolean isValidValueForUpdate(Object obj) {
        return this.isValidValue(obj);
    }

    public Object getNormalizedValueForUpdate(Object obj) {
        return this.getNormalizedValue(obj);
    }

    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        return this.validateValue(obj, objName, messages);
    }

    public AtlasType getTypeForAttribute() {
        return this;
    }

    public static String toJson(Object obj) {
        String ret;
        try {
            ret = mapper.writeValueAsString(obj);
        }
        catch (IOException e) {
            ret = null;
        }
        return ret;
    }

    public static <T> T fromJson(String jsonStr, Class<T> type) {
        Object ret;
        try {
            ret = mapper.readValue(jsonStr, type);
        }
        catch (IOException e) {
            ret = null;
        }
        return (T)ret;
    }
}

