/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasArrayType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasMapType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasStructType
extends AtlasType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasStructType.class);
    private final AtlasStructDef structDef;
    protected Map<String, AtlasAttribute> allAttributes = Collections.emptyMap();
    protected Map<String, AtlasAttribute> uniqAttributes = Collections.emptyMap();

    public AtlasStructType(AtlasStructDef structDef) {
        super(structDef);
        this.structDef = structDef;
    }

    public AtlasStructType(AtlasStructDef structDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(structDef);
        this.structDef = structDef;
        this.resolveReferences(typeRegistry);
    }

    public AtlasStructDef getStructDef() {
        return this.structDef;
    }

    public AtlasType getAttributeType(String attributeName) {
        AtlasAttribute attribute = this.getAttribute(attributeName);
        return attribute != null ? attribute.getAttributeType() : null;
    }

    public AtlasStructDef.AtlasAttributeDef getAttributeDef(String attributeName) {
        AtlasAttribute attribute = this.getAttribute(attributeName);
        return attribute != null ? attribute.getAttributeDef() : null;
    }

    @Override
    public void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        HashMap<String, AtlasAttribute> a = new HashMap<String, AtlasAttribute>();
        for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
            AtlasType attrType = typeRegistry.getType(attributeDef.getTypeName());
            AtlasAttribute attribute = new AtlasAttribute(this, attributeDef, attrType);
            AtlasStructDef.AtlasAttributeDef.Cardinality cardinality = attributeDef.getCardinality();
            if (cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.LIST || cardinality == AtlasStructDef.AtlasAttributeDef.Cardinality.SET) {
                if (!(attrType instanceof AtlasArrayType)) {
                    throw new AtlasBaseException(AtlasErrorCode.INVALID_ATTRIBUTE_TYPE_FOR_CARDINALITY, this.getTypeName(), attributeDef.getName());
                }
                AtlasArrayType arrayType = (AtlasArrayType)attrType;
                arrayType.setMinCount(attributeDef.getValuesMinCount());
                arrayType.setMaxCount(attributeDef.getValuesMaxCount());
            }
            a.put(attributeDef.getName(), attribute);
        }
        this.resolveConstraints(typeRegistry);
        this.allAttributes = Collections.unmodifiableMap(a);
        this.uniqAttributes = this.getUniqueAttributes(this.allAttributes);
    }

    private void resolveConstraints(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        for (AtlasStructDef.AtlasAttributeDef attributeDef : this.getStructDef().getAttributeDefs()) {
            if (CollectionUtils.isEmpty(attributeDef.getConstraints())) continue;
            for (AtlasStructDef.AtlasConstraintDef constraint : attributeDef.getConstraints()) {
                AtlasEntityType attrType;
                if (constraint.isConstraintType("ownedRef")) {
                    attrType = this.getReferencedEntityType(typeRegistry.getType(attributeDef.getTypeName()));
                    if (attrType != null) continue;
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_OWNED_REF_ATTRIBUTE_INVALID_TYPE, this.getTypeName(), attributeDef.getName(), "ownedRef", attributeDef.getTypeName());
                }
                if (!constraint.isConstraintType("inverseRef")) continue;
                attrType = this.getReferencedEntityType(typeRegistry.getType(attributeDef.getTypeName()));
                if (attrType == null) {
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_INVERSE_REF_ATTRIBUTE_INVALID_TYPE, this.getTypeName(), attributeDef.getName(), "inverseRef", attributeDef.getTypeName());
                }
                String inverseRefAttrName = AtlasTypeUtil.getStringValue(constraint.getParams(), "attribute");
                if (StringUtils.isBlank((String)inverseRefAttrName)) {
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_MISSING_PARAMS, this.getTypeName(), attributeDef.getName(), "attribute", "inverseRef", String.valueOf(constraint.getParams()));
                }
                AtlasStructDef.AtlasAttributeDef inverseRefAttrDef = attrType.getStructDef().getAttribute(inverseRefAttrName);
                if (inverseRefAttrDef == null) {
                    throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_INVERSE_REF_INVERSE_ATTRIBUTE_NON_EXISTING, this.getTypeName(), attributeDef.getName(), "inverseRef", attrType.getTypeName(), inverseRefAttrName);
                }
                AtlasEntityType inverseRefAttrType = this.getReferencedEntityType(typeRegistry.getType(inverseRefAttrDef.getTypeName()));
                if (inverseRefAttrType != null) continue;
                throw new AtlasBaseException(AtlasErrorCode.CONSTRAINT_INVERSE_REF_INVERSE_ATTRIBUTE_INVALID_TYPE, this.getTypeName(), attributeDef.getName(), "inverseRef", attrType.getTypeName(), inverseRefAttrName);
            }
        }
    }

    @Override
    public void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (AtlasAttribute attribute : this.allAttributes.values()) {
            if (attribute.getInverseRefAttributeName() == null) continue;
            AtlasType referencedType = typeRegistry.getType(attribute.getAttributeDef().getTypeName());
            AtlasEntityType referencedEntityType = this.getReferencedEntityType(referencedType);
            AtlasAttribute inverseReference = referencedEntityType.getAttribute(attribute.getInverseRefAttributeName());
            attribute.setInverseRefAttribute(inverseReference);
        }
    }

    @Override
    public AtlasStruct createDefaultValue() {
        AtlasStruct ret = new AtlasStruct(this.structDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    public Map<String, AtlasAttribute> getAllAttributes() {
        return this.allAttributes;
    }

    public Map<String, AtlasAttribute> getUniqAttributes() {
        return this.uniqAttributes;
    }

    public AtlasAttribute getAttribute(String attributeName) {
        return this.allAttributes.get(attributeName);
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    if (this.isAssignableValue(structObj.getAttribute(attributeDef.getName()), attributeDef)) continue;
                    return false;
                }
            } else if (obj instanceof Map) {
                Map map = AtlasTypeUtil.toStructAttributes((Map)obj);
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    if (this.isAssignableValue(map.get(attributeDef.getName()), attributeDef)) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            Map attributes;
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                attributes = structObj.getAttributes();
            } else if (obj instanceof Map) {
                attributes = AtlasTypeUtil.toStructAttributes((Map)obj);
            } else {
                return false;
            }
            if (MapUtils.isNotEmpty((Map)attributes)) {
                for (Map.Entry e : attributes.entrySet()) {
                    String attrName = (String)e.getKey();
                    Object attrValue = e.getValue();
                    AtlasStructDef.AtlasAttributeDef attrDef = this.structDef.getAttribute(attrName);
                    if (attrValue == null || attrDef == null || this.isAssignableValueForUpdate(attrValue, attrDef)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValue(obj)) {
            if (obj instanceof AtlasStruct) {
                this.normalizeAttributeValues((AtlasStruct)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValues((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public Object getNormalizedValueForUpdate(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValueForUpdate(obj)) {
            if (obj instanceof AtlasStruct) {
                this.normalizeAttributeValuesForUpdate((AtlasStruct)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValuesForUpdate((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    String attrName = attributeDef.getName();
                    AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
                    if (attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    Object value = structObj.getAttribute(attrName);
                    String fieldName = objName + "." + attrName;
                    if (value != null) {
                        ret = dataType.validateValue(value, fieldName, messages) && ret;
                        continue;
                    }
                    if (attributeDef.getIsOptional()) continue;
                    ret = false;
                    messages.add(fieldName + ": mandatory attribute value missing in type " + this.getTypeName());
                }
            } else if (obj instanceof Map) {
                Map attributes = AtlasTypeUtil.toStructAttributes((Map)obj);
                for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                    String attrName = attributeDef.getName();
                    AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
                    if (attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    Object value = attributes.get(attrName);
                    String fieldName = objName + "." + attrName;
                    if (value != null) {
                        ret = dataType.validateValue(value, fieldName, messages) && ret;
                        continue;
                    }
                    if (attributeDef.getIsOptional()) continue;
                    ret = false;
                    messages.add(fieldName + ": mandatory attribute value missing in type " + this.getTypeName());
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        Map attributes = null;
        if (obj != null) {
            if (obj instanceof AtlasStruct) {
                AtlasStruct structObj = (AtlasStruct)obj;
                attributes = structObj.getAttributes();
            } else if (obj instanceof Map) {
                attributes = AtlasTypeUtil.toStructAttributes((Map)obj);
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
            if (MapUtils.isNotEmpty((Map)attributes)) {
                for (Map.Entry e : attributes.entrySet()) {
                    String fieldName;
                    String attrName = (String)e.getKey();
                    Object attrValue = e.getValue();
                    AtlasAttribute attribute = this.allAttributes.get(attrName);
                    if (attrValue == null || attribute == null) continue;
                    AtlasType dataType = attribute.getAttributeType();
                    ret = dataType.validateValueForUpdate(attrValue, fieldName = objName + "." + attrName, messages) && ret;
                }
            }
        }
        return ret;
    }

    public void normalizeAttributeValues(AtlasStruct obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                String attributeName = attributeDef.getName();
                if (obj.hasAttribute(attributeName)) {
                    Object attributeValue = this.getNormalizedValue(obj.getAttribute(attributeName), attributeDef);
                    obj.setAttribute(attributeName, attributeValue);
                    continue;
                }
                if (attributeDef.getIsOptional()) continue;
                obj.setAttribute(attributeName, this.createDefaultValue(attributeDef));
            }
        }
    }

    public void normalizeAttributeValuesForUpdate(AtlasStruct obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                String attributeName = attributeDef.getName();
                if (!obj.hasAttribute(attributeName)) continue;
                Object attributeValue = this.getNormalizedValueForUpdate(obj.getAttribute(attributeName), attributeDef);
                obj.setAttribute(attributeName, attributeValue);
            }
        }
    }

    public void normalizeAttributeValues(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                String attributeName = attributeDef.getName();
                if (obj.containsKey(attributeName)) {
                    Object attributeValue = this.getNormalizedValue(obj.get(attributeName), attributeDef);
                    obj.put(attributeName, attributeValue);
                    continue;
                }
                if (attributeDef.getIsOptional()) continue;
                obj.put(attributeName, this.createDefaultValue(attributeDef));
            }
        }
    }

    public void normalizeAttributeValuesForUpdate(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasStructDef.AtlasAttributeDef attrDef : this.structDef.getAttributeDefs()) {
                String attrName = attrDef.getName();
                Object attrValue = obj.get(attrName);
                if (!obj.containsKey(attrName)) continue;
                attrValue = this.getNormalizedValueForUpdate(attrValue, attrDef);
                obj.put(attrName, attrValue);
            }
        }
    }

    public void populateDefaultValues(AtlasStruct obj) {
        if (obj != null) {
            Map<String, Object> attributes = obj.getAttributes();
            if (attributes == null) {
                attributes = new HashMap<String, Object>();
            }
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.structDef.getAttributeDefs()) {
                if (attributeDef.getIsOptional()) continue;
                attributes.put(attributeDef.getName(), this.createDefaultValue(attributeDef));
            }
            obj.setAttributes(attributes);
        }
    }

    private Object createDefaultValue(AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasAttribute attribute;
        Object ret = null;
        if (attributeDef != null && (attribute = this.allAttributes.get(attributeDef.getName())) != null) {
            AtlasType dataType = attribute.getAttributeType();
            ret = dataType.createDefaultValue();
        }
        return ret;
    }

    private boolean isAssignableValue(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        boolean ret = true;
        if (value != null) {
            AtlasType attrType;
            AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
            if (attribute != null && !(attrType = attribute.getAttributeType()).isValidValue(value)) {
                ret = false;
            }
        } else if (!attributeDef.getIsOptional()) {
            ret = false;
        }
        return ret;
    }

    private boolean isAssignableValueForUpdate(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasType attrType;
        AtlasAttribute attribute;
        boolean ret = true;
        if (value != null && (attribute = this.allAttributes.get(attributeDef.getName())) != null && !(attrType = attribute.getAttributeType()).isValidValueForUpdate(value)) {
            ret = false;
        }
        return ret;
    }

    private Object getNormalizedValue(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
        if (attribute != null) {
            AtlasType attrType = attribute.getAttributeType();
            if (value == null) {
                if (!attributeDef.getIsOptional()) {
                    return attrType.createDefaultValue();
                }
            } else {
                return attrType.getNormalizedValue(value);
            }
        }
        return null;
    }

    private Object getNormalizedValueForUpdate(Object value, AtlasStructDef.AtlasAttributeDef attributeDef) {
        AtlasAttribute attribute = this.allAttributes.get(attributeDef.getName());
        if (attribute != null) {
            AtlasType attrType = attribute.getAttributeType();
            if (value != null) {
                return attrType.getNormalizedValueForUpdate(value);
            }
        }
        return null;
    }

    public String getQualifiedAttributeName(String attrName) throws AtlasBaseException {
        if (this.allAttributes.containsKey(attrName)) {
            return this.allAttributes.get(attrName).getQualifiedName();
        }
        throw new AtlasBaseException(AtlasErrorCode.UNKNOWN_ATTRIBUTE, attrName, this.structDef.getName());
    }

    private AtlasEntityType getReferencedEntityType(AtlasType type) {
        if (type instanceof AtlasArrayType) {
            type = ((AtlasArrayType)type).getElementType();
        }
        if (type instanceof AtlasMapType) {
            type = ((AtlasMapType)type).getValueType();
        }
        return type instanceof AtlasEntityType ? (AtlasEntityType)type : null;
    }

    protected Map<String, AtlasAttribute> getUniqueAttributes(Map<String, AtlasAttribute> attributes) {
        HashMap<String, AtlasAttribute> ret = new HashMap<String, AtlasAttribute>();
        if (MapUtils.isNotEmpty(attributes)) {
            for (AtlasAttribute attribute : attributes.values()) {
                if (!attribute.getAttributeDef().getIsUnique()) continue;
                ret.put(attribute.getName(), attribute);
            }
        }
        return Collections.unmodifiableMap(ret);
    }

    public static class AtlasAttribute {
        private final AtlasStructType definedInType;
        private final AtlasType attributeType;
        private final AtlasStructDef.AtlasAttributeDef attributeDef;
        private final String qualifiedName;
        private final String vertexPropertyName;
        private final boolean isOwnedRef;
        private final String inverseRefAttributeName;
        private AtlasAttribute inverseRefAttribute;
        private static String[][] RESERVED_CHAR_ENCODE_MAP = new String[][]{{"{", "_o"}, {"}", "_c"}, {"\"", "_q"}, {"$", "_d"}, {"%", "_p"}};

        public AtlasAttribute(AtlasStructType definedInType, AtlasStructDef.AtlasAttributeDef attrDef, AtlasType attributeType) {
            this.definedInType = definedInType;
            this.attributeDef = attrDef;
            this.attributeType = attributeType.getTypeForAttribute();
            this.qualifiedName = AtlasAttribute.getQualifiedAttributeName(definedInType.getStructDef(), this.attributeDef.getName());
            this.vertexPropertyName = AtlasAttribute.encodePropertyKey(this.qualifiedName);
            boolean isOwnedRef = false;
            String inverseRefAttribute = null;
            if (CollectionUtils.isNotEmpty(this.attributeDef.getConstraints())) {
                for (AtlasStructDef.AtlasConstraintDef constraint : this.attributeDef.getConstraints()) {
                    Object val;
                    if (constraint.isConstraintType("ownedRef")) {
                        isOwnedRef = true;
                    }
                    if (!constraint.isConstraintType("inverseRef") || (val = constraint.getParam("attribute")) == null) continue;
                    inverseRefAttribute = val.toString();
                }
            }
            this.isOwnedRef = isOwnedRef;
            this.inverseRefAttributeName = inverseRefAttribute;
        }

        public AtlasStructType getDefinedInType() {
            return this.definedInType;
        }

        public AtlasStructDef getDefinedInDef() {
            return this.definedInType.getStructDef();
        }

        public AtlasType getAttributeType() {
            return this.attributeType;
        }

        public AtlasStructDef.AtlasAttributeDef getAttributeDef() {
            return this.attributeDef;
        }

        public String getName() {
            return this.attributeDef.getName();
        }

        public String getTypeName() {
            return this.attributeDef.getTypeName();
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public String getVertexPropertyName() {
            return this.vertexPropertyName;
        }

        public boolean isOwnedRef() {
            return this.isOwnedRef;
        }

        public String getInverseRefAttributeName() {
            return this.inverseRefAttributeName;
        }

        public AtlasAttribute getInverseRefAttribute() {
            return this.inverseRefAttribute;
        }

        public void setInverseRefAttribute(AtlasAttribute inverseAttr) {
            this.inverseRefAttribute = inverseAttr;
        }

        public static String encodePropertyKey(String key) {
            if (StringUtils.isBlank((String)key)) {
                return key;
            }
            for (String[] strMap : RESERVED_CHAR_ENCODE_MAP) {
                key = key.replace(strMap[0], strMap[1]);
            }
            return key;
        }

        public static String decodePropertyKey(String key) {
            if (StringUtils.isBlank((String)key)) {
                return key;
            }
            for (String[] strMap : RESERVED_CHAR_ENCODE_MAP) {
                key = key.replace(strMap[1], strMap[0]);
            }
            return key;
        }

        private static String getQualifiedAttributeName(AtlasStructDef structDef, String attrName) {
            String typeName = structDef.getName();
            return attrName.contains(".") ? attrName : String.format("%s.%s", typeName, attrName);
        }
    }
}

