/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMapType
extends AtlasType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityType.class);
    private final String keyTypeName;
    private final String valueTypeName;
    private AtlasType keyType;
    private AtlasType valueType;

    public AtlasMapType(String keyTypeName, String valueTypeName) {
        super(AtlasBaseTypeDef.getMapTypeName(keyTypeName, valueTypeName), TypeCategory.MAP);
        this.keyTypeName = keyTypeName;
        this.valueTypeName = valueTypeName;
    }

    public AtlasMapType(AtlasType keyType, AtlasType valueType) {
        super(AtlasBaseTypeDef.getMapTypeName(keyType.getTypeName(), valueType.getTypeName()), TypeCategory.MAP);
        this.keyTypeName = keyType.getTypeName();
        this.valueTypeName = valueType.getTypeName();
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public AtlasMapType(String keyTypeName, String valueTypeName, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(AtlasBaseTypeDef.getMapTypeName(keyTypeName, valueTypeName), TypeCategory.MAP);
        this.keyTypeName = keyTypeName;
        this.valueTypeName = valueTypeName;
        this.resolveReferences(typeRegistry);
    }

    public String getKeyTypeName() {
        return this.keyTypeName;
    }

    public String getValueTypeName() {
        return this.valueTypeName;
    }

    public AtlasType getKeyType() {
        return this.keyType;
    }

    public AtlasType getValueType() {
        return this.valueType;
    }

    public void setKeyType(AtlasType keyType) {
        this.keyType = keyType;
    }

    @Override
    public void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        this.keyType = typeRegistry.getType(this.keyTypeName);
        this.valueType = typeRegistry.getType(this.valueTypeName);
    }

    @Override
    public Map<Object, Object> createDefaultValue() {
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Object key = this.keyType.createDefaultValue();
        if (key != null) {
            ret.put(key, this.valueType.createDefaultValue());
        }
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    if (this.keyType.isValidValue(e.getKey()) && this.valueType.isValidValue(e.getValue())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    if (this.keyType.isValidValueForUpdate(e.getKey()) && this.valueType.isValidValueForUpdate(e.getValue())) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<Object, Object> getNormalizedValue(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            Map map = (Map)obj;
            for (Map.Entry e : map.entrySet()) {
                Object normalizedKey = this.keyType.getNormalizedValue(e.getKey());
                if (normalizedKey != null) {
                    Object value = e.getValue();
                    if (value != null) {
                        Object normalizedValue = this.valueType.getNormalizedValue(e.getValue());
                        if (normalizedValue != null) {
                            ret.put(normalizedKey, normalizedValue);
                            continue;
                        }
                        return null;
                    }
                    ret.put(normalizedKey, value);
                    continue;
                }
                return null;
            }
            return ret;
        }
        return null;
    }

    @Override
    public Map<Object, Object> getNormalizedValueForUpdate(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Map) {
            HashMap<Object, Object> ret = new HashMap<Object, Object>();
            Map map = (Map)obj;
            for (Map.Entry e : map.entrySet()) {
                Object normalizedKey = this.keyType.getNormalizedValueForUpdate(e.getKey());
                if (normalizedKey != null) {
                    Object value = e.getValue();
                    if (value != null) {
                        Object normalizedValue = this.valueType.getNormalizedValueForUpdate(e.getValue());
                        if (normalizedValue != null) {
                            ret.put(normalizedKey, normalizedValue);
                            continue;
                        }
                        return null;
                    }
                    ret.put(normalizedKey, value);
                    continue;
                }
                return null;
            }
            return ret;
        }
        return null;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    Object key = e.getKey();
                    if (!this.keyType.isValidValue(key)) {
                        ret = false;
                        messages.add(objName + "." + key + ": invalid key for type " + this.getTypeName());
                        continue;
                    }
                    Object value = e.getValue();
                    ret = this.valueType.validateValue(value, objName + "." + key, messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof Map) {
                Map map = (Map)obj;
                for (Map.Entry e : map.entrySet()) {
                    Object key = e.getKey();
                    if (!this.keyType.isValidValueForUpdate(key)) {
                        ret = false;
                        messages.add(objName + "." + key + ": invalid key for type " + this.getTypeName());
                        continue;
                    }
                    Object value = e.getValue();
                    ret = this.valueType.validateValueForUpdate(value, objName + "." + key, messages) && ret;
                }
            } else {
                ret = false;
                messages.add(objName + "=" + obj + ": invalid value for type " + this.getTypeName());
            }
        }
        return ret;
    }

    @Override
    public AtlasType getTypeForAttribute() {
        AtlasType keyAttributeType = this.keyType.getTypeForAttribute();
        AtlasType valueAttributeType = this.valueType.getTypeForAttribute();
        if (keyAttributeType == this.keyType && valueAttributeType == this.valueType) {
            return this;
        }
        AtlasMapType attributeType = new AtlasMapType(keyAttributeType, valueAttributeType);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTypeForAttribute(): {} ==> {}", (Object)this.getTypeName(), (Object)attributeType.getTypeName());
        }
        return attributeType;
    }
}

