/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.atlas.type.AtlasTypeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasEntityType
extends AtlasStructType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasEntityType.class);
    private final AtlasEntityDef entityDef;
    private List<AtlasEntityType> superTypes = Collections.emptyList();
    private Set<String> allSuperTypes = Collections.emptySet();
    private Set<String> allSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSubTypes = Collections.emptySet();

    public AtlasEntityType(AtlasEntityDef entityDef) {
        super(entityDef);
        this.entityDef = entityDef;
    }

    public AtlasEntityType(AtlasEntityDef entityDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(entityDef);
        this.entityDef = entityDef;
        this.resolveReferences(typeRegistry);
    }

    public AtlasEntityDef getEntityDef() {
        return this.entityDef;
    }

    @Override
    public void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferences(typeRegistry);
        ArrayList<AtlasEntityType> s = new ArrayList<AtlasEntityType>();
        HashSet<String> allS = new HashSet<String>();
        HashMap<String, AtlasStructType.AtlasAttribute> allA = new HashMap<String, AtlasStructType.AtlasAttribute>();
        this.getTypeHierarchyInfo(typeRegistry, allS, allA);
        for (String superTypeName : this.entityDef.getSuperTypes()) {
            AtlasType superType = typeRegistry.getType(superTypeName);
            if (superType instanceof AtlasEntityType) {
                s.add((AtlasEntityType)superType);
                continue;
            }
            throw new AtlasBaseException(AtlasErrorCode.INCOMPATIBLE_SUPERTYPE, superTypeName, this.entityDef.getName());
        }
        this.superTypes = Collections.unmodifiableList(s);
        this.allSuperTypes = Collections.unmodifiableSet(allS);
        this.allAttributes = Collections.unmodifiableMap(allA);
        this.uniqAttributes = this.getUniqueAttributes(this.allAttributes);
        this.allSubTypes = new HashSet<String>();
        this.typeAndAllSubTypes = new HashSet<String>();
        this.typeAndAllSubTypes.add(this.getTypeName());
    }

    @Override
    public void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (String superTypeName : this.allSuperTypes) {
            AtlasEntityType superType = typeRegistry.getEntityTypeByName(superTypeName);
            superType.addSubType(this);
        }
    }

    public Set<String> getSuperTypes() {
        return this.entityDef.getSuperTypes();
    }

    public Set<String> getAllSuperTypes() {
        return this.allSuperTypes;
    }

    public Set<String> getAllSubTypes() {
        return Collections.unmodifiableSet(this.allSubTypes);
    }

    public Set<String> getTypeAndAllSubTypes() {
        return Collections.unmodifiableSet(this.typeAndAllSubTypes);
    }

    public boolean isSuperTypeOf(AtlasEntityType entityType) {
        return entityType != null && this.allSubTypes.contains(entityType.getTypeName());
    }

    public boolean isSuperTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.allSubTypes.contains(entityTypeName);
    }

    public boolean isSubTypeOf(AtlasEntityType entityType) {
        return entityType != null && this.allSuperTypes.contains(entityType.getTypeName());
    }

    public boolean isSubTypeOf(String entityTypeName) {
        return StringUtils.isNotEmpty((String)entityTypeName) && this.allSuperTypes.contains(entityTypeName);
    }

    @Override
    public AtlasEntity createDefaultValue() {
        AtlasEntity ret = new AtlasEntity(this.entityDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                if (superType.isValidValue(obj)) continue;
                return false;
            }
            return super.isValidValue(obj);
        }
        return true;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                if (superType.isValidValueForUpdate(obj)) continue;
                return false;
            }
            return super.isValidValueForUpdate(obj);
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValue(obj)) {
            if (obj instanceof AtlasEntity) {
                this.normalizeAttributeValues((AtlasEntity)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValues((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public Object getNormalizedValueForUpdate(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValueForUpdate(obj)) {
            if (obj instanceof AtlasEntity) {
                this.normalizeAttributeValuesForUpdate((AtlasEntity)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValuesForUpdate((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public AtlasStructType.AtlasAttribute getAttribute(String attributeName) {
        return (AtlasStructType.AtlasAttribute)this.allAttributes.get(attributeName);
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasEntity || obj instanceof Map) {
                for (AtlasEntityType superType : this.superTypes) {
                    ret = superType.validateValue(obj, objName, messages) && ret;
                }
                ret = super.validateValue(obj, objName, messages) && ret;
            } else {
                ret = false;
                messages.add(objName + ": invalid value type '" + obj.getClass().getName());
            }
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            if (obj instanceof AtlasEntity || obj instanceof Map) {
                for (AtlasEntityType superType : this.superTypes) {
                    ret = superType.validateValueForUpdate(obj, objName, messages) && ret;
                }
                ret = super.validateValueForUpdate(obj, objName, messages) && ret;
            } else {
                ret = false;
                messages.add(objName + ": invalid value type '" + obj.getClass().getName());
            }
        }
        return ret;
    }

    @Override
    public AtlasType getTypeForAttribute() {
        AtlasBuiltInTypes.AtlasObjectIdType attributeType = new AtlasBuiltInTypes.AtlasObjectIdType(this.getTypeName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("getTypeForAttribute(): {} ==> {}", (Object)this.getTypeName(), (Object)attributeType.getTypeName());
        }
        return attributeType;
    }

    public void normalizeAttributeValues(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValues(ent);
            }
            super.normalizeAttributeValues(ent);
        }
    }

    public void normalizeAttributeValuesForUpdate(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(ent);
            }
            super.normalizeAttributeValuesForUpdate(ent);
        }
    }

    @Override
    public void normalizeAttributeValues(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValues(obj);
            }
            super.normalizeAttributeValues(obj);
        }
    }

    @Override
    public void normalizeAttributeValuesForUpdate(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(obj);
            }
            super.normalizeAttributeValuesForUpdate(obj);
        }
    }

    public void populateDefaultValues(AtlasEntity ent) {
        if (ent != null) {
            for (AtlasEntityType superType : this.superTypes) {
                superType.populateDefaultValues(ent);
            }
            super.populateDefaultValues(ent);
        }
    }

    private void addSubType(AtlasEntityType subType) {
        this.allSubTypes.add(subType.getTypeName());
        this.typeAndAllSubTypes.add(subType.getTypeName());
    }

    private void getTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes) throws AtlasBaseException {
        ArrayList<String> visitedTypes = new ArrayList<String>();
        this.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
    }

    private void collectTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes, List<String> visitedTypes) throws AtlasBaseException {
        if (visitedTypes.contains(this.entityDef.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.CIRCULAR_REFERENCE, this.entityDef.getName(), visitedTypes.toString());
        }
        if (CollectionUtils.isNotEmpty(this.entityDef.getSuperTypes())) {
            visitedTypes.add(this.entityDef.getName());
            for (String superTypeName : this.entityDef.getSuperTypes()) {
                AtlasEntityType superType = typeRegistry.getEntityTypeByName(superTypeName);
                if (superType == null) continue;
                superType.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
            }
            visitedTypes.remove(this.entityDef.getName());
            allSuperTypeNames.addAll(this.entityDef.getSuperTypes());
        }
        if (CollectionUtils.isNotEmpty(this.entityDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.entityDef.getAttributeDefs()) {
                AtlasType type = typeRegistry.getType(attributeDef.getTypeName());
                allAttributes.put(attributeDef.getName(), new AtlasStructType.AtlasAttribute(this, attributeDef, type));
            }
        }
    }

    boolean isAssignableFrom(AtlasObjectId objId) {
        boolean ret = AtlasTypeUtil.isValid(objId) && (StringUtils.equals((String)objId.getTypeName(), (String)this.getTypeName()) || this.isSuperTypeOf(objId.getTypeName()));
        return ret;
    }
}

