/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.atlas.AtlasErrorCode;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasClassificationType
extends AtlasStructType {
    private static final Logger LOG = LoggerFactory.getLogger(AtlasClassificationType.class);
    private final AtlasClassificationDef classificationDef;
    private List<AtlasClassificationType> superTypes = Collections.emptyList();
    private Set<String> allSuperTypes = Collections.emptySet();
    private Set<String> allSubTypes = Collections.emptySet();
    private Set<String> typeAndAllSubTypes = Collections.emptySet();

    public AtlasClassificationType(AtlasClassificationDef classificationDef) {
        super(classificationDef);
        this.classificationDef = classificationDef;
    }

    public AtlasClassificationType(AtlasClassificationDef classificationDef, AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super(classificationDef);
        this.classificationDef = classificationDef;
        this.resolveReferences(typeRegistry);
    }

    public AtlasClassificationDef getClassificationDef() {
        return this.classificationDef;
    }

    @Override
    public void resolveReferences(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferences(typeRegistry);
        ArrayList<AtlasClassificationType> s = new ArrayList<AtlasClassificationType>();
        HashSet<String> allS = new HashSet<String>();
        HashMap<String, AtlasStructType.AtlasAttribute> allA = new HashMap<String, AtlasStructType.AtlasAttribute>();
        this.getTypeHierarchyInfo(typeRegistry, allS, allA);
        for (String superTypeName : this.classificationDef.getSuperTypes()) {
            AtlasType superType = typeRegistry.getType(superTypeName);
            if (superType instanceof AtlasClassificationType) {
                s.add((AtlasClassificationType)superType);
                continue;
            }
            throw new AtlasBaseException(AtlasErrorCode.INCOMPATIBLE_SUPERTYPE, superTypeName, this.classificationDef.getName());
        }
        this.superTypes = Collections.unmodifiableList(s);
        this.allSuperTypes = Collections.unmodifiableSet(allS);
        this.allAttributes = Collections.unmodifiableMap(allA);
        this.uniqAttributes = this.getUniqueAttributes(this.allAttributes);
        this.allSubTypes = new HashSet<String>();
        this.typeAndAllSubTypes = new HashSet<String>();
        this.typeAndAllSubTypes.add(this.getTypeName());
    }

    @Override
    public void resolveReferencesPhase2(AtlasTypeRegistry typeRegistry) throws AtlasBaseException {
        super.resolveReferencesPhase2(typeRegistry);
        for (String superTypeName : this.allSuperTypes) {
            AtlasClassificationType superType = typeRegistry.getClassificationTypeByName(superTypeName);
            superType.addSubType(this);
        }
    }

    private void addSubType(AtlasClassificationType subType) {
        this.allSubTypes.add(subType.getTypeName());
        this.typeAndAllSubTypes.add(subType.getTypeName());
    }

    public Set<String> getSuperTypes() {
        return this.classificationDef.getSuperTypes();
    }

    public Set<String> getAllSuperTypes() {
        return this.allSuperTypes;
    }

    public Set<String> getAllSubTypes() {
        return Collections.unmodifiableSet(this.allSubTypes);
    }

    public Set<String> getTypeAndAllSubTypes() {
        return Collections.unmodifiableSet(this.typeAndAllSubTypes);
    }

    public boolean isSuperTypeOf(AtlasClassificationType classificationType) {
        return classificationType != null && this.allSubTypes.contains(classificationType.getTypeName());
    }

    public boolean isSuperTypeOf(String classificationName) {
        return StringUtils.isNotEmpty((String)classificationName) && this.allSubTypes.contains(classificationName);
    }

    public boolean isSubTypeOf(AtlasClassificationType classificationType) {
        return classificationType != null && this.allSuperTypes.contains(classificationType.getTypeName());
    }

    public boolean isSubTypeOf(String classificationName) {
        return StringUtils.isNotEmpty((String)classificationName) && this.allSuperTypes.contains(classificationName);
    }

    @Override
    public AtlasClassification createDefaultValue() {
        AtlasClassification ret = new AtlasClassification(this.classificationDef.getName());
        this.populateDefaultValues(ret);
        return ret;
    }

    @Override
    public boolean isValidValue(Object obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                if (superType.isValidValue(obj)) continue;
                return false;
            }
            return super.isValidValue(obj);
        }
        return true;
    }

    @Override
    public boolean isValidValueForUpdate(Object obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                if (superType.isValidValueForUpdate(obj)) continue;
                return false;
            }
            return super.isValidValueForUpdate(obj);
        }
        return true;
    }

    @Override
    public Object getNormalizedValue(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValue(obj)) {
            if (obj instanceof AtlasClassification) {
                this.normalizeAttributeValues((AtlasClassification)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValues((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public Object getNormalizedValueForUpdate(Object obj) {
        Object ret = null;
        if (obj != null && this.isValidValueForUpdate(obj)) {
            if (obj instanceof AtlasClassification) {
                this.normalizeAttributeValuesForUpdate((AtlasClassification)obj);
                ret = obj;
            } else if (obj instanceof Map) {
                this.normalizeAttributeValuesForUpdate((Map)obj);
                ret = obj;
            }
        }
        return ret;
    }

    @Override
    public boolean validateValue(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                ret = superType.validateValue(obj, objName, messages) && ret;
            }
            ret = super.validateValue(obj, objName, messages) && ret;
        }
        return ret;
    }

    @Override
    public boolean validateValueForUpdate(Object obj, String objName, List<String> messages) {
        boolean ret = true;
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                ret = superType.validateValueForUpdate(obj, objName, messages) && ret;
            }
            ret = super.validateValueForUpdate(obj, objName, messages) && ret;
        }
        return ret;
    }

    public void normalizeAttributeValues(AtlasClassification classification) {
        if (classification != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValues(classification);
            }
            super.normalizeAttributeValues(classification);
        }
    }

    public void normalizeAttributeValuesForUpdate(AtlasClassification classification) {
        if (classification != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(classification);
            }
            super.normalizeAttributeValuesForUpdate(classification);
        }
    }

    @Override
    public void normalizeAttributeValues(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValues(obj);
            }
            super.normalizeAttributeValues(obj);
        }
    }

    @Override
    public void normalizeAttributeValuesForUpdate(Map<String, Object> obj) {
        if (obj != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.normalizeAttributeValuesForUpdate(obj);
            }
            super.normalizeAttributeValuesForUpdate(obj);
        }
    }

    public void populateDefaultValues(AtlasClassification classification) {
        if (classification != null) {
            for (AtlasClassificationType superType : this.superTypes) {
                superType.populateDefaultValues(classification);
            }
            super.populateDefaultValues(classification);
        }
    }

    private void getTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes) throws AtlasBaseException {
        ArrayList<String> visitedTypes = new ArrayList<String>();
        this.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
    }

    private void collectTypeHierarchyInfo(AtlasTypeRegistry typeRegistry, Set<String> allSuperTypeNames, Map<String, AtlasStructType.AtlasAttribute> allAttributes, List<String> visitedTypes) throws AtlasBaseException {
        if (visitedTypes.contains(this.classificationDef.getName())) {
            throw new AtlasBaseException(AtlasErrorCode.CIRCULAR_REFERENCE, this.classificationDef.getName(), visitedTypes.toString());
        }
        if (CollectionUtils.isNotEmpty(this.classificationDef.getSuperTypes())) {
            visitedTypes.add(this.classificationDef.getName());
            for (String superTypeName : this.classificationDef.getSuperTypes()) {
                AtlasClassificationType superType = typeRegistry.getClassificationTypeByName(superTypeName);
                if (superType == null) continue;
                superType.collectTypeHierarchyInfo(typeRegistry, allSuperTypeNames, allAttributes, visitedTypes);
            }
            visitedTypes.remove(this.classificationDef.getName());
            allSuperTypeNames.addAll(this.classificationDef.getSuperTypes());
        }
        if (CollectionUtils.isNotEmpty(this.classificationDef.getAttributeDefs())) {
            for (AtlasStructDef.AtlasAttributeDef attributeDef : this.classificationDef.getAttributeDefs()) {
                AtlasType type = typeRegistry.getType(attributeDef.getTypeName());
                allAttributes.put(attributeDef.getName(), new AtlasStructType.AtlasAttribute(this, attributeDef, type));
            }
        }
    }
}

