/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.instance.AtlasObjectId;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasType;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public class AtlasBuiltInTypes {

    public static class AtlasObjectIdType
    extends AtlasType {
        public static final String DEFAULT_UNASSIGNED_GUID = "-1";
        private final String objectType;

        public AtlasObjectIdType() {
            super("objectid", TypeCategory.OBJECT_ID_TYPE);
            this.objectType = "Asset";
        }

        public AtlasObjectIdType(String objectType) {
            super("objectid", TypeCategory.OBJECT_ID_TYPE);
            this.objectType = objectType;
        }

        public String getObjectType() {
            return this.objectType;
        }

        @Override
        public AtlasObjectId createDefaultValue() {
            return new AtlasObjectId(DEFAULT_UNASSIGNED_GUID, this.objectType);
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof AtlasObjectId) {
                return true;
            }
            if (obj instanceof Map) {
                return this.isValidMap((Map)obj);
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public AtlasObjectId getNormalizedValue(Object obj) {
            if (obj != null) {
                Map map;
                if (obj instanceof AtlasObjectId) {
                    return (AtlasObjectId)obj;
                }
                if (obj instanceof Map && this.isValidMap(map = (Map)obj)) {
                    return new AtlasObjectId(map);
                }
            }
            return null;
        }

        private boolean isValidMap(Map map) {
            Object uniqueAttributes;
            Object guid = map.get("guid");
            if (guid != null && StringUtils.isNotEmpty((String)guid.toString())) {
                return true;
            }
            Object typeName = map.get("typeName");
            return typeName != null && StringUtils.isNotEmpty((String)typeName.toString()) && (uniqueAttributes = map.get("uniqueAttributes")) instanceof Map && MapUtils.isNotEmpty((Map)((Map)uniqueAttributes));
        }
    }

    public static class AtlasStringType
    extends AtlasType {
        private static final String DEFAULT_VALUE = "";
        private static final String OPTIONAL_DEFAULT_VALUE = null;

        public AtlasStringType() {
            super("string", TypeCategory.PRIMITIVE);
        }

        @Override
        public String createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public Object createOptionalDefaultValue() {
            return OPTIONAL_DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            return true;
        }

        @Override
        public String getNormalizedValue(Object obj) {
            if (obj != null) {
                return obj.toString();
            }
            return null;
        }
    }

    public static class AtlasDateType
    extends AtlasType {
        private static final Date DEFAULT_VALUE = new Date(0L);

        public AtlasDateType() {
            super("date", TypeCategory.PRIMITIVE);
        }

        @Override
        public Date createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Date || obj instanceof Number) {
                return true;
            }
            if (obj instanceof String && StringUtils.isEmpty((String)((String)obj))) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public Date getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Date) {
                    return (Date)obj;
                }
                if (obj instanceof Number) {
                    return new Date(((Number)obj).longValue());
                }
                try {
                    return AtlasBaseTypeDef.DATE_FORMATTER.parse(obj.toString());
                }
                catch (ParseException excp) {
                    try {
                        long longDate = Long.valueOf(obj.toString());
                        return new Date(longDate);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return null;
        }
    }

    public static class AtlasBigDecimalType
    extends AtlasType {
        private static final BigDecimal DEFAULT_VALUE = BigDecimal.ZERO;

        public AtlasBigDecimalType() {
            super("bigdecimal", TypeCategory.PRIMITIVE);
        }

        @Override
        public BigDecimal createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public BigDecimal getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof BigDecimal) {
                    return (BigDecimal)obj;
                }
                if (obj instanceof BigInteger) {
                    return new BigDecimal((BigInteger)obj);
                }
                if (obj instanceof Number) {
                    return obj.equals(0) ? BigDecimal.ZERO : BigDecimal.valueOf(((Number)obj).doubleValue());
                }
                try {
                    return new BigDecimal(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class AtlasBigIntegerType
    extends AtlasType {
        private static final BigInteger DEFAULT_VALUE = BigInteger.ZERO;

        public AtlasBigIntegerType() {
            super("biginteger", TypeCategory.PRIMITIVE);
        }

        @Override
        public BigInteger createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public BigInteger getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof BigInteger) {
                    return (BigInteger)obj;
                }
                if (obj instanceof BigDecimal) {
                    return ((BigDecimal)obj).toBigInteger();
                }
                if (obj instanceof Number) {
                    return BigInteger.valueOf(((Number)obj).longValue());
                }
                try {
                    return new BigDecimal(obj.toString()).toBigInteger();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class AtlasDoubleType
    extends AtlasType {
        private static final Double DEFAULT_VALUE = 0.0;

        public AtlasDoubleType() {
            super("double", TypeCategory.PRIMITIVE);
        }

        @Override
        public Double createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public Double getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Double) {
                    return (Double)obj;
                }
                if (obj instanceof Number) {
                    return ((Number)obj).doubleValue();
                }
                try {
                    return Double.valueOf(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class AtlasFloatType
    extends AtlasType {
        private static final Float DEFAULT_VALUE = Float.valueOf(0.0f);

        public AtlasFloatType() {
            super("float", TypeCategory.PRIMITIVE);
        }

        @Override
        public Float createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public Float getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Float) {
                    return (Float)obj;
                }
                if (obj instanceof Number) {
                    return Float.valueOf(((Number)obj).floatValue());
                }
                try {
                    return Float.valueOf(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class AtlasLongType
    extends AtlasType {
        private static final Long DEFAULT_VALUE = 0L;

        public AtlasLongType() {
            super("long", TypeCategory.PRIMITIVE);
        }

        @Override
        public Long createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public Long getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Long) {
                    return (Long)obj;
                }
                if (obj instanceof Number) {
                    return ((Number)obj).longValue();
                }
                try {
                    return Long.valueOf(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class AtlasIntType
    extends AtlasType {
        private static final Integer DEFAULT_VALUE = 0;

        public AtlasIntType() {
            super("int", TypeCategory.PRIMITIVE);
        }

        @Override
        public Integer createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public Integer getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Integer) {
                    return (Integer)obj;
                }
                if (obj instanceof Number) {
                    return ((Number)obj).intValue();
                }
                try {
                    return Integer.valueOf(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class AtlasShortType
    extends AtlasType {
        private static final Short DEFAULT_VALUE = 0;

        public AtlasShortType() {
            super("short", TypeCategory.PRIMITIVE);
        }

        @Override
        public Short createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public Short getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Short) {
                    return (Short)obj;
                }
                if (obj instanceof Number) {
                    return ((Number)obj).shortValue();
                }
                try {
                    return Short.valueOf(obj.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public static class AtlasByteType
    extends AtlasType {
        private static final Byte DEFAULT_VALUE = 0;

        public AtlasByteType() {
            super("byte", TypeCategory.PRIMITIVE);
        }

        @Override
        public Byte createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            if (obj == null || obj instanceof Number) {
                return true;
            }
            return this.getNormalizedValue(obj) != null;
        }

        @Override
        public Byte getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Byte) {
                    return (Byte)obj;
                }
                if (obj instanceof Number) {
                    return ((Number)obj).byteValue();
                }
                String strValue = obj.toString();
                if (StringUtils.isNotEmpty((String)strValue)) {
                    return Byte.valueOf(strValue);
                }
            }
            return null;
        }
    }

    public static class AtlasBooleanType
    extends AtlasType {
        private static final Boolean DEFAULT_VALUE = Boolean.FALSE;

        public AtlasBooleanType() {
            super("boolean", TypeCategory.PRIMITIVE);
        }

        @Override
        public Boolean createDefaultValue() {
            return DEFAULT_VALUE;
        }

        @Override
        public boolean isValidValue(Object obj) {
            return true;
        }

        @Override
        public Boolean getNormalizedValue(Object obj) {
            if (obj != null) {
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
                return Boolean.valueOf(obj.toString());
            }
            return null;
        }
    }
}

