/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasTypeDefHeader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid;
    private String name;
    private TypeCategory category;

    public AtlasTypeDefHeader() {
        this(null, null, null);
    }

    public AtlasTypeDefHeader(String guid, String name, TypeCategory category) {
        this.guid = guid;
        this.name = name;
        this.category = category;
    }

    public AtlasTypeDefHeader(AtlasBaseTypeDef typeDef) {
        this(typeDef.getGuid(), typeDef.getName(), typeDef.getCategory());
    }

    public AtlasTypeDefHeader(AtlasTypeDefHeader other) {
        if (other == null) {
            this.setGuid(null);
            this.setName(null);
            this.setCategory(null);
        } else {
            this.setGuid(other.getGuid());
            this.setName(other.getName());
            this.setCategory(other.getCategory());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TypeCategory getCategory() {
        return this.category;
    }

    public void setCategory(TypeCategory category) {
        this.category = category;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtlasTypeDefHeader that = (AtlasTypeDefHeader)o;
        return Objects.equals(this.guid, that.guid) && Objects.equals(this.name, that.name) && this.category == that.category;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.guid, this.name, this.category});
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasTypeDefHeader{");
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", typeCategory='").append((Object)this.category).append('\'');
        sb.append('}');
        return sb;
    }
}

