/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasEnumDef
extends AtlasBaseTypeDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<AtlasEnumElementDef> elementDefs;
    private String defaultValue;

    public AtlasEnumDef() {
        this(null, null, null, null, null, null);
    }

    public AtlasEnumDef(String name) {
        this(name, null, null, null, null, null);
    }

    public AtlasEnumDef(String name, String description) {
        this(name, description, null, null, null, null);
    }

    public AtlasEnumDef(String name, String description, String typeVersion) {
        this(name, description, typeVersion, null, null, null);
    }

    public AtlasEnumDef(String name, String description, List<AtlasEnumElementDef> elementDefs) {
        this(name, description, null, elementDefs, null, null);
    }

    public AtlasEnumDef(String name, String description, String typeVersion, List<AtlasEnumElementDef> elementDefs) {
        this(name, description, typeVersion, elementDefs, null, null);
    }

    public AtlasEnumDef(String name, String description, String typeVersion, List<AtlasEnumElementDef> elementDefs, String defaultValue) {
        this(name, description, typeVersion, elementDefs, defaultValue, null);
    }

    public AtlasEnumDef(String name, String description, String typeVersion, List<AtlasEnumElementDef> elementDefs, String defaultValue, Map<String, String> options) {
        super(TypeCategory.ENUM, name, description, typeVersion, options);
        this.setElementDefs(elementDefs);
        this.setDefaultValue(defaultValue);
    }

    public AtlasEnumDef(AtlasEnumDef other) {
        super(other);
        if (other != null) {
            this.setElementDefs(other.getElementDefs());
            this.setDefaultValue(other.getDefaultValue());
        }
    }

    public List<AtlasEnumElementDef> getElementDefs() {
        return this.elementDefs;
    }

    public void setElementDefs(List<AtlasEnumElementDef> elementDefs) {
        if (elementDefs != null && this.elementDefs == elementDefs) {
            return;
        }
        if (CollectionUtils.isEmpty(elementDefs)) {
            this.elementDefs = new ArrayList<AtlasEnumElementDef>();
        } else {
            ArrayList<AtlasEnumElementDef> tmpList = new ArrayList<AtlasEnumElementDef>(elementDefs.size());
            HashSet<String> elementValues = new HashSet<String>();
            ListIterator<AtlasEnumElementDef> iter = elementDefs.listIterator(elementDefs.size());
            while (iter.hasPrevious()) {
                AtlasEnumElementDef elementDef = iter.previous();
                String elementValue = elementDef != null ? elementDef.getValue() : null;
                if (elementValue == null || elementValues.contains(elementValue = elementValue.toLowerCase())) continue;
                tmpList.add(new AtlasEnumElementDef(elementDef));
                elementValues.add(elementValue);
            }
            Collections.reverse(tmpList);
            this.elementDefs = tmpList;
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public AtlasEnumElementDef getElement(String elemValue) {
        return AtlasEnumDef.findElement(this.elementDefs, elemValue);
    }

    public void addElement(AtlasEnumElementDef elementDef) {
        List<AtlasEnumElementDef> e = this.elementDefs;
        ArrayList<AtlasEnumElementDef> tmpList = new ArrayList<AtlasEnumElementDef>();
        if (CollectionUtils.isNotEmpty(e)) {
            for (AtlasEnumElementDef existingElem : e) {
                if (StringUtils.equalsIgnoreCase((String)existingElem.getValue(), (String)elementDef.getValue())) continue;
                tmpList.add(existingElem);
            }
        }
        tmpList.add(new AtlasEnumElementDef(elementDef));
        this.elementDefs = tmpList;
    }

    public void removeElement(String elemValue) {
        List<AtlasEnumElementDef> e = this.elementDefs;
        if (AtlasEnumDef.hasElement(e, elemValue)) {
            ArrayList<AtlasEnumElementDef> tmpList = new ArrayList<AtlasEnumElementDef>();
            for (AtlasEnumElementDef existingElem : e) {
                if (StringUtils.equalsIgnoreCase((String)existingElem.getValue(), (String)elemValue)) continue;
                tmpList.add(existingElem);
            }
            this.elementDefs = tmpList;
        }
    }

    public boolean hasElement(String elemValue) {
        return this.getElement(elemValue) != null;
    }

    private static boolean hasElement(List<AtlasEnumElementDef> elementDefs, String elemValue) {
        return AtlasEnumDef.findElement(elementDefs, elemValue) != null;
    }

    private static AtlasEnumElementDef findElement(List<AtlasEnumElementDef> elementDefs, String elemValue) {
        AtlasEnumElementDef ret = null;
        if (CollectionUtils.isNotEmpty(elementDefs)) {
            for (AtlasEnumElementDef elementDef : elementDefs) {
                if (!StringUtils.equalsIgnoreCase((String)elementDef.getValue(), (String)elemValue)) continue;
                ret = elementDef;
                break;
            }
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasEnumDef{");
        super.toString(sb);
        sb.append(", elementDefs=[");
        AtlasEnumDef.dumpObjects(this.elementDefs, sb);
        sb.append("]");
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasEnumDef that = (AtlasEnumDef)o;
        return Objects.equals(this.elementDefs, that.elementDefs) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementDefs, this.defaultValue);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEnumDef.class})
    public static class AtlasEnumDefs
    extends PList<AtlasEnumDef> {
        private static final long serialVersionUID = 1L;

        public AtlasEnumDefs() {
        }

        public AtlasEnumDefs(List<AtlasEnumDef> list) {
            super(list);
        }

        public AtlasEnumDefs(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasEnumElementDef
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String value;
        private String description;
        private Integer ordinal;

        public AtlasEnumElementDef() {
            this(null, null, null);
        }

        public AtlasEnumElementDef(String value, String description, Integer ordinal) {
            this.setValue(value);
            this.setDescription(description);
            this.setOrdinal(ordinal);
        }

        public AtlasEnumElementDef(AtlasEnumElementDef other) {
            if (other != null) {
                this.setValue(other.getValue());
                this.setDescription(other.getDescription());
                this.setOrdinal(other.getOrdinal());
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getOrdinal() {
            return this.ordinal;
        }

        public void setOrdinal(Integer ordinal) {
            this.ordinal = ordinal;
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasEnumElementDef{");
            sb.append("value='").append(this.value).append('\'');
            sb.append(", description='").append(this.description).append('\'');
            sb.append(", ordinal=").append(this.ordinal);
            sb.append('}');
            return sb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AtlasEnumElementDef that = (AtlasEnumElementDef)o;
            return Objects.equals(this.value, that.value) && Objects.equals(this.description, that.description) && Objects.equals(this.ordinal, that.ordinal);
        }

        public int hashCode() {
            return Objects.hash(this.value, this.description, this.ordinal);
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }
}

