/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.typedef;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.TypeCategory;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.commons.collections.CollectionUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasEntityDef
extends AtlasStructDef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<String> superTypes;

    public AtlasEntityDef() {
        this((String)null, (String)null, (String)null, (List<AtlasStructDef.AtlasAttributeDef>)null, (Set<String>)null, (Map<String, String>)null);
    }

    public AtlasEntityDef(String name) {
        this(name, null, null, null, null, null);
    }

    public AtlasEntityDef(String name, String description) {
        this(name, description, null, null, null, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion) {
        this(name, description, typeVersion, null, null, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs) {
        this(name, description, typeVersion, attributeDefs, null, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes) {
        this(name, description, typeVersion, attributeDefs, superTypes, null);
    }

    public AtlasEntityDef(String name, String description, String typeVersion, List<AtlasStructDef.AtlasAttributeDef> attributeDefs, Set<String> superTypes, Map<String, String> options) {
        super(TypeCategory.ENTITY, name, description, typeVersion, attributeDefs, options);
        this.setSuperTypes(superTypes);
    }

    public AtlasEntityDef(AtlasEntityDef other) {
        super(other);
        this.setSuperTypes(other != null ? other.getSuperTypes() : null);
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    public void setSuperTypes(Set<String> superTypes) {
        if (superTypes != null && this.superTypes == superTypes) {
            return;
        }
        this.superTypes = CollectionUtils.isEmpty(superTypes) ? new HashSet<String>() : new HashSet<String>(superTypes);
    }

    public boolean hasSuperType(String typeName) {
        return AtlasEntityDef.hasSuperType(this.superTypes, typeName);
    }

    public void addSuperType(String typeName) {
        Set<String> s = this.superTypes;
        if (!AtlasEntityDef.hasSuperType(s, typeName)) {
            s = new HashSet<String>(s);
            s.add(typeName);
            this.superTypes = s;
        }
    }

    public void removeSuperType(String typeName) {
        Set<String> s = this.superTypes;
        if (AtlasEntityDef.hasSuperType(s, typeName)) {
            s = new HashSet<String>(s);
            s.remove(typeName);
            this.superTypes = s;
        }
    }

    private static boolean hasSuperType(Set<String> superTypes, String typeName) {
        return superTypes != null && typeName != null && superTypes.contains(typeName);
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasEntityDef{");
        super.toString(sb);
        sb.append(", superTypes=[");
        AtlasEntityDef.dumpObjects(this.superTypes, sb);
        sb.append("]");
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasEntityDef that = (AtlasEntityDef)o;
        return Objects.equals(this.superTypes, that.superTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.superTypes);
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEntityDef.class})
    public static class AtlasEntityDefs
    extends PList<AtlasEntityDef> {
        private static final long serialVersionUID = 1L;

        public AtlasEntityDefs() {
        }

        public AtlasEntityDefs(List<AtlasEntityDef> list) {
            super(list);
        }

        public AtlasEntityDefs(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

