/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.metrics;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AtlasMetrics {
    private Map<String, Map<String, Number>> data;

    public AtlasMetrics() {
        this.setData(null);
    }

    public AtlasMetrics(Map<String, Map<String, Number>> data) {
        this.setData(data);
    }

    public AtlasMetrics(AtlasMetrics other) {
        if (other != null) {
            this.setData(other.getData());
        }
    }

    public Map<String, Map<String, Number>> getData() {
        return this.data;
    }

    public void setData(Map<String, Map<String, Number>> data) {
        this.data = data;
    }

    @JsonIgnore
    public void addData(String groupKey, String key, Number value) {
        Map<String, Number> metricMap;
        Map<String, Map<String, Number>> data = this.data;
        if (data == null) {
            data = new HashMap<String, Map<String, Number>>();
        }
        if ((metricMap = data.get(groupKey)) == null) {
            metricMap = new HashMap<String, Number>();
            data.put(groupKey, metricMap);
        }
        metricMap.put(key, value);
        this.setData(data);
    }

    @JsonIgnore
    public Number getMetric(String groupKey, String key) {
        Map<String, Map<String, Number>> data = this.data;
        if (data == null) {
            return null;
        }
        Map<String, Number> metricMap = data.get(groupKey);
        if (metricMap == null || metricMap.isEmpty()) {
            return null;
        }
        return metricMap.get(key);
    }
}

