/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.apache.atlas.model.PList;
import org.apache.atlas.model.SearchFilter;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasEntityHeader
extends AtlasStruct
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String guid = null;
    private AtlasEntity.Status status = AtlasEntity.Status.ACTIVE;
    private String displayText = null;
    private List<String> classificationNames = null;

    public AtlasEntityHeader() {
        this(null, null);
    }

    public AtlasEntityHeader(String typeName) {
        this(typeName, null);
    }

    public AtlasEntityHeader(AtlasEntityDef entityDef) {
        this(entityDef != null ? entityDef.getName() : null, null);
    }

    public AtlasEntityHeader(String typeName, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.setClassificationNames(null);
    }

    public AtlasEntityHeader(String typeName, String guid, Map<String, Object> attributes) {
        super(typeName, attributes);
        this.setGuid(guid);
        this.setClassificationNames(null);
    }

    public AtlasEntityHeader(AtlasEntityHeader other) {
        super(other);
        if (other != null) {
            this.setGuid(other.getGuid());
            this.setStatus(other.getStatus());
            this.setDisplayText(other.getDisplayText());
            this.setClassificationNames(other.getClassificationNames());
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public AtlasEntity.Status getStatus() {
        return this.status;
    }

    public void setStatus(AtlasEntity.Status status) {
        this.status = status;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }

    public List<String> getClassificationNames() {
        return this.classificationNames;
    }

    public void setClassificationNames(List<String> classificationNames) {
        this.classificationNames = classificationNames;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasEntityHeader{");
        sb.append("guid='").append(this.guid).append('\'');
        sb.append(", status=").append((Object)this.status);
        sb.append(", displayText=").append(this.displayText);
        sb.append(", classificationNames=[");
        AtlasEntityHeader.dumpObjects(this.classificationNames, sb);
        sb.append("],");
        sb.append(", ");
        super.toString(sb);
        sb.append('}');
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasEntityHeader that = (AtlasEntityHeader)o;
        return Objects.equals(this.guid, that.guid) && this.status == that.status && Objects.equals(this.displayText, that.displayText) && Objects.equals(this.classificationNames, that.classificationNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.guid, this.status, this.displayText, this.classificationNames});
    }

    @Override
    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    @XmlSeeAlso(value={AtlasEntity.class})
    public static class AtlasEntityHeaders
    extends PList<AtlasEntityHeader> {
        private static final long serialVersionUID = 1L;

        public AtlasEntityHeaders() {
        }

        public AtlasEntityHeaders(List<AtlasEntityHeader> list) {
            super(list);
        }

        public AtlasEntityHeaders(List list, long startIndex, int pageSize, long totalCount, SearchFilter.SortType sortType, String sortBy) {
            super(list, startIndex, pageSize, totalCount, sortType, sortBy);
        }
    }
}

