/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.impexp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.impexp.AtlasExportRequest;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class AtlasExportResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ENTITY_COUNT = "entityCount";
    private AtlasExportRequest request;
    private String userName;
    private String clientIpAddress;
    private String hostName;
    private long timeStamp;
    private Map<String, Integer> metrics;
    private AtlasExportData data;
    private OperationStatus operationStatus;

    public AtlasExportResult() {
        this(null, null, null, null, System.currentTimeMillis());
    }

    public AtlasExportResult(AtlasExportRequest request, String userName, String clientIpAddress, String hostName, long timeStamp) {
        this.request = request;
        this.userName = userName;
        this.clientIpAddress = clientIpAddress;
        this.hostName = hostName;
        this.timeStamp = timeStamp;
        this.metrics = new HashMap<String, Integer>();
        this.operationStatus = OperationStatus.FAIL;
        this.data = new AtlasExportData();
    }

    public AtlasExportRequest getRequest() {
        return this.request;
    }

    public void setRequest(AtlasExportRequest request) {
        this.request = request;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getClientIpAddress() {
        return this.clientIpAddress;
    }

    public void setClientIpAddress(String clientIpAddress) {
        this.clientIpAddress = clientIpAddress;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Map<String, Integer> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Integer> metrics) {
        this.metrics = metrics;
    }

    public AtlasExportData getData() {
        return this.data;
    }

    public void setData(AtlasExportData data) {
        this.data = data;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public void setOperationStatus(OperationStatus operationStatus) {
        this.operationStatus = operationStatus;
    }

    public void incrementMeticsCounter(String key) {
        this.incrementMeticsCounter(key, 1);
    }

    public void incrementMeticsCounter(String key, int incrementBy) {
        int currentValue = this.metrics.containsKey(key) ? this.metrics.get(key) : 0;
        this.metrics.put(key, currentValue + incrementBy);
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("AtlasExportResult{");
        sb.append("request={").append(this.request).append("}");
        sb.append(", userName='").append(this.userName).append("'");
        sb.append(", clientIpAddress='").append(this.clientIpAddress).append("'");
        sb.append(", hostName='").append(this.hostName).append("'");
        sb.append(", timeStamp='").append(this.timeStamp).append("'");
        sb.append(", metrics={");
        AtlasBaseTypeDef.dumpObjects(this.metrics, sb);
        sb.append("}");
        sb.append(", data='").append(this.data).append("'");
        sb.append(", operationStatus='").append((Object)this.operationStatus).append("'");
        sb.append("}");
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static class AtlasExportData
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private AtlasTypesDef typesDef = new AtlasTypesDef();
        private Map<String, AtlasEntity> entities = new HashMap<String, AtlasEntity>();
        private List<String> entityCreationOrder = new ArrayList<String>();

        public AtlasTypesDef getTypesDef() {
            return this.typesDef;
        }

        public void setTypesDef(AtlasTypesDef typesDef) {
            this.typesDef = typesDef;
        }

        public Map<String, AtlasEntity> getEntities() {
            return this.entities;
        }

        public void setEntities(Map<String, AtlasEntity> entities) {
            this.entities = entities;
        }

        public List<String> getEntityCreationOrder() {
            return this.entityCreationOrder;
        }

        public void setEntityCreationOrder(List<String> entityCreationOrder) {
            this.entityCreationOrder = entityCreationOrder;
        }

        public StringBuilder toString(StringBuilder sb) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("AtlasExportData{");
            sb.append("typesDef={").append(this.typesDef).append("}");
            sb.append("entities={");
            AtlasBaseTypeDef.dumpObjects(this.entities, sb);
            sb.append("}");
            sb.append("entityCreationOrder={");
            AtlasBaseTypeDef.dumpObjects(this.entityCreationOrder, sb);
            sb.append("}");
            sb.append("}");
            return sb;
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }
    }

    public static enum OperationStatus {
        SUCCESS,
        PARTIAL_SUCCESS,
        FAIL;

    }
}

