/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.model.typedef.AtlasTypesDef;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasTypeRegistry {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassificationDefValidHierarchy() {
        AtlasClassificationDef classifiL0 = new AtlasClassificationDef("L0");
        AtlasClassificationDef classifiL1_1 = new AtlasClassificationDef("L1-1");
        AtlasClassificationDef classifiL1_2 = new AtlasClassificationDef("L1-2");
        AtlasClassificationDef classifiL2_1 = new AtlasClassificationDef("L2-1");
        AtlasClassificationDef classifiL2_2 = new AtlasClassificationDef("L2-2");
        AtlasClassificationDef classifiL2_3 = new AtlasClassificationDef("L2-3");
        AtlasClassificationDef classifiL2_4 = new AtlasClassificationDef("L2-4");
        classifiL1_1.addSuperType(classifiL0.getName());
        classifiL1_2.addSuperType(classifiL0.getName());
        classifiL2_1.addSuperType(classifiL1_1.getName());
        classifiL2_2.addSuperType(classifiL1_1.getName());
        classifiL2_3.addSuperType(classifiL1_1.getName());
        classifiL2_3.addSuperType(classifiL1_2.getName());
        classifiL2_4.addSuperType(classifiL1_2.getName());
        classifiL0.addAttribute(new AtlasStructDef.AtlasAttributeDef("L0_a1", "int"));
        classifiL1_1.addAttribute(new AtlasStructDef.AtlasAttributeDef("L1-1_a1", "int"));
        classifiL1_2.addAttribute(new AtlasStructDef.AtlasAttributeDef("L1-2_a1", "int"));
        classifiL2_1.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-1_a1", "int"));
        classifiL2_2.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-2_a1", "int"));
        classifiL2_3.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-3_a1", "int"));
        classifiL2_4.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-4_a1", "int"));
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getClassificationDefs().add(classifiL0);
        typesDef.getClassificationDefs().add(classifiL1_1);
        typesDef.getClassificationDefs().add(classifiL1_2);
        typesDef.getClassificationDefs().add(classifiL2_1);
        typesDef.getClassificationDefs().add(classifiL2_2);
        typesDef.getClassificationDefs().add(classifiL2_3);
        typesDef.getClassificationDefs().add(classifiL2_4);
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(typesDef);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNull((Object)failureMsg);
        this.validateSuperTypes(typeRegistry, "L0", new HashSet<String>());
        this.validateSuperTypes(typeRegistry, "L1-1", new HashSet<String>(Arrays.asList("L0")));
        this.validateSuperTypes(typeRegistry, "L1-2", new HashSet<String>(Arrays.asList("L0")));
        this.validateSuperTypes(typeRegistry, "L2-1", new HashSet<String>(Arrays.asList("L1-1", "L0")));
        this.validateSuperTypes(typeRegistry, "L2-2", new HashSet<String>(Arrays.asList("L1-1", "L0")));
        this.validateSuperTypes(typeRegistry, "L2-3", new HashSet<String>(Arrays.asList("L1-1", "L0", "L1-2")));
        this.validateSuperTypes(typeRegistry, "L2-4", new HashSet<String>(Arrays.asList("L1-2", "L0")));
        this.validateSubTypes(typeRegistry, "L0", new HashSet<String>(Arrays.asList("L1-1", "L1-2", "L2-1", "L2-2", "L2-3", "L2-4")));
        this.validateSubTypes(typeRegistry, "L1-1", new HashSet<String>(Arrays.asList("L2-1", "L2-2", "L2-3")));
        this.validateSubTypes(typeRegistry, "L1-2", new HashSet<String>(Arrays.asList("L2-3", "L2-4")));
        this.validateSubTypes(typeRegistry, "L2-1", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L2-2", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L2-3", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L2-4", new HashSet<String>());
        this.validateAttributeNames(typeRegistry, "L0", new HashSet<String>(Arrays.asList("L0_a1")));
        this.validateAttributeNames(typeRegistry, "L1-1", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1")));
        this.validateAttributeNames(typeRegistry, "L1-2", new HashSet<String>(Arrays.asList("L0_a1", "L1-2_a1")));
        this.validateAttributeNames(typeRegistry, "L2-1", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1", "L2-1_a1")));
        this.validateAttributeNames(typeRegistry, "L2-2", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1", "L2-2_a1")));
        this.validateAttributeNames(typeRegistry, "L2-3", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1", "L1-2_a1", "L2-3_a1")));
        this.validateAttributeNames(typeRegistry, "L2-4", new HashSet<String>(Arrays.asList("L0_a1", "L1-2_a1", "L2-4_a1")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassificationDefInvalidHierarchy_Self() {
        AtlasClassificationDef classifiDef1 = new AtlasClassificationDef("classifiDef-1");
        classifiDef1.addSuperType(classifiDef1.getName());
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addType((AtlasBaseTypeDef)classifiDef1);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNotNull((Object)failureMsg, (String)"expected invalid supertype failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClassificationDefInvalidHierarchy_CircularRef() {
        AtlasClassificationDef classifiL0 = new AtlasClassificationDef("L0");
        AtlasClassificationDef classifiL1_1 = new AtlasClassificationDef("L1-1");
        AtlasClassificationDef classifiL1_2 = new AtlasClassificationDef("L1-2");
        AtlasClassificationDef classifiL2_1 = new AtlasClassificationDef("L2-1");
        AtlasClassificationDef classifiL2_2 = new AtlasClassificationDef("L2-2");
        AtlasClassificationDef classifiL2_3 = new AtlasClassificationDef("L2-3");
        AtlasClassificationDef classifiL2_4 = new AtlasClassificationDef("L2-4");
        classifiL1_1.addSuperType(classifiL0.getName());
        classifiL1_2.addSuperType(classifiL0.getName());
        classifiL2_1.addSuperType(classifiL1_1.getName());
        classifiL2_2.addSuperType(classifiL1_1.getName());
        classifiL2_3.addSuperType(classifiL1_1.getName());
        classifiL2_3.addSuperType(classifiL1_2.getName());
        classifiL2_4.addSuperType(classifiL1_2.getName());
        classifiL0.addSuperType(classifiL2_3.getName());
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getClassificationDefs().add(classifiL0);
        typesDef.getClassificationDefs().add(classifiL1_1);
        typesDef.getClassificationDefs().add(classifiL1_2);
        typesDef.getClassificationDefs().add(classifiL2_1);
        typesDef.getClassificationDefs().add(classifiL2_2);
        typesDef.getClassificationDefs().add(classifiL2_3);
        typesDef.getClassificationDefs().add(classifiL2_4);
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(typesDef);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNotNull((Object)failureMsg, (String)"expected invalid supertype failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntityDefValidHierarchy() {
        AtlasEntityDef entL0 = new AtlasEntityDef("L0");
        AtlasEntityDef entL1_1 = new AtlasEntityDef("L1-1");
        AtlasEntityDef entL1_2 = new AtlasEntityDef("L1-2");
        AtlasEntityDef entL2_1 = new AtlasEntityDef("L2-1");
        AtlasEntityDef entL2_2 = new AtlasEntityDef("L2-2");
        AtlasEntityDef entL2_3 = new AtlasEntityDef("L2-3");
        AtlasEntityDef entL2_4 = new AtlasEntityDef("L2-4");
        entL1_1.addSuperType(entL0.getName());
        entL1_2.addSuperType(entL0.getName());
        entL2_1.addSuperType(entL1_1.getName());
        entL2_2.addSuperType(entL1_1.getName());
        entL2_3.addSuperType(entL1_1.getName());
        entL2_3.addSuperType(entL1_2.getName());
        entL2_4.addSuperType(entL1_2.getName());
        entL0.addAttribute(new AtlasStructDef.AtlasAttributeDef("L0_a1", "int"));
        entL1_1.addAttribute(new AtlasStructDef.AtlasAttributeDef("L1-1_a1", "int"));
        entL1_2.addAttribute(new AtlasStructDef.AtlasAttributeDef("L1-2_a1", "int"));
        entL2_1.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-1_a1", "int"));
        entL2_2.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-2_a1", "int"));
        entL2_3.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-3_a1", "int"));
        entL2_4.addAttribute(new AtlasStructDef.AtlasAttributeDef("L2-4_a1", "int"));
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getEntityDefs().add(entL0);
        typesDef.getEntityDefs().add(entL1_1);
        typesDef.getEntityDefs().add(entL1_2);
        typesDef.getEntityDefs().add(entL2_1);
        typesDef.getEntityDefs().add(entL2_2);
        typesDef.getEntityDefs().add(entL2_3);
        typesDef.getEntityDefs().add(entL2_4);
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(typesDef);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNull((Object)failureMsg);
        this.validateSuperTypes(typeRegistry, "L0", new HashSet<String>());
        this.validateSuperTypes(typeRegistry, "L1-1", new HashSet<String>(Arrays.asList("L0")));
        this.validateSuperTypes(typeRegistry, "L1-2", new HashSet<String>(Arrays.asList("L0")));
        this.validateSuperTypes(typeRegistry, "L2-1", new HashSet<String>(Arrays.asList("L1-1", "L0")));
        this.validateSuperTypes(typeRegistry, "L2-2", new HashSet<String>(Arrays.asList("L1-1", "L0")));
        this.validateSuperTypes(typeRegistry, "L2-3", new HashSet<String>(Arrays.asList("L1-1", "L0", "L1-2")));
        this.validateSuperTypes(typeRegistry, "L2-4", new HashSet<String>(Arrays.asList("L1-2", "L0")));
        this.validateSubTypes(typeRegistry, "L0", new HashSet<String>(Arrays.asList("L1-1", "L1-2", "L2-1", "L2-2", "L2-3", "L2-4")));
        this.validateSubTypes(typeRegistry, "L1-1", new HashSet<String>(Arrays.asList("L2-1", "L2-2", "L2-3")));
        this.validateSubTypes(typeRegistry, "L1-2", new HashSet<String>(Arrays.asList("L2-3", "L2-4")));
        this.validateSubTypes(typeRegistry, "L2-1", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L2-2", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L2-3", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L2-4", new HashSet<String>());
        this.validateAttributeNames(typeRegistry, "L0", new HashSet<String>(Arrays.asList("L0_a1")));
        this.validateAttributeNames(typeRegistry, "L1-1", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1")));
        this.validateAttributeNames(typeRegistry, "L1-2", new HashSet<String>(Arrays.asList("L0_a1", "L1-2_a1")));
        this.validateAttributeNames(typeRegistry, "L2-1", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1", "L2-1_a1")));
        this.validateAttributeNames(typeRegistry, "L2-2", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1", "L2-2_a1")));
        this.validateAttributeNames(typeRegistry, "L2-3", new HashSet<String>(Arrays.asList("L0_a1", "L1-1_a1", "L1-2_a1", "L2-3_a1")));
        this.validateAttributeNames(typeRegistry, "L2-4", new HashSet<String>(Arrays.asList("L0_a1", "L1-2_a1", "L2-4_a1")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntityDefInvalidHierarchy_Self() {
        AtlasEntityDef entDef1 = new AtlasEntityDef("entDef-1");
        entDef1.addSuperType(entDef1.getName());
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addType((AtlasBaseTypeDef)entDef1);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNotNull((Object)failureMsg, (String)"expected invalid supertype failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEntityDefInvalidHierarchy_CircularRef() {
        AtlasEntityDef entL0 = new AtlasEntityDef("L0");
        AtlasEntityDef entL1_1 = new AtlasEntityDef("L1-1");
        AtlasEntityDef entL1_2 = new AtlasEntityDef("L1-2");
        AtlasEntityDef entL2_1 = new AtlasEntityDef("L2-1");
        AtlasEntityDef entL2_2 = new AtlasEntityDef("L2-2");
        AtlasEntityDef entL2_3 = new AtlasEntityDef("L2-3");
        AtlasEntityDef entL2_4 = new AtlasEntityDef("L2-4");
        entL1_1.addSuperType(entL0.getName());
        entL1_2.addSuperType(entL0.getName());
        entL2_1.addSuperType(entL1_1.getName());
        entL2_2.addSuperType(entL1_1.getName());
        entL2_3.addSuperType(entL1_1.getName());
        entL2_3.addSuperType(entL1_2.getName());
        entL2_4.addSuperType(entL1_2.getName());
        entL0.addSuperType(entL2_3.getName());
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getEntityDefs().add(entL0);
        typesDef.getEntityDefs().add(entL1_1);
        typesDef.getEntityDefs().add(entL1_2);
        typesDef.getEntityDefs().add(entL2_1);
        typesDef.getEntityDefs().add(entL2_2);
        typesDef.getEntityDefs().add(entL2_3);
        typesDef.getEntityDefs().add(entL2_4);
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(typesDef);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNotNull((Object)failureMsg, (String)"expected invalid supertype failure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNestedUpdates() {
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        AtlasClassificationDef testTag1 = new AtlasClassificationDef("testTag1");
        AtlasClassificationDef testTag2 = new AtlasClassificationDef("testTag2");
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addType((AtlasBaseTypeDef)testTag1);
            Assert.assertFalse((boolean)typeRegistry.isRegisteredType(testTag1.getName()), (String)"type added should be seen in typeRegistry only after commit");
            boolean isNestedUpdateSuccess = this.addType(typeRegistry, (AtlasBaseTypeDef)testTag2);
            Assert.assertTrue((boolean)isNestedUpdateSuccess);
            Assert.assertFalse((boolean)typeRegistry.isRegisteredType(testTag2.getName()), (String)"type added within nested commit should be seen in typeRegistry only after outer commit");
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNull((Object)failureMsg);
        Assert.assertTrue((boolean)typeRegistry.isRegisteredType(testTag1.getName()));
        Assert.assertTrue((boolean)typeRegistry.isRegisteredType(testTag2.getName()));
    }

    @Test
    public void testParallelUpdates() {
        int numOfThreads = 3;
        int numOfTypesPerKind = 30;
        String enumTypePrefix = "testEnum-";
        String structTypePrefix = "testStruct-";
        String classificationPrefix = "testTag-";
        String entityTypePrefix = "testEntity-";
        ExecutorService executor = Executors.newFixedThreadPool(3);
        final AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        for (int threadIdx = 0; threadIdx < 3; ++threadIdx) {
            executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    int i;
                    for (i = 0; i < 30; ++i) {
                        TestAtlasTypeRegistry.this.addType(typeRegistry, (AtlasBaseTypeDef)new AtlasEnumDef("testEnum-" + i));
                    }
                    for (i = 0; i < 30; ++i) {
                        TestAtlasTypeRegistry.this.addType(typeRegistry, (AtlasBaseTypeDef)new AtlasStructDef("testStruct-" + i));
                    }
                    for (i = 0; i < 30; ++i) {
                        TestAtlasTypeRegistry.this.addType(typeRegistry, (AtlasBaseTypeDef)new AtlasClassificationDef("testTag-" + i));
                    }
                    for (i = 0; i < 30; ++i) {
                        TestAtlasTypeRegistry.this.addType(typeRegistry, (AtlasBaseTypeDef)new AtlasEntityDef("testEntity-" + i));
                    }
                    return null;
                }
            });
        }
        executor.shutdown();
        try {
            boolean isCompleted = executor.awaitTermination(60L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)isCompleted, (String)"threads did not complete updating types");
        }
        catch (InterruptedException isCompleted) {
            // empty catch block
        }
        for (int i = 0; i < 30; ++i) {
            String enumType = "testEnum-" + i;
            String structType = "testStruct-" + i;
            String classificationType = "testTag-" + i;
            String entityType = "testEntity-" + i;
            Assert.assertNotNull((Object)typeRegistry.getEnumDefByName(enumType), (String)(enumType + ": enum not found"));
            Assert.assertNotNull((Object)typeRegistry.getStructDefByName(structType), (String)(structType + ": struct not found"));
            Assert.assertNotNull((Object)typeRegistry.getClassificationDefByName(classificationType), (String)(classificationType + ": classification not found"));
            Assert.assertNotNull((Object)typeRegistry.getEntityDefByName(entityType), (String)(entityType + ": entity not found"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegistryValidityOnInvalidUpdate() {
        AtlasEntityDef entL0 = new AtlasEntityDef("L0");
        AtlasEntityDef entL1 = new AtlasEntityDef("L1");
        entL1.addSuperType(entL0.getName());
        entL0.addAttribute(new AtlasStructDef.AtlasAttributeDef("L0_a1", "int"));
        entL1.addAttribute(new AtlasStructDef.AtlasAttributeDef("L1_a1", "int"));
        AtlasTypesDef typesDef = new AtlasTypesDef();
        typesDef.getEntityDefs().add(entL0);
        typesDef.getEntityDefs().add(entL1);
        AtlasTypeRegistry typeRegistry = new AtlasTypeRegistry();
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        String failureMsg = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addTypes(typesDef);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNull((Object)failureMsg);
        this.validateSuperTypes(typeRegistry, "L0", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L0", new HashSet<String>(Arrays.asList("L1")));
        this.validateSuperTypes(typeRegistry, "L1", new HashSet<String>(Arrays.asList("L0")));
        this.validateSubTypes(typeRegistry, "L1", new HashSet<String>());
        AtlasEntityDef entL2 = new AtlasEntityDef("L2");
        entL2.addSuperType(entL0.getName());
        entL2.addSuperType(entL1.getName());
        entL2.addSuperType(entL2.getName());
        typesDef.clear();
        typesDef.getEntityDefs().add(entL2);
        try {
            commit = false;
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.updateTypes(typesDef);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            failureMsg = excp.getMessage();
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        Assert.assertNotNull((Object)failureMsg);
        Assert.assertNull((Object)typeRegistry.getEntityTypeByName("L2"));
        this.validateSuperTypes(typeRegistry, "L0", new HashSet<String>());
        this.validateSubTypes(typeRegistry, "L0", new HashSet<String>(Arrays.asList("L1")));
        this.validateSuperTypes(typeRegistry, "L1", new HashSet<String>(Arrays.asList("L0")));
        this.validateSubTypes(typeRegistry, "L1", new HashSet<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addType(AtlasTypeRegistry typeRegistry, AtlasBaseTypeDef typeDef) {
        boolean ret = false;
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        try {
            ttr = typeRegistry.lockTypeRegistryForUpdate();
            ttr.addType(typeDef);
            ret = true;
        }
        catch (AtlasBaseException atlasBaseException) {
        }
        finally {
            typeRegistry.releaseTypeRegistryForUpdate(ttr, ret);
        }
        return ret;
    }

    private void validateSuperTypes(AtlasTypeRegistry typeRegistry, String typeName, Set<String> expectedSuperTypes) {
        AtlasType type = null;
        try {
            type = typeRegistry.getType(typeName);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        Set superTypes = null;
        if (type != null) {
            if (type instanceof AtlasEntityType) {
                superTypes = ((AtlasEntityType)type).getAllSuperTypes();
            } else if (type instanceof AtlasClassificationType) {
                superTypes = ((AtlasClassificationType)type).getAllSuperTypes();
            }
        }
        Assert.assertEquals(superTypes, expectedSuperTypes);
    }

    private void validateSubTypes(AtlasTypeRegistry typeRegistry, String typeName, Set<String> expectedSubTypes) {
        AtlasType type = null;
        try {
            type = typeRegistry.getType(typeName);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        Set subTypes = null;
        if (type != null) {
            if (type instanceof AtlasEntityType) {
                subTypes = ((AtlasEntityType)type).getAllSubTypes();
            } else if (type instanceof AtlasClassificationType) {
                subTypes = ((AtlasClassificationType)type).getAllSubTypes();
            }
        }
        Assert.assertEquals(subTypes, expectedSubTypes);
    }

    private void validateAttributeNames(AtlasTypeRegistry typeRegistry, String typeName, Set<String> attributeNames) {
        AtlasType type = null;
        try {
            type = typeRegistry.getType(typeName);
        }
        catch (AtlasBaseException atlasBaseException) {
            // empty catch block
        }
        Map attributes = null;
        if (type != null) {
            if (type instanceof AtlasEntityType) {
                attributes = ((AtlasEntityType)type).getAllAttributes();
            } else if (type instanceof AtlasClassificationType) {
                attributes = ((AtlasClassificationType)type).getAllAttributes();
            }
        }
        Assert.assertNotNull(attributes);
        Assert.assertEquals(attributes.keySet(), attributeNames);
    }
}

