/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasDateType {
    private final AtlasBuiltInTypes.AtlasDateType dateType = new AtlasBuiltInTypes.AtlasDateType();
    private final Object[] validValues = new Object[]{null, "", (byte)1, (short)1, 1, 1L, Float.valueOf(1.0f), 1.0, BigInteger.valueOf(1L), BigDecimal.valueOf(1L), "1"};
    private final Object[] negativeValues = new Object[]{(byte)-1, (short)-1, -1, -1L, Float.valueOf(-1.0f), -1.0, BigInteger.valueOf(-1L), BigDecimal.valueOf(-1L), "-1"};
    private final Object[] invalidValues = new Object[]{"12ab", "abcd", "-12ab"};
    private final Date now = new Date();
    private final String strNow = AtlasBaseTypeDef.DATE_FORMATTER.format(this.now);

    @Test
    public void testDateTypeDefaultValue() {
        Date defValue = this.dateType.createDefaultValue();
        Assert.assertEquals((Object)defValue, (Object)new Date(0L));
    }

    @Test
    public void testDateTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.dateType.isValidValue(value), (String)("value=" + value));
        }
        Assert.assertTrue((boolean)this.dateType.isValidValue((Object)this.now), (String)("value=" + this.now));
        Assert.assertTrue((boolean)this.dateType.isValidValue((Object)this.strNow), (String)("value=" + this.strNow));
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.dateType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.dateType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testDateTypeGetNormalizedValue() {
        Date normalizedValue;
        Assert.assertNull((Object)this.dateType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null || value == "") continue;
            normalizedValue = this.dateType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)new Date(1L), (String)("value=" + value));
        }
        Assert.assertNotNull((Object)this.dateType.getNormalizedValue((Object)this.now), (String)("value=" + this.now));
        Assert.assertEquals((Object)this.dateType.getNormalizedValue((Object)this.now), (Object)this.now, (String)("value=" + this.now));
        Assert.assertNotNull((Object)this.dateType.getNormalizedValue((Object)this.strNow), (String)("value=" + this.strNow));
        Assert.assertEquals((Object)this.dateType.getNormalizedValue((Object)this.now), (Object)this.now, (String)("value=" + this.now));
        for (Object value : this.negativeValues) {
            normalizedValue = this.dateType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertEquals((Object)normalizedValue, (Object)new Date(-1L), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.dateType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testDateTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.dateType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        Assert.assertTrue((boolean)this.dateType.validateValue((Object)this.now, "testObj", messages));
        Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + this.now));
        Assert.assertTrue((boolean)this.dateType.validateValue((Object)this.strNow, "testObj", messages));
        Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + this.strNow));
        for (Object value : this.negativeValues) {
            Assert.assertTrue((boolean)this.dateType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.dateType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

