/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.ModelTestUtil;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.type.AtlasClassificationType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasClassificationType {
    private final AtlasClassificationType classificationType;
    private final List<Object> validValues = new ArrayList<Object>();
    private final List<Object> invalidValues = new ArrayList<Object>();

    public TestAtlasClassificationType() {
        this.classificationType = TestAtlasClassificationType.getClassificationType(ModelTestUtil.getClassificationDefWithSuperTypes());
        AtlasClassification invalidValue1 = this.classificationType.createDefaultValue();
        AtlasClassification invalidValue2 = this.classificationType.createDefaultValue();
        Map invalidValue3 = this.classificationType.createDefaultValue().getAttributes();
        invalidValue1.setAttribute(ModelTestUtil.getDefaultAttributeName("int"), (Object)"xyz");
        invalidValue2.setAttribute(ModelTestUtil.getDefaultAttributeName("date"), (Object)"xyz");
        invalidValue3.put(ModelTestUtil.getDefaultAttributeName("biginteger"), "xyz");
        this.validValues.add(null);
        this.validValues.add(this.classificationType.createDefaultValue());
        this.validValues.add(this.classificationType.createDefaultValue().getAttributes());
        this.invalidValues.add(invalidValue1);
        this.invalidValues.add(invalidValue2);
        this.invalidValues.add(invalidValue3);
        this.invalidValues.add(new AtlasClassification());
        this.invalidValues.add(new HashMap());
        this.invalidValues.add(1);
        this.invalidValues.add(new HashSet());
        this.invalidValues.add(new ArrayList());
        this.invalidValues.add(new String[0]);
    }

    @Test
    public void testClassificationTypeDefaultValue() {
        AtlasClassification defValue = this.classificationType.createDefaultValue();
        Assert.assertNotNull((Object)defValue);
        Assert.assertEquals((String)defValue.getTypeName(), (String)this.classificationType.getTypeName());
    }

    @Test
    public void testClassificationTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.classificationType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.classificationType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testClassificationTypeGetNormalizedValue() {
        Assert.assertNull((Object)this.classificationType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : this.validValues) {
            if (value == null) continue;
            Object normalizedValue = this.classificationType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertNull((Object)this.classificationType.getNormalizedValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testClassificationTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.classificationType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.classificationType.validateValue(value, "testObj", messages));
            Assert.assertTrue((messages.size() > 0 ? 1 : 0) != 0, (String)("value=" + value));
            messages.clear();
        }
    }

    private static AtlasClassificationType getClassificationType(AtlasClassificationDef classificationDef) {
        try {
            return new AtlasClassificationType(classificationDef, ModelTestUtil.getTypesRegistry());
        }
        catch (AtlasBaseException excp) {
            return null;
        }
    }
}

