/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.type;

import java.util.ArrayList;
import org.apache.atlas.type.AtlasBuiltInTypes;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAtlasBooleanType {
    private final AtlasBuiltInTypes.AtlasBooleanType booleanType = new AtlasBuiltInTypes.AtlasBooleanType();
    private final Object[] validValues = new Object[]{null, Boolean.TRUE, Boolean.FALSE, "true", "false", "TRUE", "FALSE"};
    private final Object[] invalidValues = new Object[0];

    @Test
    public void testBooleanTypeDefaultValue() {
        Boolean defValue = this.booleanType.createDefaultValue();
        Assert.assertFalse((boolean)defValue);
    }

    @Test
    public void testBooleanTypeIsValidValue() {
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.booleanType.isValidValue(value), (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.booleanType.isValidValue(value), (String)("value=" + value));
        }
    }

    @Test
    public void testBooleanTypeGetNormalizedValue() {
        Boolean normalizedValue;
        Object[] trueValues = new Object[]{Boolean.TRUE, "true", "TRUE", "tRuE", "TrUe"};
        Object[] falseValues = new Object[]{Boolean.FALSE, "false", "FALSE", "fAlSe", "FaLsE"};
        Assert.assertNull((Object)this.booleanType.getNormalizedValue(null), (String)("value=" + null));
        for (Object value : trueValues) {
            normalizedValue = this.booleanType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertTrue((boolean)normalizedValue, (String)("value=" + value));
        }
        for (Object value : falseValues) {
            normalizedValue = this.booleanType.getNormalizedValue(value);
            Assert.assertNotNull((Object)normalizedValue, (String)("value=" + value));
            Assert.assertFalse((boolean)normalizedValue, (String)("value=" + value));
        }
    }

    @Test
    public void testBooleanTypeValidateValue() {
        ArrayList messages = new ArrayList();
        for (Object value : this.validValues) {
            Assert.assertTrue((boolean)this.booleanType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)0, (String)("value=" + value));
        }
        for (Object value : this.invalidValues) {
            Assert.assertFalse((boolean)this.booleanType.validateValue(value, "testObj", messages));
            Assert.assertEquals((int)messages.size(), (int)1, (String)("value=" + value));
            messages.clear();
        }
    }
}

