/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.atlas.exception.AtlasBaseException;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.instance.AtlasEntity;
import org.apache.atlas.model.instance.AtlasStruct;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.atlas.model.typedef.AtlasClassificationDef;
import org.apache.atlas.model.typedef.AtlasEntityDef;
import org.apache.atlas.model.typedef.AtlasEnumDef;
import org.apache.atlas.model.typedef.AtlasStructDef;
import org.apache.atlas.type.AtlasClassificationType;
import org.apache.atlas.type.AtlasEntityType;
import org.apache.atlas.type.AtlasStructType;
import org.apache.atlas.type.AtlasTypeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelTestUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ModelTestUtil.class);
    private static final String PREFIX_ENUM_DEF = "testEnumDef-";
    private static final String PREFIX_STRUCT_DEF = "testStructDef-";
    private static final String PREFIX_ENTITY_DEF = "testEntityDef-";
    private static final String PREFIX_CLASSIFICATION_DEF = "testClassificationDef-";
    private static final String PREFIX_ATTRIBUTE_NAME = "attr-";
    private static final String PREFIX_STRUCT = "testStruct-";
    private static final String PREFIX_ENTITY = "testEntity-";
    private static final String PREFIX_CLASSIFICATION = "testClassification-";
    private static final int MAX_ENUM_ELEMENT_COUNT = 30;
    private static final AtomicInteger IDX_ENUM_DEF = new AtomicInteger();
    private static final AtomicInteger IDX_ENTITY_DEF = new AtomicInteger();
    private static final AtomicInteger IDX_CLASSIFICATION_DEF = new AtomicInteger();
    private static final AtomicInteger IDX_STRUCT_DEF = new AtomicInteger();
    private static final AtomicInteger IDX_CLASSIFICATION = new AtomicInteger();
    private static final AtomicInteger IDX_ENTITY = new AtomicInteger();
    private static final AtomicInteger IDX_STRUCT = new AtomicInteger();
    private static final AtlasTypeRegistry TYPE_REGISTRY = new AtlasTypeRegistry();
    private static final AtlasEnumDef ENUM_DEF = ModelTestUtil.newEnumDef(true);
    private static final AtlasEnumDef ENUM_DEF_WITH_NO_DEFAULT = ModelTestUtil.newEnumDef(false);
    private static final AtlasStructDef STRUCT_DEF = ModelTestUtil.newStructDef();
    private static final AtlasEntityDef ENTITY_DEF = ModelTestUtil.newEntityDef();
    private static final AtlasEntityDef ENTITY_DEF_WITH_SUPER_TYPE = ModelTestUtil.newEntityDef(new AtlasEntityDef[]{ENTITY_DEF});
    private static final AtlasEntityDef ENTITY_DEF_WITH_SUPER_TYPES = ModelTestUtil.newEntityDef(new AtlasEntityDef[]{ENTITY_DEF, ENTITY_DEF_WITH_SUPER_TYPE});
    private static final AtlasClassificationDef CLASSIFICATION_DEF = ModelTestUtil.newClassificationDef();
    private static final AtlasClassificationDef CLASSIFICATION_DEF_WITH_SUPER_TYPE = ModelTestUtil.newClassificationDef(new AtlasClassificationDef[]{CLASSIFICATION_DEF});
    private static final AtlasClassificationDef CLASSIFICATION_DEF_WITH_SUPER_TYPES = ModelTestUtil.newClassificationDef(new AtlasClassificationDef[]{CLASSIFICATION_DEF, CLASSIFICATION_DEF_WITH_SUPER_TYPE});

    private ModelTestUtil() {
    }

    public static AtlasTypeRegistry getTypesRegistry() {
        return TYPE_REGISTRY;
    }

    public static AtlasEnumDef getEnumDef() {
        return ENUM_DEF;
    }

    public static AtlasEnumDef getEnumDefWithNoDefault() {
        return ENUM_DEF_WITH_NO_DEFAULT;
    }

    public static AtlasStructDef getStructDef() {
        return STRUCT_DEF;
    }

    public static AtlasEntityDef getEntityDef() {
        return ENTITY_DEF;
    }

    public static AtlasEntityDef getEntityDefWithSuperType() {
        return ENTITY_DEF_WITH_SUPER_TYPE;
    }

    public static AtlasEntityDef getEntityDefWithSuperTypes() {
        return ENTITY_DEF_WITH_SUPER_TYPES;
    }

    public static AtlasClassificationDef getClassificationDef() {
        return CLASSIFICATION_DEF;
    }

    public static AtlasClassificationDef getClassificationDefWithSuperType() {
        return CLASSIFICATION_DEF_WITH_SUPER_TYPE;
    }

    public static AtlasClassificationDef getClassificationDefWithSuperTypes() {
        return CLASSIFICATION_DEF_WITH_SUPER_TYPES;
    }

    public static AtlasEnumDef newEnumDef() {
        return ModelTestUtil.newEnumDef(ModelTestUtil.getTypesRegistry(), true);
    }

    public static AtlasEnumDef newEnumDef(boolean hasDefaultValue) {
        return ModelTestUtil.newEnumDef(ModelTestUtil.getTypesRegistry(), hasDefaultValue);
    }

    public static AtlasEnumDef newEnumDef(AtlasTypeRegistry typesRegistry) {
        return ModelTestUtil.newEnumDef(ModelTestUtil.getTypesRegistry(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlasEnumDef newEnumDef(AtlasTypeRegistry typesRegistry, boolean hasDefaultValue) {
        int enumDefIdx = IDX_ENUM_DEF.getAndIncrement();
        AtlasEnumDef ret = new AtlasEnumDef();
        ret.setName(PREFIX_ENUM_DEF + enumDefIdx);
        ret.setDescription(ret.getName());
        int numElements = ThreadLocalRandom.current().nextInt(1, 30);
        for (int i = 0; i < numElements; ++i) {
            String elementName = "element-" + i;
            ret.addElement(new AtlasEnumDef.AtlasEnumElementDef(elementName, elementName.toUpperCase(), Integer.valueOf(i)));
        }
        if (hasDefaultValue) {
            int idxDefault = ThreadLocalRandom.current().nextInt(0, numElements);
            ret.setDefaultValue(((AtlasEnumDef.AtlasEnumElementDef)ret.getElementDefs().get(idxDefault)).getValue());
        }
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        try {
            ttr = typesRegistry.lockTypeRegistryForUpdate();
            ttr.addType((AtlasBaseTypeDef)ret);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            LOG.error("failed to create enum-def", (Throwable)excp);
            ret = null;
        }
        finally {
            typesRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        return ret;
    }

    public static AtlasStructDef newStructDef() {
        return ModelTestUtil.newStructDef(ModelTestUtil.getTypesRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlasStructDef newStructDef(AtlasTypeRegistry typesRegistry) {
        int structDefIdx = IDX_STRUCT_DEF.getAndIncrement();
        AtlasStructDef ret = new AtlasStructDef();
        ret.setName(PREFIX_STRUCT_DEF + structDefIdx);
        ret.setDescription(ret.getName());
        ret.setAttributeDefs(ModelTestUtil.newAttributeDefsWithAllBuiltInTypes(PREFIX_ATTRIBUTE_NAME));
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        try {
            ttr = typesRegistry.lockTypeRegistryForUpdate();
            ttr.addType((AtlasBaseTypeDef)ret);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            LOG.error("failed to create struct-def", (Throwable)excp);
            ret = null;
        }
        finally {
            typesRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        return ret;
    }

    public static AtlasEntityDef newEntityDef() {
        return ModelTestUtil.newEntityDef(ModelTestUtil.getTypesRegistry(), null);
    }

    public static AtlasEntityDef newEntityDef(AtlasEntityDef[] superTypes) {
        return ModelTestUtil.newEntityDef(ModelTestUtil.getTypesRegistry(), superTypes);
    }

    public static AtlasEntityDef newEntityDef(AtlasTypeRegistry typesRegistry) {
        return ModelTestUtil.newEntityDef(ModelTestUtil.getTypesRegistry(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlasEntityDef newEntityDef(AtlasTypeRegistry typesRegistry, AtlasEntityDef[] superTypes) {
        int entDefIdx = IDX_ENTITY_DEF.getAndIncrement();
        AtlasEntityDef ret = new AtlasEntityDef();
        ret.setName(PREFIX_ENTITY_DEF + entDefIdx);
        ret.setDescription(ret.getName());
        ret.setAttributeDefs(ModelTestUtil.newAttributeDefsWithAllBuiltInTypes(PREFIX_ATTRIBUTE_NAME));
        if (superTypes != null) {
            for (AtlasEntityDef superType : superTypes) {
                ret.addSuperType(superType.getName());
            }
        }
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        try {
            ttr = typesRegistry.lockTypeRegistryForUpdate();
            ttr.addType((AtlasBaseTypeDef)ret);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            LOG.error("failed to create entity-def", (Throwable)excp);
            ret = null;
        }
        finally {
            typesRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        return ret;
    }

    public static AtlasEntityDef newEntityDefWithSuperTypes() {
        return ModelTestUtil.newEntityDefWithSuperTypes(ModelTestUtil.getTypesRegistry());
    }

    public static AtlasEntityDef newEntityDefWithSuperTypes(AtlasTypeRegistry typesRegistry) {
        return ModelTestUtil.newEntityDef(typesRegistry, new AtlasEntityDef[]{ENTITY_DEF, ENTITY_DEF_WITH_SUPER_TYPE});
    }

    public static AtlasClassificationDef newClassificationDef() {
        return ModelTestUtil.newClassificationDef(ModelTestUtil.getTypesRegistry(), null);
    }

    public static AtlasClassificationDef newClassificationDef(AtlasClassificationDef[] superTypes) {
        return ModelTestUtil.newClassificationDef(ModelTestUtil.getTypesRegistry(), superTypes);
    }

    public static AtlasClassificationDef newClassificationDef(AtlasTypeRegistry typesRegistry) {
        return ModelTestUtil.newClassificationDef(typesRegistry, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtlasClassificationDef newClassificationDef(AtlasTypeRegistry typesRegistry, AtlasClassificationDef[] superTypes) {
        int classificationDefIdx = IDX_CLASSIFICATION_DEF.getAndIncrement();
        AtlasClassificationDef ret = new AtlasClassificationDef();
        ret.setName(PREFIX_CLASSIFICATION_DEF + classificationDefIdx);
        ret.setDescription(ret.getName());
        ret.setAttributeDefs(ModelTestUtil.newAttributeDefsWithAllBuiltInTypes(PREFIX_ATTRIBUTE_NAME));
        if (superTypes != null) {
            for (AtlasClassificationDef superType : superTypes) {
                ret.addSuperType(superType.getName());
            }
        }
        AtlasTypeRegistry.AtlasTransientTypeRegistry ttr = null;
        boolean commit = false;
        try {
            ttr = typesRegistry.lockTypeRegistryForUpdate();
            ttr.addType((AtlasBaseTypeDef)ret);
            commit = true;
        }
        catch (AtlasBaseException excp) {
            LOG.error("failed to create classification-def", (Throwable)excp);
            ret = null;
        }
        finally {
            typesRegistry.releaseTypeRegistryForUpdate(ttr, commit);
        }
        return ret;
    }

    public static AtlasEntity newEntity(AtlasEntityDef entityDef) {
        return ModelTestUtil.newEntity(entityDef, ModelTestUtil.getTypesRegistry());
    }

    public static AtlasEntity newEntity(AtlasEntityDef entityDef, AtlasTypeRegistry typesRegistry) {
        AtlasEntity ret = null;
        AtlasEntityType entityType = typesRegistry.getEntityTypeByName(entityDef.getName());
        if (entityType != null) {
            ret = entityType.createDefaultValue();
        } else {
            LOG.error("failed to get entity-type {}", (Object)entityDef.getName());
        }
        return ret;
    }

    public static AtlasStruct newStruct(AtlasStructDef structDef) {
        return ModelTestUtil.newStruct(structDef, ModelTestUtil.getTypesRegistry());
    }

    public static AtlasStruct newStruct(AtlasStructDef structDef, AtlasTypeRegistry typesRegistry) {
        AtlasStruct ret = null;
        AtlasStructType structType = typesRegistry.getStructTypeByName(structDef.getName());
        if (structType != null) {
            ret = structType.createDefaultValue();
        } else {
            LOG.error("failed to get struct-type {}", (Object)structDef.getName());
        }
        return ret;
    }

    public static AtlasClassification newClassification(AtlasClassificationDef classificationDef) {
        return ModelTestUtil.newClassification(classificationDef, ModelTestUtil.getTypesRegistry());
    }

    public static AtlasClassification newClassification(AtlasClassificationDef classificationDef, AtlasTypeRegistry typesRegistry) {
        AtlasClassification ret = null;
        AtlasClassificationType classificationType = typesRegistry.getClassificationTypeByName(classificationDef.getName());
        if (classificationType != null) {
            ret = classificationType.createDefaultValue();
        } else {
            LOG.error("failed to get classification-type {}", (Object)classificationDef.getName());
        }
        return ret;
    }

    public static List<AtlasStructDef.AtlasAttributeDef> newAttributeDefsWithAllBuiltInTypes(String attrNamePrefix) {
        ArrayList<AtlasStructDef.AtlasAttributeDef> ret = new ArrayList<AtlasStructDef.AtlasAttributeDef>();
        for (String ATLAS_BUILTIN_TYPE2 : AtlasBaseTypeDef.ATLAS_BUILTIN_TYPES) {
            ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, ATLAS_BUILTIN_TYPE2));
        }
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, ENUM_DEF.getName()));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, ENUM_DEF_WITH_NO_DEFAULT.getName()));
        for (String ATLAS_BUILTIN_TYPE1 : AtlasBaseTypeDef.ATLAS_BUILTIN_TYPES) {
            ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)ATLAS_BUILTIN_TYPE1)));
        }
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)ENUM_DEF.getName())));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)ENUM_DEF_WITH_NO_DEFAULT.getName())));
        for (String ATLAS_PRIMITIVE_TYPE3 : AtlasBaseTypeDef.ATLAS_PRIMITIVE_TYPES) {
            ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getMapTypeName((String)ATLAS_PRIMITIVE_TYPE3, (String)ModelTestUtil.getRandomBuiltInType())));
        }
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getMapTypeName((String)ENUM_DEF.getName(), (String)ModelTestUtil.getRandomBuiltInType())));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getMapTypeName((String)ENUM_DEF_WITH_NO_DEFAULT.getName(), (String)ModelTestUtil.getRandomBuiltInType())));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getMapTypeName((String)ModelTestUtil.getRandomPrimitiveType(), (String)ENUM_DEF.getName())));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getMapTypeName((String)ModelTestUtil.getRandomPrimitiveType(), (String)ENUM_DEF_WITH_NO_DEFAULT.getName())));
        for (String ATLAS_BUILTIN_TYPE : AtlasBaseTypeDef.ATLAS_BUILTIN_TYPES) {
            ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)AtlasBaseTypeDef.getArrayTypeName((String)ModelTestUtil.getRandomBuiltInType()))));
        }
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)ENUM_DEF.getName())));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)ENUM_DEF_WITH_NO_DEFAULT.getName())));
        for (String ATLAS_PRIMITIVE_TYPE2 : AtlasBaseTypeDef.ATLAS_PRIMITIVE_TYPES) {
            ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)AtlasBaseTypeDef.getMapTypeName((String)ATLAS_PRIMITIVE_TYPE2, (String)ModelTestUtil.getRandomBuiltInType()))));
        }
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)AtlasBaseTypeDef.getMapTypeName((String)ENUM_DEF.getName(), (String)ModelTestUtil.getRandomBuiltInType()))));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)AtlasBaseTypeDef.getMapTypeName((String)ENUM_DEF_WITH_NO_DEFAULT.getName(), (String)ModelTestUtil.getRandomBuiltInType()))));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)AtlasBaseTypeDef.getMapTypeName((String)ModelTestUtil.getRandomPrimitiveType(), (String)ENUM_DEF.getName()))));
        ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getArrayTypeName((String)AtlasBaseTypeDef.getMapTypeName((String)ModelTestUtil.getRandomPrimitiveType(), (String)ENUM_DEF_WITH_NO_DEFAULT.getName()))));
        for (String ATLAS_PRIMITIVE_TYPE1 : AtlasBaseTypeDef.ATLAS_PRIMITIVE_TYPES) {
            ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getMapTypeName((String)ATLAS_PRIMITIVE_TYPE1, (String)AtlasBaseTypeDef.getArrayTypeName((String)ModelTestUtil.getRandomBuiltInType()))));
        }
        for (String ATLAS_PRIMITIVE_TYPE : AtlasBaseTypeDef.ATLAS_PRIMITIVE_TYPES) {
            ret.add(ModelTestUtil.getAttributeDef(attrNamePrefix, AtlasBaseTypeDef.getMapTypeName((String)ATLAS_PRIMITIVE_TYPE, (String)AtlasBaseTypeDef.getMapTypeName((String)ATLAS_PRIMITIVE_TYPE, (String)ModelTestUtil.getRandomBuiltInType()))));
        }
        return ret;
    }

    public static String getDefaultAttributeName(String attrType) {
        return PREFIX_ATTRIBUTE_NAME + attrType;
    }

    private static AtlasStructDef.AtlasAttributeDef getAttributeDef(String attrNamePrefix, String attrType) {
        return new AtlasStructDef.AtlasAttributeDef(attrNamePrefix + attrType, attrType);
    }

    private static String getRandomPrimitiveType() {
        return AtlasBaseTypeDef.ATLAS_PRIMITIVE_TYPES[ThreadLocalRandom.current().nextInt(0, AtlasBaseTypeDef.ATLAS_PRIMITIVE_TYPES.length)];
    }

    private static String getRandomBuiltInType() {
        return AtlasBaseTypeDef.ATLAS_BUILTIN_TYPES[ThreadLocalRandom.current().nextInt(0, AtlasBaseTypeDef.ATLAS_BUILTIN_TYPES.length)];
    }
}

