/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.titan.query.expr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.atlas.repository.graphdb.titan.query.expr.AndCondition;
import org.apache.atlas.repository.graphdb.titan.query.expr.QueryPredicate;

public class OrCondition {
    private List<AndCondition> children;

    public OrCondition() {
        this(true);
    }

    private OrCondition(List<AndCondition> children) {
        this.children = children;
    }

    public OrCondition(boolean addInitialTerm) {
        this.children = new ArrayList<AndCondition>();
        if (addInitialTerm) {
            this.children.add(new AndCondition());
        }
    }

    public void andWith(QueryPredicate predicate) {
        for (AndCondition child : this.children) {
            child.andWith(predicate);
        }
    }

    public List<AndCondition> getAndTerms() {
        return this.children;
    }

    public void andWith(OrCondition other) {
        ArrayList<AndCondition> expandedExpressionChildren = new ArrayList<AndCondition>();
        for (AndCondition otherExprTerm : other.getAndTerms()) {
            for (AndCondition currentExpr : this.children) {
                AndCondition currentAndConditionCopy = currentExpr.copy();
                currentAndConditionCopy.andWith(otherExprTerm.getTerms());
                expandedExpressionChildren.add(currentAndConditionCopy);
            }
        }
        this.children = expandedExpressionChildren;
    }

    public void orWith(OrCondition other) {
        this.children.addAll(other.getAndTerms());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OrCondition [andExprs=");
        Iterator<AndCondition> it = this.children.iterator();
        while (it.hasNext()) {
            AndCondition andExpr = it.next();
            builder.append(andExpr.toString());
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        builder.append("]");
        return builder.toString();
    }
}

