/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.titan.query;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.atlas.repository.graphdb.AtlasEdge;
import org.apache.atlas.repository.graphdb.AtlasGraph;
import org.apache.atlas.repository.graphdb.AtlasGraphQuery;
import org.apache.atlas.repository.graphdb.AtlasVertex;
import org.apache.atlas.repository.graphdb.titan.query.NativeTitanGraphQuery;
import org.apache.atlas.repository.graphdb.titan.query.NativeTitanQueryFactory;
import org.apache.atlas.repository.graphdb.titan.query.expr.AndCondition;
import org.apache.atlas.repository.graphdb.titan.query.expr.HasPredicate;
import org.apache.atlas.repository.graphdb.titan.query.expr.InPredicate;
import org.apache.atlas.repository.graphdb.titan.query.expr.OrCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanGraphQuery<V, E>
implements AtlasGraphQuery<V, E> {
    private static final Logger LOG = LoggerFactory.getLogger(TitanGraphQuery.class);
    protected final AtlasGraph<V, E> graph;
    private final OrCondition queryCondition = new OrCondition();
    private final boolean isChildQuery;

    protected abstract NativeTitanQueryFactory<V, E> getQueryFactory();

    public TitanGraphQuery(AtlasGraph<V, E> graph) {
        this.graph = graph;
        this.isChildQuery = false;
    }

    public TitanGraphQuery(AtlasGraph<V, E> graph, boolean isChildQuery) {
        this.graph = graph;
        this.isChildQuery = isChildQuery;
    }

    public AtlasGraphQuery<V, E> has(String propertyKey, Object value) {
        this.queryCondition.andWith(new HasPredicate(propertyKey, (AtlasGraphQuery.QueryOperator)AtlasGraphQuery.ComparisionOperator.EQUAL, value));
        return this;
    }

    public Iterable<AtlasVertex<V, E>> vertices() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing: " + this.queryCondition);
        }
        HashSet<AtlasVertex<V, AtlasVertex<V, E>>> result = new HashSet<AtlasVertex<V, AtlasVertex<V, E>>>();
        for (AndCondition andExpr : this.queryCondition.getAndTerms()) {
            NativeTitanGraphQuery<V, E> andQuery = andExpr.create(this.getQueryFactory());
            for (AtlasVertex<V, E> vertex : andQuery.vertices()) {
                result.add(vertex);
            }
        }
        return result;
    }

    public Iterable<AtlasEdge<V, E>> edges() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing: " + this.queryCondition);
        }
        HashSet<AtlasEdge<V, AtlasEdge<V, E>>> result = new HashSet<AtlasEdge<V, AtlasEdge<V, E>>>();
        for (AndCondition andExpr : this.queryCondition.getAndTerms()) {
            NativeTitanGraphQuery<V, E> andQuery = andExpr.create(this.getQueryFactory());
            for (AtlasEdge<V, E> edge : andQuery.edges()) {
                result.add(edge);
            }
        }
        return result;
    }

    public Iterable<AtlasVertex<V, E>> vertices(int limit) {
        return this.vertices(0, limit);
    }

    public Iterable<AtlasVertex<V, E>> vertices(int offset, int limit) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing: " + this.queryCondition);
        }
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset must be non-negative");
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Limit must be non-negative");
        HashSet<AtlasVertex<V, AtlasVertex<V, E>>> result = new HashSet<AtlasVertex<V, AtlasVertex<V, E>>>();
        long resultIdx = 0L;
        block0: for (AndCondition andExpr : this.queryCondition.getAndTerms()) {
            if (result.size() == limit) break;
            NativeTitanGraphQuery<V, E> andQuery = andExpr.create(this.getQueryFactory());
            for (AtlasVertex<V, E> vertex : andQuery.vertices(offset + limit)) {
                if (resultIdx >= (long)offset) {
                    result.add(vertex);
                    if (result.size() == limit) continue block0;
                }
                ++resultIdx;
            }
        }
        return result;
    }

    public AtlasGraphQuery<V, E> has(String propertyKey, AtlasGraphQuery.QueryOperator operator, Object value) {
        this.queryCondition.andWith(new HasPredicate(propertyKey, operator, value));
        return this;
    }

    public AtlasGraphQuery<V, E> in(String propertyKey, Collection<?> values) {
        this.queryCondition.andWith(new InPredicate(propertyKey, values));
        return this;
    }

    public AtlasGraphQuery<V, E> or(List<AtlasGraphQuery<V, E>> childQueries) {
        OrCondition overallChildQuery = new OrCondition(false);
        for (AtlasGraphQuery<V, E> atlasChildQuery : childQueries) {
            if (!atlasChildQuery.isChildQuery()) {
                throw new IllegalArgumentException(atlasChildQuery + " is not a child query");
            }
            TitanGraphQuery childQuery = (TitanGraphQuery)atlasChildQuery;
            overallChildQuery.orWith(childQuery.getOrCondition());
        }
        this.queryCondition.andWith(overallChildQuery);
        return this;
    }

    private OrCondition getOrCondition() {
        return this.queryCondition;
    }

    public AtlasGraphQuery<V, E> addConditionsFrom(AtlasGraphQuery<V, E> otherQuery) {
        TitanGraphQuery childQuery = (TitanGraphQuery)otherQuery;
        this.queryCondition.andWith(childQuery.getOrCondition());
        return this;
    }

    public boolean isChildQuery() {
        return this.isChildQuery;
    }
}

