/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.graph;

import java.io.File;
import java.util.UUID;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasException;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphSandboxUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GraphSandboxUtil.class);

    public static void create(String sandboxName) {
        try {
            Configuration configuration = ApplicationProperties.get();
            String newStorageDir = System.getProperty("atlas.data") + File.separatorChar + "storage" + File.separatorChar + sandboxName;
            configuration.setProperty("atlas.graph.storage.directory", (Object)newStorageDir);
            String newIndexerDir = System.getProperty("atlas.data") + File.separatorChar + "index" + File.separatorChar + sandboxName;
            configuration.setProperty("atlas.graph.index.search.directory", (Object)newIndexerDir);
            LOG.debug("New Storage dir : {}", (Object)newStorageDir);
            LOG.debug("New Indexer dir : {}", (Object)newIndexerDir);
        }
        catch (AtlasException atlasException) {
            // empty catch block
        }
    }

    public static void create() {
        UUID uuid = UUID.randomUUID();
        GraphSandboxUtil.create(uuid.toString());
    }
}

