/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.repository.graphdb.titan.query.expr;

import java.util.ArrayList;
import java.util.List;
import org.apache.atlas.repository.graphdb.titan.query.NativeTitanGraphQuery;
import org.apache.atlas.repository.graphdb.titan.query.NativeTitanQueryFactory;
import org.apache.atlas.repository.graphdb.titan.query.expr.QueryPredicate;

public class AndCondition {
    private List<QueryPredicate> children = new ArrayList<QueryPredicate>();

    public void andWith(QueryPredicate predicate) {
        this.children.add(predicate);
    }

    public void andWith(List<QueryPredicate> predicates) {
        this.children.addAll(predicates);
    }

    public AndCondition copy() {
        AndCondition builder = new AndCondition();
        builder.children.addAll(this.children);
        return builder;
    }

    public List<QueryPredicate> getTerms() {
        return this.children;
    }

    public <V, E> NativeTitanGraphQuery<V, E> create(NativeTitanQueryFactory<V, E> factory) {
        NativeTitanGraphQuery<V, E> query = factory.createNativeTitanQuery();
        for (QueryPredicate predicate : this.children) {
            predicate.addTo(query);
        }
        return query;
    }

    public String toString() {
        return "AndExpr [predicates=" + this.children + "]";
    }
}

