/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.transactions.ILogBuffer;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ILogReader;
import org.apache.asterix.common.transactions.ILogRecord;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.LogManagerProperties;
import org.apache.asterix.common.transactions.MutableLong;
import org.apache.asterix.common.transactions.TxnLogFile;
import org.apache.asterix.transaction.management.service.logging.LogBuffer;
import org.apache.asterix.transaction.management.service.logging.LogFlusher;
import org.apache.asterix.transaction.management.service.logging.LogReader;
import org.apache.hyracks.api.lifecycle.ILifeCycleComponent;
import org.apache.hyracks.api.util.InvokeUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LogManager
implements ILogManager,
ILifeCycleComponent {
    private static final Logger LOGGER = org.apache.logging.log4j.LogManager.getLogger();
    private static final long SMALLEST_LOG_FILE_ID = 0L;
    private static final int INITIAL_LOG_SIZE = 0;
    private static final boolean IS_DEBUG_MODE = false;
    private final ITransactionSubsystem txnSubsystem;
    private final LogManagerProperties logManagerProperties;
    private final int numLogPages;
    private final String logDir;
    private final String logFilePrefix;
    private final MutableLong flushLSN;
    private final String nodeId;
    private final long logFileSize;
    private final int logPageSize;
    private final AtomicLong appendLSN;
    private final long maxLogRecordSize;
    private LinkedBlockingQueue<ILogBuffer> emptyQ;
    private LinkedBlockingQueue<ILogBuffer> flushQ;
    private LinkedBlockingQueue<ILogBuffer> stashQ;
    private FileChannel appendChannel;
    private ILogBuffer appendPage;
    private LogFlusher logFlusher;
    private Future<? extends Object> futureLogFlusher;
    protected LinkedBlockingQueue<ILogRecord> flushLogsQ;
    private long currentLogFileId;

    public LogManager(ITransactionSubsystem txnSubsystem) {
        this.txnSubsystem = txnSubsystem;
        this.logManagerProperties = new LogManagerProperties(this.txnSubsystem.getTransactionProperties(), this.txnSubsystem.getId());
        this.logFileSize = this.logManagerProperties.getLogPartitionSize();
        this.maxLogRecordSize = this.logFileSize - 1L;
        this.logPageSize = this.logManagerProperties.getLogPageSize();
        this.numLogPages = this.logManagerProperties.getNumLogPages();
        this.logDir = this.logManagerProperties.getLogDir();
        this.logFilePrefix = this.logManagerProperties.getLogFilePrefix();
        this.flushLSN = new MutableLong();
        this.appendLSN = new AtomicLong();
        this.nodeId = txnSubsystem.getId();
        this.flushLogsQ = new LinkedBlockingQueue();
        txnSubsystem.getApplicationContext().getThreadExecutor().execute(new FlushLogsLogger());
        long onDiskMaxLogFileId = this.getOnDiskMaxLogFileId();
        this.initializeLogManager(onDiskMaxLogFileId);
    }

    private void initializeLogManager(long nextLogFileId) {
        this.emptyQ = new LinkedBlockingQueue(this.numLogPages);
        this.flushQ = new LinkedBlockingQueue(this.numLogPages);
        this.stashQ = new LinkedBlockingQueue(this.numLogPages);
        for (int i = 0; i < this.numLogPages; ++i) {
            this.emptyQ.add(new LogBuffer(this.txnSubsystem, this.logPageSize, this.flushLSN));
        }
        this.appendLSN.set(this.initializeLogAnchor(nextLogFileId));
        this.flushLSN.set(this.appendLSN.get());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("LogManager starts logging in LSN: " + this.appendLSN);
        }
        try {
            this.setLogPosition(this.appendLSN.get());
        }
        catch (IOException e) {
            throw new ACIDException((Throwable)e);
        }
        this.initNewPage(0);
        this.logFlusher = new LogFlusher(this, this.emptyQ, this.flushQ, this.stashQ);
        this.futureLogFlusher = ((ExecutorService)this.txnSubsystem.getApplicationContext().getThreadExecutor()).submit(this.logFlusher);
    }

    public void log(ILogRecord logRecord) {
        if (!this.logToFlushQueue(logRecord)) {
            this.appendToLogTail(logRecord);
        }
    }

    protected boolean logToFlushQueue(ILogRecord logRecord) {
        if (logRecord.getLogType() == 4 && logRecord.getLogSource() == 0 || logRecord.getLogType() == 9) {
            logRecord.isFlushed(false);
            this.flushLogsQ.add(logRecord);
            if (logRecord.getLogType() == 9) {
                InvokeUtil.doUninterruptibly(() -> {
                    ILogRecord iLogRecord = logRecord;
                    synchronized (iLogRecord) {
                        while (!logRecord.isFlushed()) {
                            logRecord.wait();
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    protected void appendToLogTail(ILogRecord logRecord) {
        this.syncAppendToLogTail(logRecord);
        if (LogManager.waitForFlush(logRecord) && !logRecord.isFlushed()) {
            InvokeUtil.doUninterruptibly(() -> {
                ILogRecord iLogRecord = logRecord;
                synchronized (iLogRecord) {
                    while (!logRecord.isFlushed()) {
                        logRecord.wait();
                    }
                }
            });
        }
    }

    protected static boolean waitForFlush(ILogRecord logRecord) {
        byte logType = logRecord.getLogType();
        return logType == 1 || logType == 3 || logType == 6;
    }

    synchronized void syncAppendToLogTail(ILogRecord logRecord) {
        ITransactionContext txnCtx;
        if (logRecord.getLogSource() == 0 && logRecord.getLogType() != 4 && logRecord.getLogType() != 6 && logRecord.getLogType() != 9 && (txnCtx = logRecord.getTxnCtx()).getTxnState() == 2 && logRecord.getLogType() != 3) {
            throw new ACIDException("Aborted txn(" + txnCtx.getTxnId() + ") tried to write non-abort type log record.");
        }
        int logSize = logRecord.getLogSize();
        this.ensureSpace(logSize);
        this.appendPage.append(logRecord, this.appendLSN.get());
        if (logRecord.getLogType() == 4) {
            logRecord.setLSN(this.appendLSN.get());
        }
        if (logRecord.isMarker()) {
            logRecord.logAppended(this.appendLSN.get());
        }
        this.appendLSN.addAndGet(logSize);
    }

    private void ensureSpace(int logSize) {
        if (!this.fileHasSpace(logSize)) {
            this.ensureLastPageFlushed();
            this.prepareNextLogFile();
        }
        if (!this.appendPage.hasSpace(logSize)) {
            this.prepareNextPage(logSize);
        }
    }

    private boolean fileHasSpace(int logSize) {
        if ((long)logSize > this.maxLogRecordSize) {
            throw new ACIDException("Maximum log record size of (" + this.maxLogRecordSize + ") exceeded");
        }
        return this.getLogFileOffset(this.appendLSN.get()) + (long)logSize < this.logFileSize;
    }

    private void prepareNextPage(int logSize) {
        this.appendPage.setFull();
        this.initNewPage(logSize);
    }

    private void initNewPage(int logSize) {
        boolean largePage = logSize > this.logPageSize;
        this.ensureAvailablePage(largePage);
        if (largePage) {
            this.appendPage = new LogBuffer(this.txnSubsystem, logSize, this.flushLSN);
        } else {
            this.appendPage.reset();
        }
        this.appendPage.setFileChannel(this.appendChannel);
        this.flushQ.add(this.appendPage);
    }

    private void ensureAvailablePage(boolean stash) {
        ILogBuffer currentPage = this.appendPage;
        this.appendPage = null;
        try {
            this.appendPage = this.emptyQ.take();
            if (stash) {
                this.stashQ.add(this.appendPage);
            }
        }
        catch (InterruptedException e) {
            this.appendPage = currentPage;
            Thread.currentThread().interrupt();
            throw new ACIDException((Throwable)e);
        }
    }

    private void prepareNextLogFile() {
        long nextFileBeginLsn = this.getNextFileFirstLsn();
        try {
            this.closeCurrentLogFile();
            this.createNextLogFile();
            InvokeUtil.doIoUninterruptibly(() -> this.setLogPosition(nextFileBeginLsn));
            this.appendLSN.set(nextFileBeginLsn);
            this.flushLSN.set(nextFileBeginLsn);
            LOGGER.info("Created new txn log file with id({}) starting with LSN = {}", (Object)this.currentLogFileId, (Object)nextFileBeginLsn);
        }
        catch (IOException e) {
            throw new ACIDException((Throwable)e);
        }
    }

    private long getNextFileFirstLsn() {
        return this.appendLSN.get() + (this.logFileSize - this.getLogFileOffset(this.appendLSN.get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLastPageFlushed() {
        this.appendPage.setFull();
        MutableLong mutableLong = this.flushLSN;
        synchronized (mutableLong) {
            while (this.flushLSN.get() != this.appendLSN.get()) {
                try {
                    this.flushLSN.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ACIDException((Throwable)e);
                }
            }
        }
    }

    public ILogReader getLogReader(boolean isRecoveryMode) {
        return new LogReader(this, this.logFileSize, this.logPageSize, this.flushLSN, isRecoveryMode);
    }

    public LogManagerProperties getLogManagerProperties() {
        return this.logManagerProperties;
    }

    public ITransactionSubsystem getTransactionSubsystem() {
        return this.txnSubsystem;
    }

    public long getAppendLSN() {
        return this.appendLSN.get();
    }

    public void start() {
    }

    public void stop(boolean dumpState, OutputStream os) {
        this.terminateLogFlusher();
        this.closeCurrentLogFile();
        if (dumpState) {
            this.dumpState(os);
        }
    }

    public void dumpState(OutputStream os) {
        this.dumpConfVars(os);
        this.dumpLSNInfo(os);
    }

    private void dumpConfVars(OutputStream os) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n>>dump_begin\t>>----- [ConfVars] -----");
            sb.append(this.logManagerProperties.toString());
            sb.append("\n>>dump_end\t>>----- [ConfVars] -----\n");
            os.write(sb.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dumpLSNInfo(OutputStream os) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("\n>>dump_begin\t>>----- [LSNInfo] -----");
            sb.append("\nappendLsn: " + this.appendLSN);
            sb.append("\nflushLsn: " + this.flushLSN.get());
            sb.append("\n>>dump_end\t>>----- [LSNInfo] -----\n");
            os.write(sb.toString().getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private long initializeLogAnchor(long fileId) {
        String logFilePath = this.getLogFilePath(fileId);
        LogManager.createFileIfNotExists(logFilePath);
        File logFile = new File(logFilePath);
        long offset = logFile.length();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("initializing log anchor with log file Id: {} at offset: {}", (Object)fileId, (Object)offset);
        }
        return this.getLogFileFirstLsn(fileId) + offset;
    }

    public void renewLogFiles() {
        this.terminateLogFlusher();
        this.closeCurrentLogFile();
        long nextLogFileId = this.getNextLogFileId();
        LogManager.createFileIfNotExists(this.getLogFilePath(nextLogFileId));
        long logFileFirstLsn = this.getLogFileFirstLsn(nextLogFileId);
        this.deleteOldLogFiles(logFileFirstLsn);
        this.initializeLogManager(nextLogFileId);
    }

    public void deleteOldLogFiles(long checkpointLSN) {
        Long checkpointLSNLogFileID = this.getLogFileId(checkpointLSN);
        List<Long> logFileIds = this.getOrderedLogFileIds();
        if (!logFileIds.isEmpty()) {
            Collections.sort(logFileIds);
            logFileIds.remove(logFileIds.size() - 1);
            for (Long id : logFileIds) {
                if (id >= checkpointLSNLogFileID) break;
                File file = new File(this.getLogFilePath(id));
                file.delete();
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("Deleted log file " + file.getAbsolutePath());
            }
        }
    }

    private void terminateLogFlusher() {
        block4: {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Terminating LogFlusher thread ...");
            }
            this.logFlusher.terminate();
            try {
                this.futureLogFlusher.get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (!LOGGER.isInfoEnabled()) break block4;
                LOGGER.info("---------- warning(begin): LogFlusher thread is terminated abnormally --------");
                e.printStackTrace();
                LOGGER.info("---------- warning(end)  : LogFlusher thread is terminated abnormally --------");
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("LogFlusher thread is terminated.");
        }
    }

    public List<Long> getOrderedLogFileIds() {
        File fileLogDir = new File(this.logDir);
        String[] logFileNames = null;
        ArrayList<Long> logFileIds = null;
        if (!fileLogDir.exists()) {
            LOGGER.log(Level.INFO, "log dir " + this.logDir + " doesn't exist.  returning empty list");
            return Collections.emptyList();
        }
        if (!fileLogDir.isDirectory()) {
            throw new IllegalStateException("log dir " + this.logDir + " exists but it is not a directory");
        }
        logFileNames = fileLogDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(LogManager.this.logFilePrefix);
            }
        });
        if (logFileNames == null) {
            throw new IllegalStateException("listing of log dir (" + this.logDir + ") files returned null. Either an IO error occurred or the dir was just deleted by another process/thread");
        }
        if (logFileNames.length == 0) {
            LOGGER.log(Level.INFO, "the log dir (" + this.logDir + ") is empty. returning empty list");
            return Collections.emptyList();
        }
        logFileIds = new ArrayList<Long>();
        for (String fileName : logFileNames) {
            logFileIds.add(Long.parseLong(fileName.substring(this.logFilePrefix.length() + 1)));
        }
        logFileIds.sort(Long::compareTo);
        return logFileIds;
    }

    private String getLogFilePath(long fileId) {
        return this.logDir + File.separator + this.logFilePrefix + "_" + fileId;
    }

    private long getLogFileOffset(long lsn) {
        return lsn % this.logFileSize;
    }

    public long getLogFileId(long lsn) {
        return lsn / this.logFileSize;
    }

    private static void createFileIfNotExists(String path) {
        try {
            File file = new File(path);
            if (file.exists()) {
                return;
            }
            File parentFile = file.getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            Files.createFile(file.toPath(), new FileAttribute[0]);
            LOGGER.info("Created log file {}", (Object)path);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create file in " + path, e);
        }
    }

    private void createNextLogFile() throws IOException {
        long nextFileBeginLsn = this.getNextFileFirstLsn();
        long fileId = this.getLogFileId(nextFileBeginLsn);
        Path nextFilePath = Paths.get(this.getLogFilePath(fileId), new String[0]);
        if (nextFilePath.toFile().exists()) {
            LOGGER.warn("Ignored create log file {} since file already exists", (Object)nextFilePath.toString());
            return;
        }
        Files.createFile(nextFilePath, new FileAttribute[0]);
    }

    private void setLogPosition(long lsn) throws IOException {
        long fileId = this.getLogFileId(lsn);
        Path targetFilePath = Paths.get(this.getLogFilePath(fileId), new String[0]);
        long targetPosition = this.getLogFileOffset(lsn);
        RandomAccessFile raf = new RandomAccessFile(targetFilePath.toFile(), "rw");
        this.appendChannel = raf.getChannel();
        this.appendChannel.position(targetPosition);
        this.currentLogFileId = fileId;
    }

    private void closeCurrentLogFile() {
        if (this.appendChannel != null && this.appendChannel.isOpen()) {
            try {
                LOGGER.info("closing current log file with id({})", (Object)this.currentLogFileId);
                this.appendChannel.close();
            }
            catch (IOException e) {
                LOGGER.error(() -> "failed to close log file with id(" + this.currentLogFileId + ")", (Throwable)e);
                throw new ACIDException((Throwable)e);
            }
        }
    }

    public long getReadableSmallestLSN() {
        List<Long> logFileIds = this.getOrderedLogFileIds();
        if (!logFileIds.isEmpty()) {
            return logFileIds.get(0) * this.logFileSize;
        }
        throw new IllegalStateException("Couldn't find any log files.");
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getLogPageSize() {
        return this.logPageSize;
    }

    public void setReplicationManager(IReplicationManager replicationManager) {
        throw new IllegalStateException("This log manager does not support replication");
    }

    public int getNumLogPages() {
        return this.numLogPages;
    }

    public TxnLogFile getLogFile(long LSN) throws IOException {
        long fileId = this.getLogFileId(LSN);
        String logFilePath = this.getLogFilePath(fileId);
        File file = new File(logFilePath);
        if (!file.exists()) {
            throw new IOException("Log file with id(" + fileId + ") was not found. Requested LSN: " + LSN);
        }
        RandomAccessFile raf = new RandomAccessFile(new File(logFilePath), "r");
        FileChannel newFileChannel = raf.getChannel();
        TxnLogFile logFile = new TxnLogFile((ILogManager)this, newFileChannel, fileId, fileId * this.logFileSize);
        return logFile;
    }

    public void closeLogFile(TxnLogFile logFileRef, FileChannel fileChannel) throws IOException {
        if (!fileChannel.isOpen()) {
            LOGGER.warn(() -> "Closing log file with id(" + logFileRef.getLogFileId() + ") with a closed channel.");
        }
        fileChannel.close();
    }

    private long getNextLogFileId() {
        return this.getOnDiskMaxLogFileId() + 1L;
    }

    private long getLogFileFirstLsn(long logFileId) {
        return logFileId * this.logFileSize;
    }

    private long getOnDiskMaxLogFileId() {
        List<Long> logFileIds = this.getOrderedLogFileIds();
        if (logFileIds.isEmpty()) {
            return 0L;
        }
        return logFileIds.get(logFileIds.size() - 1);
    }

    private class FlushLogsLogger
    implements Runnable {
        private FlushLogsLogger() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    ILogRecord logRecord = LogManager.this.flushLogsQ.take();
                    LogManager.this.appendToLogTail(logRecord);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

