/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class CheckpointThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(CheckpointThread.class.getName());
    private long lsnThreshold;
    private long checkpointTermInSecs;
    private final ILogManager logManager;
    private final ICheckpointManager checkpointManager;
    private volatile boolean shouldRun = true;

    public CheckpointThread(ICheckpointManager checkpointManager, ILogManager logManager, long lsnThreshold, long checkpointTermInSecs) {
        this.checkpointManager = checkpointManager;
        this.logManager = logManager;
        this.lsnThreshold = lsnThreshold;
        this.checkpointTermInSecs = checkpointTermInSecs;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Thread.currentThread().setName("Checkpoint Thread (" + Thread.currentThread().getId() + ")");
        long lastCheckpointLSN = -1L;
        while (this.shouldRun) {
            long currentLogLSN;
            try {
                CheckpointThread.sleep(this.checkpointTermInSecs * 1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!this.shouldRun) {
                return;
            }
            if (lastCheckpointLSN == -1L) {
                try {
                    lastCheckpointLSN = this.logManager.getReadableSmallestLSN();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error getting smallest readable LSN", e);
                    lastCheckpointLSN = 0L;
                }
            }
            if ((currentLogLSN = this.logManager.getAppendLSN()) - lastCheckpointLSN <= this.lsnThreshold) continue;
            try {
                long targetCheckpointLSN = lastCheckpointLSN + this.lsnThreshold;
                long currentCheckpointAttemptMinLSN = this.checkpointManager.tryCheckpoint(targetCheckpointLSN);
                if (currentCheckpointAttemptMinLSN < targetCheckpointLSN) continue;
                lastCheckpointLSN = currentCheckpointAttemptMinLSN;
            }
            catch (HyracksDataException e) {
                LOGGER.log(Level.SEVERE, "Error during checkpoint", e);
            }
        }
    }

    public void shutdown() {
        this.shouldRun = false;
    }
}

