/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.recovery;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.Checkpoint;
import org.apache.asterix.common.transactions.CheckpointProperties;
import org.apache.asterix.common.transactions.ICheckpointManager;
import org.apache.asterix.common.transactions.ILogManager;
import org.apache.asterix.common.transactions.ITransactionManager;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.service.recovery.CheckpointThread;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public abstract class AbstractCheckpointManager
implements ICheckpointManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractCheckpointManager.class.getName());
    private static final String CHECKPOINT_FILENAME_PREFIX = "checkpoint_";
    public static final long SHARP_CHECKPOINT_LSN = -1L;
    private static final FilenameFilter filter = (dir, name) -> name.startsWith(CHECKPOINT_FILENAME_PREFIX);
    private final File checkpointDir;
    private final int historyToKeep;
    private final int lsnThreshold;
    private final int pollFrequency;
    protected final ITransactionSubsystem txnSubsystem;
    private CheckpointThread checkpointer;

    public AbstractCheckpointManager(ITransactionSubsystem txnSubsystem, CheckpointProperties checkpointProperties) {
        this.txnSubsystem = txnSubsystem;
        String checkpointDirPath = checkpointProperties.getCheckpointDirPath();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Checkpoint directory = " + checkpointDirPath);
        }
        if (!checkpointDirPath.endsWith(File.separator)) {
            checkpointDirPath = checkpointDirPath + File.separator;
        }
        this.checkpointDir = new File(checkpointDirPath);
        if (!this.checkpointDir.exists()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Checkpoint directory " + checkpointDirPath + " didn't exist. Creating one");
            }
            this.checkpointDir.mkdirs();
        }
        this.lsnThreshold = checkpointProperties.getLsnThreshold();
        this.pollFrequency = checkpointProperties.getPollFrequency();
        this.historyToKeep = checkpointProperties.getHistoryToKeep() == 0 ? 1 : checkpointProperties.getHistoryToKeep();
    }

    public Checkpoint getLatest() throws ACIDException {
        LOGGER.log(Level.INFO, "Getting latest checkpoint");
        Object[] checkpoints = this.checkpointDir.listFiles(filter);
        if (checkpoints == null || checkpoints.length == 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Listing of files in the checkpoint dir returned " + (checkpoints == null ? "null" : "empty"));
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Listing of files in the checkpoint dir returned " + Arrays.toString(checkpoints));
        }
        ArrayList<Checkpoint> checkpointObjectList = new ArrayList<Checkpoint>();
        for (Object file : checkpoints) {
            try {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Reading checkpoint file: " + ((File)file).getAbsolutePath());
                }
                String jsonString = new String(Files.readAllBytes(Paths.get(((File)file).getAbsolutePath(), new String[0])));
                checkpointObjectList.add(Checkpoint.fromJson((String)jsonString));
            }
            catch (ClosedByInterruptException e) {
                Thread.currentThread().interrupt();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Interrupted while reading checkpoint file: " + ((File)file).getAbsolutePath(), e);
                }
                throw new ACIDException((Throwable)e);
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, "Failed to read checkpoint file: " + ((File)file).getAbsolutePath(), e);
                }
                ((File)file).delete();
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "Deleted corrupted checkpoint file: " + ((File)file).getAbsolutePath());
            }
        }
        if (checkpointObjectList.isEmpty()) {
            LOGGER.severe("All checkpoint files are corrupted. Forcing recovery from the beginning of the log");
            checkpointObjectList.add(this.forgeForceRecoveryCheckpoint());
        }
        Collections.sort(checkpointObjectList);
        return (Checkpoint)checkpointObjectList.get(0);
    }

    public void start() {
        this.checkpointer = new CheckpointThread(this, this.txnSubsystem.getLogManager(), this.lsnThreshold, (long)this.pollFrequency);
        this.checkpointer.start();
    }

    public void stop(boolean dumpState, OutputStream ouputStream) throws IOException {
        this.checkpointer.shutdown();
        this.checkpointer.interrupt();
        try {
            this.checkpointer.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void dumpState(OutputStream os) throws IOException {
    }

    public Path getCheckpointPath(long checkpointTimestamp) {
        return Paths.get(this.checkpointDir.getAbsolutePath() + File.separator + CHECKPOINT_FILENAME_PREFIX + Long.toString(checkpointTimestamp), new String[0]);
    }

    protected void capture(long minMCTFirstLSN, boolean sharp) throws HyracksDataException {
        ILogManager logMgr = this.txnSubsystem.getLogManager();
        ITransactionManager txnMgr = this.txnSubsystem.getTransactionManager();
        Checkpoint checkpointObject = new Checkpoint(logMgr.getAppendLSN(), minMCTFirstLSN, txnMgr.getMaxJobId(), System.currentTimeMillis(), sharp, 7);
        this.persist(checkpointObject);
        this.cleanup();
    }

    protected Checkpoint forgeForceRecoveryCheckpoint() {
        return new Checkpoint(Long.MIN_VALUE, Long.MIN_VALUE, Integer.MIN_VALUE, System.currentTimeMillis(), false, 7);
    }

    private void persist(Checkpoint checkpoint) throws HyracksDataException {
        File file;
        Path path = this.getCheckpointPath(checkpoint.getTimeStamp());
        if (LOGGER.isLoggable(Level.INFO)) {
            file = path.toFile();
            LOGGER.log(Level.INFO, "Persisting checkpoint file to " + file + " which " + (file.exists() ? "already exists" : "doesn't exist yet"));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(checkpoint.asJson());
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to write checkpoint to disk", e);
            throw HyracksDataException.create((Throwable)e);
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            file = path.toFile();
            LOGGER.log(Level.INFO, "Completed persisting checkpoint file to " + file + " which now " + (file.exists() ? "exists" : " still doesn't exist"));
        }
    }

    private void cleanup() {
        Object[] checkpointFiles = this.checkpointDir.listFiles(filter);
        Arrays.sort(checkpointFiles);
        for (int i = 0; i < checkpointFiles.length - this.historyToKeep; ++i) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Deleting checkpoint file at: " + ((File)checkpointFiles[i]).getAbsolutePath());
            }
            if (((File)checkpointFiles[i]).delete() || !LOGGER.isLoggable(Level.WARNING)) continue;
            LOGGER.warning("Could not delete checkpoint file at: " + ((File)checkpointFiles[i]).getAbsolutePath());
        }
    }
}

