/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.logging;

import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.transactions.ILogBuffer;
import org.apache.asterix.common.utils.InterruptUtil;
import org.apache.asterix.transaction.management.service.logging.LogBuffer;
import org.apache.asterix.transaction.management.service.logging.LogManager;

class LogFlusher
implements Callable<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(LogFlusher.class.getName());
    private static final ILogBuffer POISON_PILL = new LogBuffer(null, 14, null);
    private final LogManager logMgr;
    private final LinkedBlockingQueue<ILogBuffer> emptyQ;
    private final LinkedBlockingQueue<ILogBuffer> flushQ;
    private final LinkedBlockingQueue<ILogBuffer> stashQ;
    private volatile ILogBuffer flushPage;
    private volatile boolean stopping;
    private final Semaphore started;

    LogFlusher(LogManager logMgr, LinkedBlockingQueue<ILogBuffer> emptyQ, LinkedBlockingQueue<ILogBuffer> flushQ, LinkedBlockingQueue<ILogBuffer> stashQ) {
        this.logMgr = logMgr;
        this.emptyQ = emptyQ;
        this.flushQ = flushQ;
        this.stashQ = stashQ;
        this.started = new Semaphore(0);
    }

    public void terminate() {
        InterruptUtil.doUninterruptibly(this.started::acquire);
        this.stopping = true;
        ILogBuffer currentFlushPage = this.flushPage;
        if (currentFlushPage != null) {
            currentFlushPage.stop();
        }
        InterruptUtil.doUninterruptibly(() -> this.flushQ.put(POISON_PILL));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean call() throws InterruptedException {
        this.started.release();
        boolean interrupted = false;
        try {
            while (true) {
                this.flushPage = null;
                boolean bl = interrupted = InterruptUtil.doUninterruptiblyGet(() -> {
                    this.flushPage = this.flushQ.take();
                }) || interrupted;
                if (this.flushPage == POISON_PILL) {
                    Boolean bl2 = true;
                    return bl2;
                }
                this.flushPage.flush(this.stopping);
                this.emptyQ.add(this.flushPage.getLogPageSize() == this.logMgr.getLogPageSize() ? this.flushPage : (ILogBuffer)this.stashQ.remove());
                continue;
                break;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "LogFlusher is terminating abnormally. System is in unusable state.", e);
            throw e;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

