/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.asterix.transaction.management.service.locking.AllocInfo;
import org.apache.asterix.transaction.management.service.locking.RecordManagerStats;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;

public class JobRecordManager {
    public static final boolean CHECK_SLOTS = false;
    public static final boolean TRACK_ALLOC_LOC = false;
    static final int NO_SLOTS = 1000;
    public static int ITEM_SIZE = 40;
    public static int LAST_HOLDER_OFF = 0;
    public static int LAST_WAITER_OFF = 8;
    public static int LAST_UPGRADER_OFF = 16;
    public static int NEXT_FREE_SLOT_OFF = 24;
    public static int JOB_ID_OFF = 28;
    public static int ALLOC_ID_OFF = 32;
    private final long txnShrinkTimer;
    private long shrinkTimer;
    private ArrayList<Buffer> buffers;
    private int current;
    private int occupiedSlots;
    private boolean isShrinkTimerOn;
    int allocCounter;

    public JobRecordManager(long txnShrinkTimer) {
        this.txnShrinkTimer = txnShrinkTimer;
        this.buffers = new ArrayList();
        this.buffers.add(new Buffer());
        this.current = 0;
        this.allocCounter = 0;
    }

    synchronized int allocate() {
        if (this.buffers.get(this.current).isFull()) {
            int size = this.buffers.size();
            int start = this.current + 1;
            SlotSource source = SlotSource.NEW;
            for (int j = start; j < start + size; ++j) {
                int i = j % size;
                Buffer buffer = this.buffers.get(i);
                if (buffer.isInitialized() && !buffer.isFull()) {
                    source = SlotSource.NON_FULL;
                    this.current = i;
                    break;
                }
                if (buffer.isInitialized() || source != SlotSource.NEW) continue;
                source = SlotSource.UNINITIALIZED;
                this.current = i;
            }
            switch (source) {
                case NEW: {
                    this.buffers.add(new Buffer());
                    this.current = this.buffers.size() - 1;
                    break;
                }
                case UNINITIALIZED: {
                    this.buffers.get(this.current).initialize();
                }
            }
        }
        ++this.occupiedSlots;
        return this.buffers.get(this.current).allocate() + this.current * 1000;
    }

    synchronized void deallocate(int slotNum) {
        this.buffers.get(slotNum / 1000).deallocate(slotNum % 1000);
        --this.occupiedSlots;
        if (this.needShrink()) {
            this.shrink();
        }
    }

    private boolean needShrink() {
        int size = this.buffers.size();
        int usedSlots = this.occupiedSlots;
        if (usedSlots == 0) {
            usedSlots = 1;
        }
        if (size > 1 && size * 1000 / usedSlots >= 3) {
            if (this.isShrinkTimerOn) {
                if (System.currentTimeMillis() - this.shrinkTimer >= this.txnShrinkTimer) {
                    this.isShrinkTimerOn = false;
                    return true;
                }
            } else {
                this.isShrinkTimerOn = true;
                this.shrinkTimer = System.currentTimeMillis();
            }
        } else {
            this.isShrinkTimerOn = false;
        }
        return false;
    }

    private void shrink() {
        Buffer buffer;
        int i;
        int removeCount = 0;
        int size = this.buffers.size();
        int maxDecreaseCount = size / 2;
        for (i = 1; i < size; ++i) {
            if (!this.buffers.get(i).isEmpty()) continue;
            this.buffers.get(i).deinitialize();
        }
        for (i = size - 1; i >= 1 && !(buffer = this.buffers.get(i)).isInitialized(); --i) {
            this.buffers.remove(i);
            if (++removeCount == maxDecreaseCount) break;
        }
        this.current = 0;
        this.isShrinkTimerOn = false;
    }

    public long getLastHolder(int slotNum) {
        Buffer buf = this.buffers.get(slotNum / 1000);
        buf.checkSlot(slotNum % 1000);
        ByteBuffer b = buf.bb;
        return b.getLong(slotNum % 1000 * ITEM_SIZE + LAST_HOLDER_OFF);
    }

    public void setLastHolder(int slotNum, long value) {
        ByteBuffer b = this.buffers.get(slotNum / 1000).bb;
        b.putLong(slotNum % 1000 * ITEM_SIZE + LAST_HOLDER_OFF, value);
    }

    public long getLastWaiter(int slotNum) {
        Buffer buf = this.buffers.get(slotNum / 1000);
        buf.checkSlot(slotNum % 1000);
        ByteBuffer b = buf.bb;
        return b.getLong(slotNum % 1000 * ITEM_SIZE + LAST_WAITER_OFF);
    }

    public void setLastWaiter(int slotNum, long value) {
        ByteBuffer b = this.buffers.get(slotNum / 1000).bb;
        b.putLong(slotNum % 1000 * ITEM_SIZE + LAST_WAITER_OFF, value);
    }

    public long getLastUpgrader(int slotNum) {
        Buffer buf = this.buffers.get(slotNum / 1000);
        buf.checkSlot(slotNum % 1000);
        ByteBuffer b = buf.bb;
        return b.getLong(slotNum % 1000 * ITEM_SIZE + LAST_UPGRADER_OFF);
    }

    public void setLastUpgrader(int slotNum, long value) {
        ByteBuffer b = this.buffers.get(slotNum / 1000).bb;
        b.putLong(slotNum % 1000 * ITEM_SIZE + LAST_UPGRADER_OFF, value);
    }

    public int getJobId(int slotNum) {
        Buffer buf = this.buffers.get(slotNum / 1000);
        buf.checkSlot(slotNum % 1000);
        ByteBuffer b = buf.bb;
        return b.getInt(slotNum % 1000 * ITEM_SIZE + JOB_ID_OFF);
    }

    public void setJobId(int slotNum, int value) {
        ByteBuffer b = this.buffers.get(slotNum / 1000).bb;
        b.putInt(slotNum % 1000 * ITEM_SIZE + JOB_ID_OFF, value);
    }

    public short getAllocId(int slotNum) {
        Buffer buf = this.buffers.get(slotNum / 1000);
        buf.checkSlot(slotNum % 1000);
        ByteBuffer b = buf.bb;
        return b.getShort(slotNum % 1000 * ITEM_SIZE + ALLOC_ID_OFF);
    }

    public void setAllocId(int slotNum, short value) {
        ByteBuffer b = this.buffers.get(slotNum / 1000).bb;
        b.putShort(slotNum % 1000 * ITEM_SIZE + ALLOC_ID_OFF, value);
    }

    public AllocInfo getAllocInfo(int slotNum) {
        Buffer buf = this.buffers.get(slotNum / 1000);
        if (buf.allocList == null) {
            return null;
        }
        return buf.allocList.get(slotNum % 1000);
    }

    StringBuilder append(StringBuilder sb) {
        sb.append("+++ current: ").append(this.current).append(" no occupied slots: ").append(this.occupiedSlots).append(" +++\n");
        for (int i = 0; i < this.buffers.size(); ++i) {
            this.buffers.get(i).append(sb);
            sb.append("\n");
        }
        return sb;
    }

    public String toString() {
        return this.append(new StringBuilder()).toString();
    }

    public RecordManagerStats addTo(RecordManagerStats s) {
        int size = this.buffers.size();
        s.buffers += size;
        s.slots += size * 1000;
        s.size += size * 1000 * ITEM_SIZE;
        for (int i = 0; i < size; ++i) {
            this.buffers.get(i).addTo(s);
        }
        return s;
    }

    static class Buffer {
        private ByteBuffer bb = null;
        private int freeSlotNum;
        private int occupiedSlots;
        ArrayList<AllocInfo> allocList;

        Buffer() {
            this.initialize();
        }

        void initialize() {
            this.bb = ByteBuffer.allocate(1000 * ITEM_SIZE);
            this.freeSlotNum = 0;
            this.occupiedSlots = 0;
            for (int i = 0; i < 999; ++i) {
                this.setNextFreeSlot(i, i + 1);
            }
            this.setNextFreeSlot(999, -1);
        }

        public void deinitialize() {
            this.bb = null;
        }

        public boolean isInitialized() {
            return this.bb != null;
        }

        public boolean isFull() {
            return this.freeSlotNum == -1;
        }

        public boolean isEmpty() {
            return this.occupiedSlots == 0;
        }

        public int allocate() {
            int slotNum = this.freeSlotNum;
            this.freeSlotNum = this.getNextFreeSlot(slotNum);
            this.bb.putLong(slotNum * ITEM_SIZE + LAST_HOLDER_OFF, -1L);
            this.bb.putLong(slotNum * ITEM_SIZE + LAST_WAITER_OFF, -1L);
            this.bb.putLong(slotNum * ITEM_SIZE + LAST_UPGRADER_OFF, -1L);
            this.bb.putInt(slotNum * ITEM_SIZE + NEXT_FREE_SLOT_OFF, -1);
            this.bb.putInt(slotNum * ITEM_SIZE + JOB_ID_OFF, -559038737);
            this.bb.putShort(slotNum * ITEM_SIZE + ALLOC_ID_OFF, (short)-8531);
            ++this.occupiedSlots;
            return slotNum;
        }

        public void deallocate(int slotNum) {
            this.bb.putLong(slotNum * ITEM_SIZE + LAST_HOLDER_OFF, -1L);
            this.bb.putLong(slotNum * ITEM_SIZE + LAST_WAITER_OFF, -1L);
            this.bb.putLong(slotNum * ITEM_SIZE + LAST_UPGRADER_OFF, -1L);
            this.bb.putInt(slotNum * ITEM_SIZE + NEXT_FREE_SLOT_OFF, -1);
            this.bb.putInt(slotNum * ITEM_SIZE + JOB_ID_OFF, -559038737);
            this.bb.putShort(slotNum * ITEM_SIZE + ALLOC_ID_OFF, (short)-8531);
            this.setNextFreeSlot(slotNum, this.freeSlotNum);
            this.freeSlotNum = slotNum;
            --this.occupiedSlots;
        }

        public int getNextFreeSlot(int slotNum) {
            return this.bb.getInt(slotNum * ITEM_SIZE + NEXT_FREE_SLOT_OFF);
        }

        public void setNextFreeSlot(int slotNum, int nextFreeSlot) {
            this.bb.putInt(slotNum * ITEM_SIZE + NEXT_FREE_SLOT_OFF, nextFreeSlot);
        }

        StringBuilder append(StringBuilder sb) {
            long value;
            int i;
            sb.append("++ free slot: ").append(this.freeSlotNum).append(" no occupied slots: ").append(this.occupiedSlots).append(" ++\n");
            sb.append("last holder    | ");
            for (i = 0; i < 1000; ++i) {
                value = this.bb.getLong(i * ITEM_SIZE + LAST_HOLDER_OFF);
                sb = TypeUtil.Global.appendFixed(sb, value);
                sb.append(" | ");
            }
            sb.append("\n");
            sb.append("last waiter    | ");
            for (i = 0; i < 1000; ++i) {
                value = this.bb.getLong(i * ITEM_SIZE + LAST_WAITER_OFF);
                sb = TypeUtil.Global.appendFixed(sb, value);
                sb.append(" | ");
            }
            sb.append("\n");
            sb.append("last upgrader  | ");
            for (i = 0; i < 1000; ++i) {
                value = this.bb.getLong(i * ITEM_SIZE + LAST_UPGRADER_OFF);
                sb = TypeUtil.Global.appendFixed(sb, value);
                sb.append(" | ");
            }
            sb.append("\n");
            sb.append("next free slot | ");
            for (i = 0; i < 1000; ++i) {
                int value2 = this.bb.getInt(i * ITEM_SIZE + NEXT_FREE_SLOT_OFF);
                sb = TypeUtil.Int.appendFixed(sb, value2);
                sb.append(" | ");
            }
            sb.append("\n");
            sb.append("job id         | ");
            for (i = 0; i < 1000; ++i) {
                int value3 = this.bb.getInt(i * ITEM_SIZE + JOB_ID_OFF);
                sb = TypeUtil.Int.appendFixed(sb, value3);
                sb.append(" | ");
            }
            sb.append("\n");
            sb.append("alloc id       | ");
            for (i = 0; i < 1000; ++i) {
                short value4 = this.bb.getShort(i * ITEM_SIZE + ALLOC_ID_OFF);
                sb = TypeUtil.Short.appendFixed(sb, value4);
                sb.append(" | ");
            }
            sb.append("\n");
            return sb;
        }

        public String toString() {
            return this.append(new StringBuilder()).toString();
        }

        public void addTo(RecordManagerStats s) {
            if (this.isInitialized()) {
                s.items += this.occupiedSlots;
            }
        }

        private void checkSlot(int slotNum) {
        }
    }

    static enum SlotSource {
        NON_FULL,
        UNINITIALIZED,
        NEW;

    }
}

