/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.resource;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.asterix.common.cluster.ClusterPartition;
import org.apache.asterix.common.config.MetadataProperties;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.replication.IReplicationManager;
import org.apache.asterix.common.replication.ReplicationJob;
import org.apache.asterix.common.storage.IndexFileProperties;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.commons.io.FileUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.io.IODeviceHandle;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.common.ILocalResourceRepository;
import org.apache.hyracks.storage.common.LocalResource;

public class PersistentLocalResourceRepository
implements ILocalResourceRepository {
    public static final String METADATA_FILE_NAME = ".metadata";
    private static final Logger LOGGER = Logger.getLogger(PersistentLocalResourceRepository.class.getName());
    private static final String STORAGE_METADATA_DIRECTORY = "root_metadata";
    private static final String STORAGE_METADATA_FILE_NAME_PREFIX = ".root_metadata";
    private static final int MAX_CACHED_RESOURCES = 1000;
    private static final FilenameFilter METADATA_FILES_FILTER = (dir, name) -> name.equalsIgnoreCase(METADATA_FILE_NAME);
    private final IIOManager ioManager;
    private final String[] mountPoints;
    private final String nodeId;
    private final Cache<String, LocalResource> resourceCache;
    private final SortedMap<Integer, ClusterPartition> clusterPartitions;
    private final Set<Integer> nodeOriginalPartitions;
    private final Set<Integer> nodeActivePartitions;
    private boolean isReplicationEnabled = false;
    private Set<String> filesToBeReplicated;
    private IReplicationManager replicationManager;
    private Set<Integer> nodeInactivePartitions;

    public PersistentLocalResourceRepository(IIOManager ioManager, List<IODeviceHandle> devices, String nodeId, MetadataProperties metadataProperties) throws HyracksDataException {
        this.ioManager = ioManager;
        this.mountPoints = new String[devices.size()];
        this.nodeId = nodeId;
        this.clusterPartitions = metadataProperties.getClusterPartitions();
        for (int i = 0; i < this.mountPoints.length; ++i) {
            String mountPoint = devices.get(i).getMount().getPath();
            File mountPointDir = new File(mountPoint);
            if (!mountPointDir.exists()) {
                throw new HyracksDataException(mountPointDir.getAbsolutePath() + " doesn't exist.");
            }
            this.mountPoints[i] = !mountPoint.endsWith(File.separator) ? mountPoint + File.separator : mountPoint;
        }
        this.resourceCache = CacheBuilder.newBuilder().maximumSize(1000L).build();
        ClusterPartition[] nodePartitions = (ClusterPartition[])metadataProperties.getNodePartitions().get(nodeId);
        this.nodeOriginalPartitions = new HashSet<Integer>(nodePartitions.length);
        this.nodeActivePartitions = new HashSet<Integer>(nodePartitions.length);
        for (ClusterPartition partition : nodePartitions) {
            this.nodeOriginalPartitions.add(partition.getPartitionId());
            this.nodeActivePartitions.add(partition.getPartitionId());
        }
    }

    public String toString() {
        StringBuilder aString = new StringBuilder().append(PersistentLocalResourceRepository.class.getSimpleName()).append(13).append(this.ioManager.getClass().getSimpleName()).append(':').append(13).append(this.ioManager.toString()).append(13).append("Cached Resources:").append(13);
        this.resourceCache.asMap().forEach((key, value) -> aString.append((String)key).append("->").append(value).append(13));
        return aString.toString();
    }

    public void initializeNewUniverse(String storageRoot) throws HyracksDataException {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Initializing local resource repository ... ");
        }
        String storageRootDirName = storageRoot;
        while (storageRootDirName.startsWith(File.separator)) {
            storageRootDirName = storageRootDirName.substring(File.separator.length());
        }
        for (int i = 0; i < this.mountPoints.length; ++i) {
            FileReference storageMetadataFile = PersistentLocalResourceRepository.getStorageMetadataFile(this.ioManager, this.nodeId, i);
            File storageMetadataDir = storageMetadataFile.getFile().getParentFile();
            if (storageMetadataDir.exists()) {
                throw HyracksDataException.create((int)15, (Serializable[])new Serializable[]{this.getClass().getSimpleName(), storageMetadataDir.getAbsolutePath()});
            }
            boolean success = storageMetadataDir.mkdirs();
            if (!success) {
                throw HyracksDataException.create((int)16, (Serializable[])new Serializable[]{this.getClass().getSimpleName(), storageMetadataDir.getAbsolutePath()});
            }
            LOGGER.log(Level.INFO, "created the root-metadata-file's directory: " + storageMetadataDir.getAbsolutePath());
            try (FileOutputStream fos = new FileOutputStream(storageMetadataFile.getFile());){
                fos.write(storageRootDirName.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
            LOGGER.log(Level.INFO, "created the root-metadata-file: " + storageMetadataFile.getAbsolutePath());
        }
        LOGGER.log(Level.INFO, "Completed the initialization of the local resource repository");
    }

    public LocalResource get(String relativePath) throws HyracksDataException {
        FileReference resourceFile;
        LocalResource resource = (LocalResource)this.resourceCache.getIfPresent((Object)relativePath);
        if (resource == null && (resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath)).getFile().exists()) {
            resource = PersistentLocalResourceRepository.readLocalResource(resourceFile.getFile());
            this.resourceCache.put((Object)relativePath, (Object)resource);
        }
        return resource;
    }

    public synchronized void insert(LocalResource resource) throws HyracksDataException {
        String relativePath = PersistentLocalResourceRepository.getFileName(resource.getPath());
        FileReference resourceFile = this.ioManager.resolve(relativePath);
        if (resourceFile.getFile().exists()) {
            throw new HyracksDataException("Duplicate resource: " + resourceFile.getAbsolutePath());
        }
        File parent = resourceFile.getFile().getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw HyracksDataException.create((int)67, (Serializable[])new Serializable[]{parent.getAbsolutePath()});
        }
        try (FileOutputStream fos = new FileOutputStream(resourceFile.getFile());
             ObjectOutputStream oosToFos = new ObjectOutputStream(fos);){
            oosToFos.writeObject(resource);
            oosToFos.flush();
        }
        catch (IOException e) {
            throw new HyracksDataException((Throwable)e);
        }
        this.resourceCache.put((Object)resource.getPath(), (Object)resource);
        if (this.isReplicationEnabled) {
            this.createReplicationJob(IReplicationJob.ReplicationOperation.REPLICATE, resourceFile);
        }
    }

    public synchronized void delete(String relativePath) throws HyracksDataException {
        FileReference resourceFile = PersistentLocalResourceRepository.getLocalResourceFileByName(this.ioManager, relativePath);
        if (resourceFile.getFile().exists()) {
            try {
                this.resourceCache.invalidate((Object)relativePath);
                IoUtil.delete((FileReference)resourceFile);
            }
            finally {
                if (this.isReplicationEnabled && !resourceFile.getFile().getName().startsWith(STORAGE_METADATA_FILE_NAME_PREFIX)) {
                    this.createReplicationJob(IReplicationJob.ReplicationOperation.DELETE, resourceFile);
                }
            }
        } else {
            throw HyracksDataException.create((int)55, (Serializable[])new Serializable[]{relativePath});
        }
    }

    private static FileReference getLocalResourceFileByName(IIOManager ioManager, String resourcePath) throws HyracksDataException {
        String fileName = resourcePath + File.separator + METADATA_FILE_NAME;
        return ioManager.resolve(fileName);
    }

    public Map<Long, LocalResource> loadAndGetAllResources() throws IOException {
        LOGGER.log(Level.INFO, "Loading all resources");
        HashMap<Long, LocalResource> resourcesMap = new HashMap<Long, LocalResource>();
        for (int i = 0; i < this.mountPoints.length; ++i) {
            File storageRootDir = PersistentLocalResourceRepository.getStorageRootDirectoryIfExists(this.ioManager, this.nodeId, i);
            if (storageRootDir == null) {
                LOGGER.log(Level.INFO, "Getting storage root dir returned null. Returning");
                continue;
            }
            LOGGER.log(Level.INFO, "Getting storage root dir returned " + storageRootDir.getAbsolutePath());
            File[] partitions = storageRootDir.listFiles();
            LOGGER.log(Level.INFO, "Number of partitions found = " + partitions.length);
            for (File partition : partitions) {
                File[] dataverseFileList = partition.listFiles();
                LOGGER.log(Level.INFO, "Reading partition = " + partition.getName() + ". Number of dataverses found: " + dataverseFileList.length);
                if (dataverseFileList == null) continue;
                for (File dataverseFile : dataverseFileList) {
                    this.loadDataverse(dataverseFile, resourcesMap);
                }
            }
        }
        return resourcesMap;
    }

    private void loadDataverse(File dataverseFile, Map<Long, LocalResource> resourcesMap) throws HyracksDataException {
        File[] indexFileList;
        LOGGER.log(Level.INFO, "Loading dataverse:" + dataverseFile.getName());
        if (dataverseFile.isDirectory() && (indexFileList = dataverseFile.listFiles()) != null) {
            for (File indexFile : indexFileList) {
                this.loadIndex(indexFile, resourcesMap);
            }
        }
    }

    private void loadIndex(File indexFile, Map<Long, LocalResource> resourcesMap) throws HyracksDataException {
        File[] metadataFiles;
        LOGGER.log(Level.INFO, "Loading index:" + indexFile.getName());
        if (indexFile.isDirectory() && (metadataFiles = indexFile.listFiles(METADATA_FILES_FILTER)) != null) {
            for (File metadataFile : metadataFiles) {
                LocalResource localResource = PersistentLocalResourceRepository.readLocalResource(metadataFile);
                LOGGER.log(Level.INFO, "Resource loaded " + localResource.getId() + ":" + localResource.getPath());
                resourcesMap.put(localResource.getId(), localResource);
            }
        }
    }

    public long maxId() throws HyracksDataException {
        long maxResourceId = 0L;
        for (int i = 0; i < this.mountPoints.length; ++i) {
            File[] partitions;
            File storageRootDir = PersistentLocalResourceRepository.getStorageRootDirectoryIfExists(this.ioManager, this.nodeId, i);
            if (storageRootDir == null) continue;
            for (File partition : partitions = storageRootDir.listFiles()) {
                File[] dataverseFileList = partition.listFiles();
                if (dataverseFileList == null) continue;
                for (File dataverseFile : dataverseFileList) {
                    maxResourceId = this.getMaxResourceIdForDataverse(dataverseFile, maxResourceId);
                }
            }
        }
        return maxResourceId;
    }

    private long getMaxResourceIdForDataverse(File dataverseFile, long maxSoFar) throws HyracksDataException {
        File[] indexFileList;
        long maxResourceId = maxSoFar;
        if (dataverseFile.isDirectory() && (indexFileList = dataverseFile.listFiles()) != null) {
            for (File indexFile : indexFileList) {
                maxResourceId = this.getMaxResourceIdForIndex(indexFile, maxResourceId);
            }
        }
        return maxResourceId;
    }

    private long getMaxResourceIdForIndex(File indexFile, long maxSoFar) throws HyracksDataException {
        File[] metadataFiles;
        long maxResourceId = maxSoFar;
        if (indexFile.isDirectory() && (metadataFiles = indexFile.listFiles(METADATA_FILES_FILTER)) != null) {
            for (File metadataFile : metadataFiles) {
                LocalResource localResource = PersistentLocalResourceRepository.readLocalResource(metadataFile);
                maxResourceId = Math.max(maxResourceId, localResource.getId());
            }
        }
        return maxResourceId;
    }

    private static String getFileName(String path) {
        return path.endsWith(File.separator) ? path + METADATA_FILE_NAME : path + File.separator + METADATA_FILE_NAME;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalResource readLocalResource(File file) throws HyracksDataException {
        try (FileInputStream fis = new FileInputStream(file);){
            Throwable throwable;
            ObjectInputStream oisFromFis;
            block25: {
                LocalResource localResource;
                block26: {
                    oisFromFis = new ObjectInputStream(fis);
                    throwable = null;
                    LocalResource resource = (LocalResource)oisFromFis.readObject();
                    if (resource.getVersion() != 6) break block25;
                    localResource = resource;
                    if (oisFromFis == null) return localResource;
                    if (throwable == null) break block26;
                    try {
                        oisFromFis.close();
                        return localResource;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return localResource;
                    }
                }
                oisFromFis.close();
                return localResource;
            }
            try {
                try {
                    throw new AsterixException("Storage version mismatch.");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (oisFromFis == null) throw throwable4;
                if (throwable == null) {
                    oisFromFis.close();
                    throw throwable4;
                }
                try {
                    oisFromFis.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (Exception e) {
            throw new HyracksDataException((Throwable)e);
        }
    }

    public void setReplicationManager(IReplicationManager replicationManager) {
        this.replicationManager = replicationManager;
        this.isReplicationEnabled = replicationManager.isReplicationEnabled();
        if (this.isReplicationEnabled) {
            this.filesToBeReplicated = new HashSet<String>();
            this.nodeInactivePartitions = ConcurrentHashMap.newKeySet();
        }
    }

    private void createReplicationJob(IReplicationJob.ReplicationOperation operation, FileReference fileRef) throws HyracksDataException {
        String[] fileNameTokens = fileRef.getAbsolutePath().split(File.separator);
        String partitionDir = fileNameTokens[fileNameTokens.length - 4];
        if (!partitionDir.equals("temp")) {
            this.filesToBeReplicated.clear();
            this.filesToBeReplicated.add(fileRef.getAbsolutePath());
            ReplicationJob job = new ReplicationJob(IReplicationJob.ReplicationJobType.METADATA, operation, IReplicationJob.ReplicationExecutionType.SYNC, this.filesToBeReplicated);
            try {
                this.replicationManager.submitJob((IReplicationJob)job);
            }
            catch (IOException e) {
                throw new HyracksDataException((Throwable)e);
            }
        }
    }

    public String[] getStorageMountingPoints() {
        return this.mountPoints;
    }

    public void deleteStorageData(boolean deleteStorageMetadata) throws IOException {
        for (int i = 0; i < this.mountPoints.length; ++i) {
            FileReference storageMetadataFile;
            File storageMetadataDir;
            File storageDir = PersistentLocalResourceRepository.getStorageRootDirectoryIfExists(this.ioManager, this.nodeId, i);
            if (storageDir != null && storageDir.isDirectory()) {
                FileUtils.deleteDirectory((File)storageDir);
            }
            if (!deleteStorageMetadata || !(storageMetadataDir = (storageMetadataFile = PersistentLocalResourceRepository.getStorageMetadataFile(this.ioManager, this.nodeId, i)).getFile().getParentFile().getParentFile()).exists() || !storageMetadataDir.isDirectory()) continue;
            FileUtils.deleteDirectory((File)storageMetadataDir);
        }
    }

    private static FileReference getStorageMetadataFile(IIOManager ioManager, String nodeId, int ioDeviceId) {
        String storageMetadataFileName = STORAGE_METADATA_DIRECTORY + File.separator + nodeId + "_iodevice" + ioDeviceId + File.separator + STORAGE_METADATA_FILE_NAME_PREFIX;
        return new FileReference((IODeviceHandle)ioManager.getIODevices().get(ioDeviceId), storageMetadataFileName);
    }

    public static File getStorageRootDirectoryIfExists(IIOManager ioManager, String nodeId, int ioDeviceId) throws HyracksDataException {
        try {
            FileReference storageMetadataFile = PersistentLocalResourceRepository.getStorageMetadataFile(ioManager, nodeId, ioDeviceId);
            LOGGER.log(Level.INFO, "Storage metadata file is " + storageMetadataFile.getAbsolutePath());
            if (storageMetadataFile.getFile().exists()) {
                String storageRootDirPath = new String(Files.readAllBytes(storageMetadataFile.getFile().toPath()), StandardCharsets.UTF_8);
                LOGGER.log(Level.INFO, "Storage metadata file found and root dir is " + storageRootDirPath);
                FileReference storageRootFileRef = new FileReference((IODeviceHandle)ioManager.getIODevices().get(ioDeviceId), storageRootDirPath);
                if (storageRootFileRef.getFile().exists()) {
                    return storageRootFileRef.getFile();
                }
                LOGGER.log(Level.INFO, "Storage root doesn't exist");
            } else {
                LOGGER.log(Level.INFO, "Storage metadata file doesn't exist");
            }
            return null;
        }
        catch (IOException ioe) {
            throw HyracksDataException.create((Throwable)ioe);
        }
    }

    public String getPartitionPath(int partition) {
        return this.mountPoints[this.getIODeviceNum(partition)];
    }

    public int getIODeviceNum(int partition) {
        return ((ClusterPartition)this.clusterPartitions.get(partition)).getIODeviceNum();
    }

    public Set<Integer> getActivePartitions() {
        return Collections.unmodifiableSet(this.nodeActivePartitions);
    }

    public Set<Integer> getInactivePartitions() {
        return Collections.unmodifiableSet(this.nodeInactivePartitions);
    }

    public Set<Integer> getNodeOrignalPartitions() {
        return Collections.unmodifiableSet(this.nodeOriginalPartitions);
    }

    public synchronized void addActivePartition(int partitonId) {
        this.nodeActivePartitions.add(partitonId);
        this.nodeInactivePartitions.remove(partitonId);
    }

    public synchronized void addInactivePartition(int partitonId) {
        this.nodeInactivePartitions.add(partitonId);
        this.nodeActivePartitions.remove(partitonId);
    }

    private static String getLocalResourceRelativePath(String absolutePath) {
        String[] tokens = absolutePath.split(File.separator);
        return tokens[tokens.length - 5] + File.separator + tokens[tokens.length - 4] + File.separator + tokens[tokens.length - 3] + File.separator + tokens[tokens.length - 2];
    }

    public IndexFileProperties getIndexFileRef(String absoluteFilePath) throws HyracksDataException {
        String[] tokens = absoluteFilePath.split(File.separator);
        if (tokens.length < 5) {
            throw new HyracksDataException("Invalid file format");
        }
        String fileName = tokens[tokens.length - 1];
        String index = tokens[tokens.length - 2];
        String dataverse = tokens[tokens.length - 3];
        String partition = tokens[tokens.length - 4];
        int partitionId = StoragePathUtil.getPartitionNumFromName((String)partition);
        String relativePath = PersistentLocalResourceRepository.getLocalResourceRelativePath(absoluteFilePath);
        LocalResource lr = this.get(relativePath);
        int datasetId = lr == null ? -1 : ((DatasetLocalResource)lr.getResource()).getDatasetId();
        return new IndexFileProperties(partitionId, dataverse, index, fileName, datasetId);
    }
}

