/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.opcallbacks;

import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.context.ITransactionSubsystemProvider;
import org.apache.asterix.common.dataflow.DatasetLocalResource;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.AbstractOperationCallbackFactory;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.common.transactions.JobId;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.asterix.transaction.management.opcallbacks.PrimaryIndexModificationOperationCallback;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.common.api.IModificationOperationCallbackFactory;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.common.IModificationOperationCallback;
import org.apache.hyracks.storage.common.LocalResource;

public class PrimaryIndexModificationOperationCallbackFactory
extends AbstractOperationCallbackFactory
implements IModificationOperationCallbackFactory {
    private static final long serialVersionUID = 1L;
    private final AbstractIndexModificationOperationCallback.Operation indexOp;

    public PrimaryIndexModificationOperationCallbackFactory(JobId jobId, int datasetId, int[] primaryKeyFields, ITransactionSubsystemProvider txnSubsystemProvider, AbstractIndexModificationOperationCallback.Operation indexOp, byte resourceType) {
        super(jobId, datasetId, primaryKeyFields, txnSubsystemProvider, resourceType);
        this.indexOp = indexOp;
    }

    public IModificationOperationCallback createModificationOperationCallback(LocalResource resource, IHyracksTaskContext ctx, IOperatorNodePushable operatorNodePushable) throws HyracksDataException {
        ITransactionSubsystem txnSubsystem = this.txnSubsystemProvider.getTransactionSubsystem(ctx);
        IDatasetLifecycleManager indexLifeCycleManager = txnSubsystem.getAsterixAppRuntimeContextProvider().getDatasetLifecycleManager();
        ILSMIndex index = (ILSMIndex)indexLifeCycleManager.get(resource.getPath());
        if (index == null) {
            throw new HyracksDataException("Index(id:" + resource.getId() + ") is not registered.");
        }
        try {
            ITransactionContext txnCtx = txnSubsystem.getTransactionManager().getTransactionContext(this.jobId, false);
            DatasetLocalResource aResource = (DatasetLocalResource)resource.getResource();
            PrimaryIndexModificationOperationCallback modCallback = new PrimaryIndexModificationOperationCallback(new DatasetId(this.datasetId), this.primaryKeyFields, txnCtx, txnSubsystem.getLockManager(), txnSubsystem, resource.getId(), aResource.getPartition(), this.resourceType, this.indexOp, operatorNodePushable);
            txnCtx.registerIndexAndCallback(resource.getId(), index, (AbstractOperationCallback)modCallback, true);
            return modCallback;
        }
        catch (ACIDException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

