/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.opcallbacks;

import org.apache.asterix.common.dataflow.LSMInsertDeleteOperatorNodePushable;
import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ILockManager;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.asterix.transaction.management.opcallbacks.AbstractIndexModificationOperationCallback;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class PrimaryIndexModificationOperationCallback
extends AbstractIndexModificationOperationCallback {
    private final LSMInsertDeleteOperatorNodePushable operatorNodePushable;

    public PrimaryIndexModificationOperationCallback(DatasetId datasetId, int[] primaryKeyFields, ITransactionContext txnCtx, ILockManager lockManager, ITransactionSubsystem txnSubsystem, long resourceId, int resourcePartition, byte resourceType, AbstractIndexModificationOperationCallback.Operation indexOp, IOperatorNodePushable operatorNodePushable) {
        super(datasetId, primaryKeyFields, txnCtx, lockManager, txnSubsystem, resourceId, resourcePartition, resourceType, indexOp);
        this.operatorNodePushable = (LSMInsertDeleteOperatorNodePushable)operatorNodePushable;
    }

    public void before(ITupleReference tuple) throws HyracksDataException {
        int pkHash = this.computePrimaryKeyHashValue(tuple, this.primaryKeyFields);
        try {
            if (this.operatorNodePushable != null) {
                boolean tryLockSucceed = this.lockManager.tryLock(this.datasetId, pkHash, (byte)4, this.txnCtx);
                if (!tryLockSucceed) {
                    this.operatorNodePushable.flushPartialFrame();
                    this.logWait();
                    this.lockManager.lock(this.datasetId, pkHash, (byte)4, this.txnCtx);
                }
            } else {
                this.lockManager.lock(this.datasetId, pkHash, (byte)4, this.txnCtx);
            }
        }
        catch (ACIDException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void found(ITupleReference before, ITupleReference after) throws HyracksDataException {
        try {
            int pkHash = this.computePrimaryKeyHashValue(after, this.primaryKeyFields);
            this.log(pkHash, after, before);
        }
        catch (ACIDException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void logWait() throws ACIDException {
        this.logRecord.setLogType((byte)6);
        this.logRecord.computeAndSetLogSize();
        this.txnSubsystem.getLogManager().log(this.logRecord);
    }
}

