/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.testframework.context;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.asterix.testframework.context.TestFileContext;
import org.apache.asterix.testframework.xml.CategoryEnum;
import org.apache.asterix.testframework.xml.TestCase;
import org.apache.asterix.testframework.xml.TestGroup;
import org.apache.asterix.testframework.xml.TestSuite;
import org.apache.asterix.testframework.xml.TestSuiteParser;

public class TestCaseContext {
    public static final String DEFAULT_TESTSUITE_XML_NAME = "testsuite.xml";
    public static final String ONLY_TESTSUITE_XML_NAME = "only.xml";
    public static final String DEFAULT_REPEADED_TESTSUITE_XML_NAME = "repeatedtestsuite.xml";
    private File tsRoot;
    private TestSuite testSuite;
    private TestGroup[] testGroups;
    private TestCase testCase;

    public TestCaseContext(File tsRoot, TestSuite testSuite, TestGroup[] testGroups, TestCase testCase) {
        this.tsRoot = tsRoot;
        this.testSuite = testSuite;
        this.testGroups = testGroups;
        this.testCase = testCase;
    }

    public File getTsRoot() {
        return this.tsRoot;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public TestGroup[] getTestGroups() {
        return this.testGroups;
    }

    public TestCase getTestCase() {
        return this.testCase;
    }

    public List<TestFileContext> getFilesInDir(String basePath, String dirName, boolean withType) {
        ArrayList<TestFileContext> testFileCtxs = new ArrayList<TestFileContext>();
        File path = this.tsRoot;
        path = new File(path, basePath);
        path = new File(path, this.testCase.getFilePath());
        if ((path = new File(path, dirName)).isDirectory()) {
            String[] fileNames;
            for (String fName : fileNames = path.list()) {
                if (fName.startsWith(".")) continue;
                File testFile = new File(path, fName);
                TestFileContext tfsc = new TestFileContext(testFile);
                String[] nameSplits = fName.split("\\.");
                if (nameSplits.length < 3) {
                    throw new IllegalArgumentException("Test file '" + dirName + File.separatorChar + fName + "' does not have the proper test file name format.");
                }
                if (withType) {
                    tfsc.setSeqNum(nameSplits[nameSplits.length - 3]);
                    tfsc.setType(nameSplits[nameSplits.length - 2]);
                } else {
                    tfsc.setSeqNum(nameSplits[nameSplits.length - 2]);
                }
                testFileCtxs.add(tfsc);
            }
        }
        Collections.sort(testFileCtxs);
        return testFileCtxs;
    }

    public List<TestFileContext> getTestFiles(TestCase.CompilationUnit cUnit) {
        return this.getFilesInDir(this.testSuite.getQueryOffsetPath(), cUnit.getName(), true);
    }

    public List<TestFileContext> getExpectedResultFiles(TestCase.CompilationUnit cUnit) {
        return this.getFilesInDir(this.testSuite.getResultOffsetPath(), cUnit.getOutputDir().getValue(), false);
    }

    public File getActualResultFile(TestCase.CompilationUnit cUnit, File actualResultsBase) {
        File path = actualResultsBase;
        path = new File(path, this.testSuite.getResultOffsetPath());
        path = new File(path, this.testCase.getFilePath());
        return new File(path, cUnit.getOutputDir().getValue() + "." + OutputFormat.forCompilationUnit(cUnit).extension());
    }

    public static class Builder {
        private final boolean m_doSlow = System.getProperty("runSlowAQLTests", "false").equals("true");
        private final Pattern m_re;

        public Builder() {
            String re = System.getProperty("testre");
            this.m_re = re == null ? null : Pattern.compile(re);
        }

        public List<TestCaseContext> build(File tsRoot) throws Exception {
            return this.build(tsRoot, TestCaseContext.DEFAULT_TESTSUITE_XML_NAME);
        }

        public List<TestCaseContext> build(File tsRoot, String tsXMLFilePath) throws Exception {
            File tsFile = new File(tsRoot, tsXMLFilePath);
            TestSuiteParser tsp = new TestSuiteParser();
            TestSuite ts = tsp.parse(tsFile);
            ArrayList<TestCaseContext> tccs = new ArrayList<TestCaseContext>();
            ArrayList<TestGroup> tgPath = new ArrayList<TestGroup>();
            this.addContexts(tsRoot, ts, tgPath, ts.getTestGroup(), tccs);
            return tccs;
        }

        private void addContexts(File tsRoot, TestSuite ts, List<TestGroup> tgPath, List<TestGroup> testGroups, List<TestCaseContext> tccs) {
            for (TestGroup tg : testGroups) {
                tgPath.add(tg);
                this.addContexts(tsRoot, ts, tgPath, tccs);
                tgPath.remove(tgPath.size() - 1);
            }
        }

        private void addContexts(File tsRoot, TestSuite ts, List<TestGroup> tgPath, List<TestCaseContext> tccs) {
            TestGroup tg = tgPath.get(tgPath.size() - 1);
            for (TestCase tc : tg.getTestCase()) {
                if (!this.m_doSlow && tc.getCategory() == CategoryEnum.SLOW) continue;
                boolean matches = false;
                if (this.m_re != null) {
                    for (TestCase.CompilationUnit cu : tc.getCompilationUnit()) {
                        if (!this.m_re.matcher(cu.getName()).find()) continue;
                        matches = true;
                        break;
                    }
                } else {
                    matches = true;
                }
                if (!matches) continue;
                tccs.add(new TestCaseContext(tsRoot, ts, tgPath.toArray(new TestGroup[tgPath.size()]), tc));
            }
            this.addContexts(tsRoot, ts, tgPath, tg.getTestGroup(), tccs);
        }
    }

    public static final class OutputFormat
    extends Enum<OutputFormat> {
        public static final /* enum */ OutputFormat NONE = new OutputFormat("", "");
        public static final /* enum */ OutputFormat ADM = new OutputFormat("adm", "application/x-adm");
        public static final /* enum */ OutputFormat JSON = new OutputFormat("json", "application/json");
        public static final /* enum */ OutputFormat CSV = new OutputFormat("csv", "text/csv");
        public static final /* enum */ OutputFormat CSV_HEADER = new OutputFormat("csv-header", "text/csv; header=present");
        private final String extension;
        private final String mimetype;
        private static final /* synthetic */ OutputFormat[] $VALUES;

        public static OutputFormat[] values() {
            return (OutputFormat[])$VALUES.clone();
        }

        public static OutputFormat valueOf(String name) {
            return Enum.valueOf(OutputFormat.class, name);
        }

        private OutputFormat(String ext, String mime) {
            this.extension = ext;
            this.mimetype = mime;
        }

        public String extension() {
            return this.extension;
        }

        public String mimeType() {
            return this.mimetype;
        }

        public static OutputFormat forCompilationUnit(TestCase.CompilationUnit cUnit) {
            switch (cUnit.getOutputDir().getCompare()) {
                case TEXT: {
                    return ADM;
                }
                case JSON: {
                    return JSON;
                }
                case CSV: {
                    return CSV;
                }
                case CSV_HEADER: {
                    return CSV_HEADER;
                }
                case INSPECT: 
                case IGNORE: {
                    return NONE;
                }
            }
            assert (false) : "Unknown ComparisonEnum!";
            return NONE;
        }

        static {
            $VALUES = new OutputFormat[]{NONE, ADM, JSON, CSV, CSV_HEADER};
        }
    }
}

